/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.google.common.base.Preconditions;
import com.timestored.connections.ConnectionManager;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int PAD = 10;
    private static final int WIDTH = 600;
    private static final int HEIGHT = 400;
    private final JTextField usernameField;
    private final JPasswordField passwordField;
    private final ConnectionManager conMan;

    public LoginDialog(ConnectionManager connectionManager, JFrame frame) {
        this.conMan = Preconditions.checkNotNull(connectionManager);
        this.setTitle("Default Database Server Login");
        this.setSize(600, 400);
        this.setIconImage(Theme.CIcon.SET_PASSWORD.get().getImage());
        this.setLayout(new BorderLayout());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        SwingUtils.addEscapeCloseListener(this);
        Box panel = Box.createVerticalBox();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String passTooltip = "Any servers that do not have a username / password specified will use these credentials.";
        this.usernameField = new JTextField(20);
        this.passwordField = new JPasswordField(20);
        this.usernameField.addActionListener(l -> this.saveAndClose());
        this.passwordField.addActionListener(l -> this.saveAndClose());
        panel.add(panel.createVerticalGlue());
        JLabel tooltipLabelA = new JLabel(Theme.CIcon.INFO.get());
        tooltipLabelA.setToolTipText(passTooltip);
        panel.add(Theme.getFormRow(this.usernameField, "Username:", passTooltip, tooltipLabelA));
        panel.add(Box.createVerticalStrut(20));
        panel.add(Theme.getFormRow(this.passwordField, "Password:", passTooltip));
        panel.add(panel.createVerticalGlue());
        this.add((Component)panel, "Center");
        this.add((Component)this.getCloseSaveBox(), "South");
        this.setLocationRelativeTo(frame);
        this.refresh();
        this.setVisible(true);
    }

    private void refresh() {
        this.usernameField.setText(this.conMan.getDefaultLoginUsername());
        this.passwordField.setText(this.conMan.getDefaultLoginPassword());
    }

    private void saveSettings() {
        this.conMan.setDefaultLogin(this.usernameField.getText(), this.passwordField.getText());
    }

    private void saveAndClose() {
        this.saveSettings();
        this.setVisible(false);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private Box getCloseSaveBox() {
        JButton closeButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.setVisible(false);
                LoginDialog.this.dispatchEvent(new WindowEvent(LoginDialog.this, 201));
            }
        });
        JButton saveButton = new JButton(new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.saveAndClose();
            }
        });
        Box closeBox = Box.createHorizontalBox();
        closeBox.add(Box.createHorizontalGlue());
        closeBox.add(saveButton);
        closeBox.add(Box.createHorizontalGlue());
        closeBox.add(closeButton);
        closeBox.add(Box.createHorizontalGlue());
        return closeBox;
    }
}

