/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.timestored.connections.ConnectionManager;
import com.timestored.connections.DBTestRunner;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.connections.ServerConfigBuilder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.h2.tools.Server;

class H2DBTestRunner
implements DBTestRunner {
    private static final int PORT = 8000;
    private static ConnectionManager csManager;
    private static Server server;
    private static ServerConfig serverConfig;

    private H2DBTestRunner() {
    }

    public static DBTestRunner getInstance() {
        return new H2DBTestRunner();
    }

    @Override
    public ConnectionManager start() throws SQLException {
        try {
            Class.forName("org.h2.Driver");
            Connection memConn = DriverManager.getConnection("jdbc:h2:mem:db1", "", "");
            Thread.sleep(2000L);
            server = Server.createTcpServer("-tcpPort", "8000", "-tcpAllowOthers").start();
            csManager = ConnectionManager.newInstance();
            serverConfig = new ServerConfigBuilder(new ServerConfig("localhost", 8000)).setName("h2Server").setJdbcType(JdbcTypes.H2).setDatabase("mem:db1").build();
            csManager.addServer(serverConfig);
            return csManager;
        }
        catch (ClassNotFoundException | InterruptedException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void stop() {
        server.stop();
    }

    @Override
    public ServerConfig getServerConfig() {
        return serverConfig;
    }
}

