/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.google.common.base.Preconditions;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.DBTestRunner;
import com.timestored.connections.H2DBTestRunner;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbTestHelper;
import java.io.IOException;
import java.sql.SQLException;

public class DBTestRunnerFactory {
    public static DBTestRunner getDbRunner(JdbcTypes jdbcType) {
        Preconditions.checkNotNull(jdbcType);
        if (jdbcType.equals((Object)JdbcTypes.H2)) {
            return H2DBTestRunner.getInstance();
        }
        if (jdbcType.equals((Object)JdbcTypes.KDB)) {
            return KdbDBTestRunner.INSTANCE;
        }
        return null;
    }

    private static class KdbDBTestRunner
    implements DBTestRunner {
        private static KdbDBTestRunner INSTANCE = new KdbDBTestRunner();

        private KdbDBTestRunner() {
        }

        @Override
        public ConnectionManager start() throws SQLException {
            try {
                return KdbTestHelper.getNewConnectedMangager();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            catch (InterruptedException e) {
                throw new SQLException(e);
            }
        }

        @Override
        public void stop() {
            try {
                KdbTestHelper.killAnyOpenProcesses();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public ServerConfig getServerConfig() {
            return KdbTestHelper.SERVER_CONFIG;
        }
    }
}

