/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.google.common.base.Preconditions;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConnectionShortFormat {
    public static List<ParseResult> parse(String serverEntries, JdbcTypes defaultServerType, JdbcTypes[] permittedJdbcTypes) {
        Preconditions.checkNotNull(defaultServerType);
        Preconditions.checkNotNull(permittedJdbcTypes);
        HashSet<JdbcTypes> permittedTypes = new HashSet<JdbcTypes>(Arrays.asList(permittedJdbcTypes));
        Preconditions.checkArgument(permittedTypes.contains((Object)defaultServerType));
        String[] serverLines = serverEntries.split("\n");
        ArrayList<ParseResult> r = new ArrayList<ParseResult>(serverLines.length);
        for (int i = 0; i < serverLines.length; ++i) {
            String l = serverLines[i].trim();
            if (l.length() <= 0) continue;
            r.add(ConnectionShortFormat.parseLine(defaultServerType, permittedTypes, l));
        }
        return r;
    }

    private static ParseResult parseLine(JdbcTypes defaultServerType, Set<JdbcTypes> permittedTypes, String line) {
        ParseResult pr;
        String l = line;
        String name = "";
        try {
            String[] p;
            int atPos = l.indexOf("@");
            if (atPos > -1) {
                name = l.substring(0, atPos).trim();
                l = l.substring(atPos + 1).trim();
            }
            if ((p = l.split(":")).length >= 2) {
                String host = p[0];
                int port = Integer.parseInt(p[1]);
                int lastSlash = host.lastIndexOf("/");
                if (lastSlash > -1) {
                    name = host + ":" + port;
                    host = host.substring(lastSlash + 1);
                }
                String username = "";
                String password = "";
                JdbcTypes jtype = defaultServerType;
                int hashPos = host.indexOf("#");
                if (hashPos > -1) {
                    jtype = JdbcTypes.valueOf(host.substring(0, hashPos).trim());
                    if (!permittedTypes.contains((Object)jtype)) {
                        throw new IllegalArgumentException("Illegal JDBC connection type");
                    }
                    host = host.substring(hashPos + 1).trim();
                }
                if (p.length >= 3) {
                    username = p[2].trim();
                }
                if (p.length >= 4) {
                    password = p[3].trim();
                }
                pr = new ParseResult(l, new ServerConfig(host, port, username, password, name, jtype));
            } else {
                pr = new ParseResult(l, "No : Found so could not parse hostname:port");
            }
        }
        catch (NumberFormatException nfe) {
            pr = new ParseResult(l, "Error parsing number in definition");
        }
        catch (IllegalArgumentException iae) {
            pr = new ParseResult(l, "Error parsing: " + iae.getMessage());
        }
        return pr;
    }

    public static String compose(List<ServerConfig> serverConfs, JdbcTypes defaultServerType) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < serverConfs.size(); ++i) {
            if (i > 0) {
                sb.append("\r\n");
            }
            ServerConfig sc = serverConfs.get(i);
            String hp = sc.getHost() + ":" + sc.getPort();
            if (!sc.getName().equals(hp)) {
                sb.append(sc.getName()).append("@");
            }
            if (!defaultServerType.equals((Object)sc.getJdbcType())) {
                sb.append(sc.getJdbcType().name()).append("#");
            }
            sb.append(hp);
            if (!sc.getUsername().isEmpty() || !sc.getPassword().isEmpty()) {
                sb.append(":").append(sc.getUsername());
            }
            if (sc.getPassword().isEmpty()) continue;
            sb.append(":").append(sc.getPassword());
        }
        return sb.toString();
    }

    public static class ParseResult {
        public final ServerConfig serverConfig;
        public final String report;
        public final String originalLine;

        public ParseResult(String originalLine, ServerConfig serverConfig) {
            this(originalLine, serverConfig, "");
        }

        public ParseResult(String originalLine, String error) {
            this(originalLine, null, error);
        }

        private ParseResult(String originalLine, ServerConfig serverConfig, String error) {
            this.serverConfig = serverConfig;
            this.report = error;
            this.originalLine = Preconditions.checkNotNull(originalLine);
        }
    }
}

