/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.google.common.base.Preconditions;
import com.timestored.TimeStored;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.JdbcIcons;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.Msg;
import com.timestored.connections.ServerConfig;
import com.timestored.connections.ServerConfigBuilder;
import com.timestored.misc.InfoLink;
import com.timestored.misc.TextWrapper;
import com.timestored.plugins.PluginLoader;
import com.timestored.swingxx.ColorChooserPanel;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ConnectionManagerDialog
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(ConnectionManagerDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private static final Theme.InputLabeller INPUT_LABELLER = Theme.getInputLabeller(80, 20);
    private static final int DEF_COLUMNS = 40;
    private final ConnectionManager conMan;
    private final JTextField hostTextField;
    private final JTextField portTextField;
    private final JPasswordField passwordTextField;
    private final JTextField usernameTextField;
    private final JTextField nameTextField;
    private final JComboBox serverTypeComboBox;
    private final JCheckBox useTLSCheckbox;
    private final Box useTLSBox;
    private final JCheckBox useAsyncCheckbox;
    private final Box useAsyncBox;
    private final List<JdbcTypes> jdbcTypesShown;
    private final List<String> niceDBnames;
    private final ColorChooserPanel colorChooserPanel;
    private final JTextField databaseTextField;
    private JPanel hostPanel;
    private JPanel portPanel;
    private final JPanel databasePanel;
    private JPanel loginPanel;
    private JComboBox folderComboBox;
    private final String serverName;
    private ServerConfig serverConfig;
    private final HighlightTextField urlTextField;
    private final JRadioButton hostButton;
    private final JRadioButton urlButton;
    public static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();

    public ConnectionManagerDialog(ConnectionManager connectionManager, JFrame parent, String serverName) {
        super((Frame)parent, "Server Properties");
        List<JdbcTypes> allDBs = Arrays.asList(JdbcTypes.values());
        Collections.sort(allDBs, (a, b) -> a.equals(b) ? 0 : (a.equals((Object)JdbcTypes.KDB) ? -1 : (b.equals((Object)JdbcTypes.KDB) ? 1 : a.getNiceName().compareTo(b.getNiceName()))));
        HashMap<String, JdbcIcons> jdbcNameToIcon = new HashMap<String, JdbcIcons>();
        this.niceDBnames = new ArrayList<String>();
        allDBs.stream().forEach(j -> {
            if (j.isAvailable()) {
                this.niceDBnames.add(j.getNiceName());
                jdbcNameToIcon.put(j.getNiceName(), JdbcIcons.getIconFor(j));
            }
        });
        this.niceDBnames.add("--------------------");
        allDBs.stream().forEach(j -> {
            if (!j.isAvailable()) {
                this.niceDBnames.add(j.getNiceName());
                jdbcNameToIcon.put(j.getNiceName(), JdbcIcons.getIconFor(j));
            }
        });
        this.jdbcTypesShown = allDBs;
        this.setIconImage(Theme.CIcon.SERVER_EDIT.get().getImage());
        this.serverName = serverName;
        this.conMan = Preconditions.checkNotNull(connectionManager);
        this.serverConfig = null;
        if (serverName != null) {
            this.serverConfig = this.conMan.getServer(serverName);
            if (this.serverConfig == null) {
                throw new IllegalArgumentException("Server not found in Connection Manager");
            }
        }
        this.setResizable(false);
        SwingUtils.setSensibleDimensions(parent, this);
        this.setLocationRelativeTo(parent);
        this.setLayout(new BorderLayout());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        Box cp = Box.createVerticalBox();
        SwingUtils.addEscapeCloseListener(this);
        JPanel connPanel = new JPanel();
        connPanel.setBorder(new TitledBorder(null, "Connection", 4, 2, null, null));
        connPanel.setLayout(new BoxLayout(connPanel, 3));
        this.serverTypeComboBox = new JComboBox<String>(this.niceDBnames.toArray(new String[0]));
        this.serverTypeComboBox.setRenderer(new IconListRenderer(jdbcNameToIcon));
        connPanel.add(INPUT_LABELLER.get("Server Type:", this.serverTypeComboBox, "serverTypeDropdown"));
        Component verticalBox = Box.createVerticalStrut(10);
        connPanel.add(verticalBox);
        this.hostButton = new JRadioButton("Host");
        this.urlButton = new JRadioButton("URL");
        this.hostButton.setBounds(75, 50, 100, 30);
        this.urlButton.setBounds(75, 100, 100, 30);
        ButtonGroup bg = new ButtonGroup();
        this.hostButton.setSelected(true);
        bg.add(this.hostButton);
        bg.add(this.urlButton);
        JPanel radioPanel = new JPanel(new FlowLayout(0));
        radioPanel.add(this.hostButton);
        radioPanel.add(this.urlButton);
        connPanel.add(INPUT_LABELLER.get("Connect By:", radioPanel, "radioPanel"));
        this.urlTextField = new HighlightTextField("jdbc:");
        this.urlTextField.setColumns(40);
        this.urlTextField.addActionListener(this);
        connPanel.add(INPUT_LABELLER.get("<html><b>URL</b></html>", this.urlTextField, "urlTextField"));
        this.hostTextField = new HighlightTextField("localhost");
        this.hostTextField.setColumns(40);
        this.hostTextField.addActionListener(this);
        String hostLbl = "<html><b>" + Msg.get(Msg.Key.HOST) + ":</b></html>";
        this.hostPanel = INPUT_LABELLER.get(hostLbl, this.hostTextField, "hostField");
        connPanel.add(this.hostPanel);
        this.portTextField = new HighlightTextField("5000");
        this.portTextField.setColumns(10);
        this.portTextField.addActionListener(this);
        this.portPanel = INPUT_LABELLER.get("<html><b>" + Msg.get(Msg.Key.PORT) + ":</b></html>", this.portTextField, "portField");
        connPanel.add(this.portPanel);
        this.nameTextField = new HighlightTextField("");
        String nameLbl = "<html><b>Name:</b></html>";
        connPanel.add(INPUT_LABELLER.get(nameLbl, this.nameTextField, "serverNameField"));
        this.nameTextField.addActionListener(this);
        this.useTLSCheckbox = new JCheckBox();
        String tlsTooltipText = "<html>Since V3.4t 2016.05.12, kdb+ can use Secure Sockets Layer (SSL)/Transport Layer Security (TLS)<br> to encrypt connections using the OpenSSL libraries.</html>";
        JLabel tlsButton = InfoLink.getLabel("", "See SSL/TLS Docs", TimeStored.Page.QSTUDIO_HELP_SSL, true);
        this.useTLSBox = Theme.getFormRow(this.useTLSCheckbox, "Use kdb+ TLS", tlsTooltipText, tlsButton);
        connPanel.add(this.useTLSBox);
        this.useAsyncCheckbox = new JCheckBox();
        JLabel asyncWarningLabel = new JLabel(Theme.CIcon.WARNING.get16());
        String asyncTooltipText = "<html>Send messages asynchronously then force sync.<br>This setting is experimental, please report any issues.</html>";
        asyncWarningLabel.setToolTipText(asyncTooltipText);
        this.useAsyncBox = Theme.getFormRow(this.useAsyncCheckbox, "Use kdb+ Async", asyncTooltipText, asyncWarningLabel);
        this.databasePanel = new JPanel(new FlowLayout(0));
        this.serverTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String niceName = (String)ConnectionManagerDialog.this.serverTypeComboBox.getSelectedItem();
                JdbcTypes t = ConnectionManagerDialog.this.jdbcTypesShown.stream().filter(j -> j.getNiceName().equals(niceName)).findFirst().get();
                boolean isEmbed = t.getDefaultPort() == 0;
                ConnectionManagerDialog.this.urlButton.setSelected(isEmbed);
                ConnectionManagerDialog.this.hostButton.setSelected(!isEmbed);
                ConnectionManagerDialog.this.enableHostPort(!isEmbed);
                ConnectionManagerDialog.this.useTLSBox.setVisible(t.isKDB());
                ConnectionManagerDialog.this.useAsyncBox.setVisible(t.isKDB());
                ConnectionManagerDialog.this.databasePanel.setVisible(t.isDatabaseRequired());
                ConnectionManagerDialog.this.portTextField.setText("" + t.getDefaultPort());
                ConnectionManagerDialog.this.urlTextField.setText("" + t.getSampleURL());
            }
        });
        connPanel.add(this.databasePanel);
        this.databaseTextField = new HighlightTextField("");
        this.databasePanel.add(INPUT_LABELLER.get(Msg.get(Msg.Key.DATABASE) + ":", this.databaseTextField, "dbField"));
        this.loginPanel = new JPanel();
        this.loginPanel.setBorder(new TitledBorder(null, "Login", 4, 2, null, null));
        this.loginPanel.setLayout(new BoxLayout(this.loginPanel, 3));
        this.usernameTextField = new HighlightTextField("");
        this.usernameTextField.addActionListener(this);
        this.loginPanel.add(INPUT_LABELLER.get(Msg.get(Msg.Key.USERNAME) + ":", this.usernameTextField, "usernameField"));
        this.passwordTextField = new JPasswordField(40);
        this.loginPanel.add(INPUT_LABELLER.get(Msg.get(Msg.Key.PASSWORD) + ":", this.passwordTextField, "passwordField"));
        this.passwordTextField.setColumns(40);
        this.passwordTextField.addActionListener(this);
        JPanel nameColorPanel = new JPanel();
        nameColorPanel.setBorder(new EtchedBorder(1, null, null));
        nameColorPanel.setLayout(new BoxLayout(nameColorPanel, 3));
        this.colorChooserPanel = new ColorChooserPanel(this);
        this.colorChooserPanel.setColor(ServerConfig.DEFAULT_COLOR);
        nameColorPanel.add(INPUT_LABELLER.get("Background:", this.colorChooserPanel, "colorButton"));
        this.folderComboBox = new JComboBox();
        this.folderComboBox.setEditable(true);
        nameColorPanel.add(INPUT_LABELLER.get("Folder:", this.folderComboBox, "folderComboBox"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(Theme.makeButton(this.serverConfig == null ? Msg.get(Msg.Key.ADD) : Msg.get(Msg.Key.SAVE), this));
        if (this.serverConfig != null) {
            ActionListener deleteListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ConnectionManagerDialog parent = ConnectionManagerDialog.this;
                    try {
                        int reply = JOptionPane.showConfirmDialog(parent, "Are you sure you want to delete this server?");
                        if (reply == 0) {
                            ConnectionManagerDialog.this.conMan.removeServer(ConnectionManagerDialog.this.serverConfig);
                            ConnectionManagerDialog.this.closeDialog();
                        }
                    }
                    catch (Exception e) {
                        String msg = "Possible problem deleting server.";
                        JOptionPane.showMessageDialog(parent, msg, "Delete error", 0);
                        LOG.log(Level.SEVERE, msg, e);
                    }
                }
            };
            buttonPanel.add(Theme.makeButton(Msg.get(Msg.Key.DELETE), deleteListener));
        }
        AbstractAction dispatchTest = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionManagerDialog parent = ConnectionManagerDialog.this;
                ServerConfig newSC = ConnectionManagerDialog.this.newServerConfig();
                try {
                    ConnectionManagerDialog.this.conMan.testConnection(newSC);
                    String message = "Connection works";
                    JOptionPane.showMessageDialog(parent, message);
                }
                catch (IOException ioe) {
                    if (ioe.toString().contains("ClassNotFoundException")) {
                        ConnectionManagerDialog.offerToInstallDriver(newSC.getJdbcType(), ConnectionManagerDialog.this);
                    }
                    String message = "Connection does not work.";
                    String fullMsg = TextWrapper.forWidth(80).hard().wrap(message + " " + ioe.toString());
                    JOptionPane.showMessageDialog(parent, fullMsg, message, 2);
                    LOG.log(Level.INFO, message, ioe);
                }
            }
        };
        buttonPanel.add(Theme.makeButton("Test", dispatchTest));
        AbstractAction dispatchClose = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionManagerDialog d = ConnectionManagerDialog.this;
                d.dispatchEvent(new WindowEvent(d, 201));
            }
        };
        buttonPanel.add(Theme.makeButton(Msg.get(Msg.Key.CANCEL), dispatchClose));
        cp.add(connPanel);
        cp.add(this.loginPanel);
        cp.add(nameColorPanel);
        this.add(SwingUtils.verticalScrollPane(cp), "Center");
        buttonPanel.setAlignmentX(0.5f);
        this.add((Component)buttonPanel, "South");
        this.hostButton.addActionListener(e -> {
            this.enableHostPort(true);
            this.hostTextField.setText("");
            if (this.portTextField.getText().equals("0")) {
                String p = this.serverConfig == null ? "1233" : "" + this.serverConfig.getJdbcType().getDefaultPort();
                this.portTextField.setText(p);
            }
        });
        this.urlButton.addActionListener(e -> {
            this.enableHostPort(false);
            this.portTextField.setText("0");
        });
        SwingUtils.addEscapeCloseListener(this);
        this.showConnection(this.serverConfig);
    }

    private void enableHostPort(boolean enableHostPort) {
        this.hostPanel.setVisible(enableHostPort);
        this.portPanel.setVisible(enableHostPort);
        String niceName = (String)this.serverTypeComboBox.getSelectedItem();
        JdbcTypes t = this.jdbcTypesShown.stream().filter(j -> j.getNiceName().equals(niceName)).findFirst().get();
        this.databasePanel.setVisible(enableHostPort && t.isDatabaseRequired());
        this.urlTextField.setEnabled(!enableHostPort);
        this.urlTextField.setEditable(!enableHostPort);
    }

    protected void closeDialog() {
        WindowEvent wev = new WindowEvent(this, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
    }

    private void showConnection(ServerConfig sc) {
        this.enableHostPort(true);
        this.hostButton.setSelected(true);
        this.urlButton.setSelected(false);
        if (sc != null) {
            this.serverTypeComboBox.setSelectedItem(sc.getJdbcType().getNiceName());
            this.hostTextField.setText(sc.getHost());
            this.portTextField.setText("" + sc.getPort());
            this.usernameTextField.setText(sc.getUsername());
            this.passwordTextField.setText(sc.getPassword());
            this.loginPanel.setVisible(!sc.getJdbcType().equals((Object)JdbcTypes.DUCKDB));
            this.nameTextField.setText(sc.getShortName());
            this.databaseTextField.setText(sc.getDatabase());
            this.urlTextField.setText(sc.getJdbcType().getSampleURL());
            this.colorChooserPanel.setColor(sc.getColor());
            this.databasePanel.setVisible(sc.getJdbcType().isDatabaseRequired());
            this.setFolder(sc.getFolder());
            this.useAsyncCheckbox.setSelected(sc.isUseAsync());
            this.useTLSCheckbox.setSelected(sc.isUseTLS());
            if (sc.getPort() == 0) {
                this.enableHostPort(false);
                this.hostButton.setSelected(false);
                this.urlButton.setSelected(true);
                this.databaseTextField.setText("");
                this.urlTextField.setText(sc.getDatabase());
            }
        } else {
            this.folderComboBox.setSelectedItem("");
            if (this.conMan.isDefaultLoginSet()) {
                this.usernameTextField.setText(this.conMan.getDefaultLoginUsername());
                this.passwordTextField.setText(this.conMan.getDefaultLoginPassword());
            }
        }
    }

    private ServerConfig newServerConfig() {
        String niceName = (String)this.serverTypeComboBox.getSelectedItem();
        JdbcTypes t = this.jdbcTypesShown.stream().filter(j -> j.getNiceName().equals(niceName)).findFirst().get();
        String host = this.hostTextField.getText().trim();
        int port = Integer.parseInt(this.portTextField.getText().trim());
        String username = this.usernameTextField.getText();
        String password = new String(this.passwordTextField.getPassword());
        String folder = this.folderComboBox != null ? (String)this.folderComboBox.getSelectedItem() : "";
        String name = this.nameTextField.getText();
        String database = this.databaseTextField.getText();
        Color c2 = this.colorChooserPanel.getColor();
        if (c2 == ServerConfig.DEFAULT_COLOR) {
            c2 = null;
        }
        if (this.urlButton.isSelected()) {
            port = 0;
            database = this.urlTextField.getText();
        }
        boolean useTLS = this.useTLSCheckbox.isSelected();
        boolean useAsync = this.useAsyncCheckbox.isSelected();
        return new ServerConfig(host, port, username, password, name, t, c2, database, folder, useTLS, useAsync);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.serverConfig != null) {
                this.conMan.updateServer(this.serverName, this.newServerConfig());
            } else {
                ServerConfig sc;
                block9: {
                    sc = this.newServerConfig();
                    if (!this.conMan.isDefaultLoginSet()) {
                        this.conMan.setDefaultLogin(sc.getUsername(), sc.getPassword());
                    } else if (sc.getUsername().equals(this.conMan.getDefaultLoginUsername()) && sc.getPassword().equals(this.conMan.getDefaultLoginPassword())) {
                        sc = new ServerConfigBuilder(sc).setUsername("").setPassword("").build();
                    }
                    this.conMan.addServer(sc);
                    try {
                        this.conMan.testConnection(sc);
                    }
                    catch (IOException e1) {
                        if (!e1.toString().contains("ClassNotFoundException")) break block9;
                        ConnectionManagerDialog.offerToInstallDriver(sc.getJdbcType(), this);
                    }
                }
                this.serverConfig = sc;
            }
            this.closeDialog();
        }
        catch (IllegalArgumentException ex) {
            String msg = "Error saving server changes. \r\n" + ex.getMessage();
            JOptionPane.showMessageDialog(this, msg, "Save error", 0);
            LOG.info(msg);
        }
    }

    public void setFolder(String selectedFolder) {
        HashSet<String> foldSet = new HashSet<String>(this.conMan.getFolders());
        foldSet.add("");
        foldSet.add(selectedFolder);
        String[] folders = foldSet.toArray(new String[0]);
        this.folderComboBox.setModel(new DefaultComboBoxModel<String>(folders));
        this.folderComboBox.setSelectedItem(selectedFolder);
    }

    public static void offerToInstallDriver(JdbcTypes jdbcTypes, Component c2) {
        String msg = "Would you like to download and install the JDBC driver for " + jdbcTypes.getNiceName();
        int choice = JOptionPane.showConfirmDialog(c2, msg, "Install Driver", 0, 3);
        if (choice == 0) {
            EXECUTOR.execute(() -> {
                try {
                    File f = PluginLoader.installDriver("QStudio", jdbcTypes);
                    JOptionPane.showMessageDialog(c2, "Driver installed to: " + f.getAbsolutePath() + " \nPlease try to rerun any previous queries.");
                }
                catch (Exception e1) {
                    List<String> urls = jdbcTypes.getDownloadURLs();
                    String html = "<html><body>Failed to download driver.";
                    if (urls.size() > 0) {
                        String url = urls.get(0);
                        html = html + "<br />Please download at: <a href='" + url + "'>" + url + " </a>";
                    }
                    html = html + "<br />Then follow these <a href='" + TimeStored.Page.QSTUDIO_HELP_DRIVER_DOWNLOAD_ERROR.url() + "'>data source driver instructions.</a>.<br />" + e1.getLocalizedMessage() + "</body></html>";
                    JOptionPane.showMessageDialog(c2, Theme.getHtmlText(html));
                }
            });
        }
    }

    class IconListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Map<String, JdbcIcons> jdbcNameToIcon;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JdbcIcons jdbcIcon;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String && (jdbcIcon = this.jdbcNameToIcon.get(value)) != null && jdbcIcon.get16() != null) {
                label.setIcon(jdbcIcon.get16());
            }
            return label;
        }

        public IconListRenderer(Map<String, JdbcIcons> jdbcNameToIcon) {
            this.jdbcNameToIcon = jdbcNameToIcon;
        }
    }

    private static class HighlightTextField
    extends JTextField {
        public HighlightTextField(String text) {
            this.setText(text);
            this.setColumns(40);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.selectAll();
            }
        }
    }
}

