/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.timestored.StringUtils;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.PreferenceHelper;
import com.timestored.connections.ServerConfig;
import com.timestored.connections.ServerConfigBuilder;
import com.timestored.connections.ServerConfigDTO;
import com.timestored.kdb.KdbConnection;
import com.timestored.plugins.ConnectionDetails;
import com.timestored.plugins.DatabaseAuthenticationService;
import com.timestored.plugins.PluginLoader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;

@ThreadSafe
public class ConnectionManager
implements AutoCloseable {
    public static String XML_ROOT = "serverlist";
    private static final Logger LOG = Logger.getLogger(ConnectionManager.class.getName());
    private static final XStream xstream = new XStream(new StaxDriver());
    private final List<ServerConfig> serverConns;
    private final Map<ServerConfig, ObjectPool<PoolableConnection>> serverConnPool;
    private final Map<ServerConfig, Boolean> serverConnected = new ConcurrentHashMap<ServerConfig, Boolean>();
    private final List<ServerConfig> readonlyServerConnections;
    private final CopyOnWriteArrayList<Listener> listeners;
    private final Object LOCK = new Object();
    private String defaultLoginUsername = null;
    private String defaultLoginPassword = null;
    private Preferences preferences;
    private String prefKey;
    private static final int MAX_STORAGE_SLOTS = 20;
    public static final String APP_TITLE = "QStudio";
    private static String appname;

    @Override
    public void close() {
        HashMap<ServerConfig, ObjectPool<PoolableConnection>> mapCopy = new HashMap<ServerConfig, ObjectPool<PoolableConnection>>(this.serverConnPool);
        for (ServerConfig sc : mapCopy.keySet()) {
            this.closePool(sc);
        }
        this.serverConnPool.clear();
        this.notifyListeners();
    }

    public void closePool(ServerConfig sc) {
        ObjectPool<PoolableConnection> op = this.serverConnPool.remove(sc);
        if (op != null) {
            try {
                op.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                op.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverConnected.put(sc, Boolean.FALSE);
    }

    public static ConnectionManager newInstance() {
        return new ConnectionManager();
    }

    private ConnectionManager() {
        this.serverConnPool = new HashMap<ServerConfig, ObjectPool<PoolableConnection>>();
        this.serverConns = new CopyOnWriteArrayList<ServerConfig>();
        this.readonlyServerConnections = Collections.unmodifiableList(this.serverConns);
        this.listeners = new CopyOnWriteArrayList();
    }

    public void setPreferenceStore(Preferences preferences, String prefKeyPrefix) {
        this.preferences = preferences;
        this.prefKey = prefKeyPrefix;
        this.reloadFromPreferences();
    }

    public List<ServerConfig> getServerConnections() {
        ArrayList<ServerConfig> r = new ArrayList<ServerConfig>(this.readonlyServerConnections);
        Comparator<ServerConfig> alphabetOrder = new Comparator<ServerConfig>(){

            @Override
            public int compare(ServerConfig sc1, ServerConfig sc2) {
                return sc1.getName().compareTo(sc2.getName());
            }
        };
        Collections.sort(r, alphabetOrder);
        return r;
    }

    public List<String> getServerNames() {
        ArrayList<String> s = Lists.newArrayList();
        for (ServerConfig sc : this.getServerConnections()) {
            s.add(sc.getName());
        }
        return Collections.unmodifiableList(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerSilently(ServerConfig serverConnection) {
        Preconditions.checkNotNull(serverConnection);
        Object object = this.LOCK;
        synchronized (object) {
            String name = serverConnection.getName();
            ServerConfig existingSC = this.getServer(name);
            if (existingSC != null) {
                if (existingSC.equals(serverConnection)) {
                    return;
                }
                throw new IllegalArgumentException("Server name must be unique. Cant use this call to update settings.");
            }
            this.serverConns.add(serverConnection);
            this.serverConnected.put(serverConnection, Boolean.FALSE);
            LOG.info("added server: " + serverConnection.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(ServerConfig serverConnection) {
        Object object = this.LOCK;
        synchronized (object) {
            this.reloadFromPreferences();
            this.addServerSilently(serverConnection);
            this.save();
        }
        this.notifyListenersServerAdded(serverConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerConfig> addServer(List<ServerConfig> connections) {
        ArrayList<ServerConfig> failedConfigs = new ArrayList<ServerConfig>();
        Object object = this.LOCK;
        synchronized (object) {
            this.reloadFromPreferences();
            Preconditions.checkNotNull(connections);
            for (ServerConfig sc2 : connections) {
                try {
                    this.addServerSilently(sc2);
                }
                catch (IllegalArgumentException iae) {
                    LOG.log(Level.WARNING, "Could not add sc: " + sc2.toString(), iae);
                    failedConfigs.add(sc2);
                }
            }
            this.save();
        }
        connections.forEach(sc -> this.notifyListenersServerAdded((ServerConfig)sc));
        return failedConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServer(String oldServerName, ServerConfig serverConnection) {
        String newName = serverConnection.getName();
        if (!newName.equals(oldServerName) && this.getServer(newName) != null) {
            throw new IllegalArgumentException("That server name is already taken.");
        }
        LOG.info("updateServer(" + oldServerName + " -> " + serverConnection + ")");
        ServerConfig existingSC = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.reloadFromPreferences();
            existingSC = this.getServer(oldServerName);
            if (existingSC != null) {
                this.serverConns.remove(existingSC);
                this.closePool(existingSC);
                this.statusUpdate(existingSC, false);
                this.serverConns.add(serverConnection);
                this.statusUpdate(serverConnection, false);
            }
            this.save();
        }
        LOG.info("updated server: " + serverConnection.toString());
        this.notifyListeners();
        if (existingSC == null) {
            throw new IllegalArgumentException("server does not exist already, so can't remove");
        }
    }

    public void moveServer(ServerConfig serverConfig, String folderName) {
        String f;
        Preconditions.checkNotNull(serverConfig);
        LOG.info("moveServer(" + serverConfig.getName() + " to " + folderName + ")");
        String string = f = folderName == null ? "" : folderName;
        if (!serverConfig.getFolder().equals(f)) {
            ServerConfig sc = new ServerConfigBuilder(serverConfig).setFolder(folderName).build();
            this.updateServer(serverConfig.getName(), sc);
        }
    }

    public boolean removeServer(String name) {
        ServerConfig sc = this.getServer(name);
        return sc != null ? this.removeServer(sc) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean[] removeServers(List<ServerConfig> serverConfigs) {
        if (serverConfigs.size() > 0) {
            boolean[] goners = new boolean[serverConfigs.size()];
            Object object = this.LOCK;
            synchronized (object) {
                this.reloadFromPreferences();
                for (int i = 0; i < serverConfigs.size(); ++i) {
                    ServerConfig sc = serverConfigs.get(i);
                    ObjectPool<PoolableConnection> objectPool = this.serverConnPool.remove(sc);
                    if (objectPool != null) {
                        try {
                            objectPool.clear();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.serverConnected.computeIfPresent(sc, (currentSC, present) -> false);
                    goners[i] = this.serverConns.remove(sc);
                    this.closePool(sc);
                    if (!goners[i]) continue;
                    LOG.info("removed server: " + serverConfigs.toString());
                }
                this.save();
            }
            this.notifyListeners();
            return goners;
        }
        return new boolean[0];
    }

    public boolean removeServer(ServerConfig serverConfig) {
        return this.removeServers(Lists.newArrayList(serverConfig))[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServers() {
        Object object = this.LOCK;
        synchronized (object) {
            this.serverConns.clear();
            this.save();
            LOG.info("removed all servers");
        }
        this.notifyListeners();
    }

    public Connection getConnection(String serverName) throws IOException {
        ServerConfig sc = this.getServer(serverName);
        if (sc != null) {
            return this.getConnection(this.getServer(serverName));
        }
        return null;
    }

    public boolean isConnected(String serverName) {
        return this.isConnected(this.getServer(serverName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolableConnection getConnection(ServerConfig serverConfig) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.serverConns.contains(serverConfig)) {
                return null;
            }
        }
        return this.getConn(serverConfig);
    }

    public boolean returnConn(ServerConfig serverConfig, PoolableConnection conn, boolean invalidateConnection) {
        ObjectPool<PoolableConnection> sp = this.serverConnPool.get(serverConfig);
        if (sp != null && conn != null) {
            try {
                if (conn.isClosed() || invalidateConnection) {
                    sp.invalidateObject(conn);
                } else {
                    sp.returnObject(conn);
                }
                return true;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "error returning object to pool", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolableConnection getConn(ServerConfig serverConfig) throws IOException {
        try {
            ObjectPool<PoolableConnection> connPool = null;
            Object object = this.LOCK;
            synchronized (object) {
                connPool = this.serverConnPool.get(serverConfig);
                if (connPool == null) {
                    ServerConfig sc = this.overrideServerConfig(serverConfig);
                    MyDriverManagerConnectionFactory connectionFactory = new MyDriverManagerConnectionFactory(sc);
                    PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, null);
                    connPool = new GenericObjectPool<PoolableConnection>(poolableConnectionFactory);
                    this.serverConnPool.put(serverConfig, connPool);
                }
            }
            PoolableConnection c2 = connPool.borrowObject();
            if (c2.isClosed()) {
                connPool.invalidateObject(c2);
                c2 = null;
            } else {
                this.statusUpdate(serverConfig, true);
            }
            return c2;
        }
        catch (Exception e) {
            if (this.serverConnected.containsKey(serverConfig)) {
                this.statusUpdate(serverConfig, false);
            }
            LOG.info("getConn Exception server: " + serverConfig.toString());
            throw new IOException(e);
        }
    }

    private ServerConfig overrideServerConfig(ServerConfig serverConfig) {
        DatabaseAuthenticationService dps;
        ServerConfig sc = serverConfig;
        if (!(serverConfig.hasLogin() || this.defaultLoginPassword == null && this.defaultLoginUsername == null)) {
            sc = new ServerConfigBuilder(serverConfig).setUsername(this.defaultLoginUsername).setPassword(this.defaultLoginPassword).build();
        }
        if ((dps = serverConfig.getJdbcType().getAuthenticator()) != null) {
            ConnectionDetails connDetails = dps.getonConnectionDetails(sc.getConnectionDetails());
            sc = new ServerConfigBuilder(serverConfig).setHost(connDetails.getHost()).setPort(connDetails.getPort()).setDatabase(connDetails.getDatabase()).setUsername(connDetails.getUsername()).setPassword(connDetails.getPassword()).build();
        }
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfig getServer(String serverName) {
        Preconditions.checkNotNull(serverName);
        Object object = this.LOCK;
        synchronized (object) {
            for (ServerConfig sc : this.serverConns) {
                if (!sc.getName().equals(serverName)) continue;
                return sc;
            }
        }
        return null;
    }

    private void notifyListeners() {
        for (Listener l : this.listeners) {
            try {
                l.prefChange();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "problem notifying listener.", e);
            }
        }
    }

    private void notifyListenersServerAdded(ServerConfig sc) {
        for (Listener l : this.listeners) {
            try {
                l.serverAdded(sc);
                l.prefChange();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "problem notifying listener.", e);
            }
        }
    }

    public void addListener(Listener prefListener) {
        this.listeners.add(prefListener);
    }

    public boolean removeListener(Listener prefListener) {
        return this.listeners.remove(prefListener);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serverConns", this.serverConns).add("listeners", this.listeners).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(ServerConfig serverConfig) throws IOException {
        boolean connected = false;
        PoolableConnection conn = this.getConn(serverConfig);
        try {
            connected = !conn.isClosed();
            this.returnConn(serverConfig, conn, !connected);
        }
        catch (SQLException e) {
            try {
                connected = false;
                this.returnConn(serverConfig, conn, !connected);
            }
            catch (Throwable throwable) {
                this.returnConn(serverConfig, conn, !connected);
                throw throwable;
            }
        }
        if (this.serverConns.contains(serverConfig)) {
            this.statusUpdate(serverConfig, connected);
        }
        if (!connected) {
            throw new IOException();
        }
    }

    public KdbConnection tryKdbConnection(String serverName) throws Exception {
        ServerConfig serverConfig = this.getServer(serverName);
        if (serverConfig == null) {
            throw new IllegalStateException("ConnectionManager cant find server named: " + serverName);
        }
        return this.tryKdbConnection(serverConfig);
    }

    private KdbConnection tryKdbConnection(ServerConfig serverConfig) throws Exception {
        if (serverConfig.isKDB()) {
            try {
                KdbConnection kdbConn = new KdbConnection(this.overrideServerConfig(serverConfig));
                this.statusUpdate(serverConfig, true);
                return kdbConn;
            }
            catch (Exception e) {
                this.statusUpdate(serverConfig, false);
                String text = "Could not connect to server: " + serverConfig.getHost() + ":" + serverConfig.getPort() + "\r\n Exception: " + e.toString();
                throw new IOException(text);
            }
        }
        throw new IllegalStateException("tryKdbConnection only works for kdb");
    }

    public KdbConnection getKdbConnection(ServerConfig serverConfig) {
        try {
            return this.tryKdbConnection(serverConfig);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void statusUpdate(ServerConfig serverConfig, boolean connected) {
        boolean change;
        Boolean prevVal = this.serverConnected.put(serverConfig, connected);
        boolean bl = change = prevVal == null || !prevVal.equals(connected);
        if (change) {
            LOG.info(serverConfig.getName() + " Connected = " + connected);
            for (Listener l : this.listeners) {
                l.statusChange(serverConfig, connected);
            }
        }
    }

    public KdbConnection getKdbConnection(String serverName) {
        ServerConfig sc = this.getServer(serverName);
        return sc != null ? this.getKdbConnection(sc) : null;
    }

    public boolean isConnected(ServerConfig sc) {
        if (sc != null) {
            Boolean b = this.serverConnected.get(sc);
            return b != null ? b : false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ServerConfig serverConfig) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.serverConns.contains(serverConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKdbServer() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.serverConns.stream().anyMatch(sc -> sc.isKDB());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.serverConns.size() == 0;
        }
    }

    public void refreshFromPreferences() {
        if (this.reloadFromPreferences()) {
            this.notifyListeners();
        }
    }

    public void setDefaultLogin(String username, String password) {
        if (!StringUtils.equals(this.defaultLoginUsername, username) || !StringUtils.equals(this.defaultLoginPassword, password)) {
            this.defaultLoginUsername = username;
            this.defaultLoginPassword = password;
            this.close();
            this.notifyListeners();
        }
    }

    public boolean isDefaultLoginSet() {
        return this.defaultLoginUsername != null || this.defaultLoginPassword != null;
    }

    public static void wipePreferences(Preferences preferences, String prefKeyPrefix) {
        for (int i = 0; i < 20; ++i) {
            preferences.remove(prefKeyPrefix + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reloadFromPreferences() {
        if (this.preferences != null) {
            Object object = this.LOCK;
            synchronized (object) {
                StringBuilder sb = new StringBuilder(this.preferences.get(this.prefKey, ""));
                for (int i = 0; i < 20; ++i) {
                    sb.append(this.preferences.get(this.prefKey + i, ""));
                }
                String txt = sb.toString();
                try {
                    txt = PreferenceHelper.decode(txt);
                    List<ServerConfig> sConns = ConnectionManager.getConnectionsFromXml(txt);
                    if (!sConns.equals(this.serverConns)) {
                        LOG.warning("stored conns and current conns disagreed, using stored values");
                        LOG.warning("serverConns = " + this.serverConns.toString());
                        LOG.warning("sConns = " + sConns.toString());
                        this.serverConns.clear();
                        this.serverConns.addAll(sConns);
                        return true;
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Could not decrypt connection details txt = " + txt, e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        if (this.preferences != null) {
            Object object = this.LOCK;
            synchronized (object) {
                String txt = ConnectionManager.getConnectionsXml(this.serverConns);
                txt = PreferenceHelper.encode(txt);
                if (txt.length() > 155648) {
                    LOG.info("txt.length = " + txt.length() + " maxLength = " + 73728);
                    throw new IllegalArgumentException("Too many connections to save");
                }
                if (txt.length() <= 8192) {
                    this.preferences.put(this.prefKey, txt);
                } else {
                    this.preferences.put(this.prefKey, txt.substring(0, 8192));
                    txt.substring(8192);
                    for (int i = 0; i < 20; ++i) {
                        int stPos = (i + 1) * 8192;
                        int endPos = Math.min((i + 2) * 8192, txt.length());
                        if (stPos < txt.length()) {
                            this.preferences.put(this.prefKey + i, txt.substring(stPos, endPos));
                            continue;
                        }
                        this.preferences.put(this.prefKey + i, "");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConnectionsXml(List<ServerConfig> serverConns, boolean removeLogins) {
        XStream xStream = xstream;
        synchronized (xStream) {
            ArrayList<ServerConfigDTO> l = new ArrayList<ServerConfigDTO>(serverConns.size());
            for (ServerConfig sc : serverConns) {
                l.add(new ServerConfigDTO(sc, removeLogins));
            }
            return xstream.toXML(l).replaceAll("list>", XML_ROOT + ">");
        }
    }

    public static String getConnectionsXml(List<ServerConfig> serverConns) {
        return ConnectionManager.getConnectionsXml(serverConns, false);
    }

    public String getConnectionsXml() {
        return ConnectionManager.getConnectionsXml(this.serverConns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ServerConfig> getConnectionsFromXml(String serverListXml) throws IOException {
        block6: {
            try {
                if (serverListXml == null || serverListXml.length() <= 0) break block6;
                String s = serverListXml.replaceAll(XML_ROOT + ">", "list>");
                ArrayList<ServerConfig> r = new ArrayList<ServerConfig>();
                XStream xStream = xstream;
                synchronized (xStream) {
                    ArrayList a = (ArrayList)xstream.fromXML(s);
                    for (ServerConfigDTO scDTO : a) {
                        r.add(scDTO.getInstance());
                    }
                }
                return r;
            }
            catch (Exception e) {
                String msg = "Could not convert serverListXml = " + serverListXml;
                LOG.log(Level.SEVERE, msg, e);
                throw new IOException(msg, e);
            }
        }
        return Collections.emptyList();
    }

    public Set<String> getFolders() {
        Set<String> r = Collections.emptySet();
        if (!this.serverConns.isEmpty()) {
            r = Sets.newHashSet();
            for (ServerConfig sc : this.serverConns) {
                r.add(sc.getFolder());
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ServerConfig serverConfig, String sql) {
        boolean executionSucceeded = false;
        PoolableConnection conn = null;
        try {
            conn = this.getConnection(serverConfig);
            if (conn == null) {
                throw new IOException("cant find server");
            }
            executionSucceeded = ConnectionManager.execute(sql, conn);
            this.returnConn(serverConfig, conn, !executionSucceeded);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "error getting connection:\r\n", e);
        }
        finally {
            this.returnConn(serverConfig, conn, true);
        }
        return executionSucceeded;
    }

    public boolean execute(ServerConfig sc, List<String> sqlQueries) {
        boolean success = true;
        for (String sql : sqlQueries) {
            success = success && this.execute(sc, sql);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean execute(String sql, Connection conn) {
        Statement st2 = null;
        try {
            st2 = conn.createStatement();
            st2.execute(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqe) {
            LOG.log(Level.WARNING, "error running sql:\r\n" + sql, sqe);
        }
        finally {
            try {
                if (st2 != null) {
                    st2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public CachedRowSet executeQuery(ServerConfig serverConfig, String sql) throws SQLException, IOException {
        return this.useConn(serverConfig, conn -> ConnectionManager.executeQuery(serverConfig, sql, conn));
    }

    <T> T useConn(ServerConfig serverConfig, CheckedFunction<Connection, T> f) throws IOException, SQLException {
        PoolableConnection conn = this.getConnection(serverConfig);
        if (conn == null) {
            throw new IOException("Could not find server");
        }
        boolean kdbConnectionClosed = false;
        try {
            T t = f.apply(conn);
            return t;
        }
        catch (SQLException sqe) {
            boolean bl = kdbConnectionClosed = serverConfig.getJdbcType().equals((Object)JdbcTypes.KDB) && sqe instanceof SQLException && sqe.toString().contains("recv failed") || sqe.toString().contains("SOCKETERR");
            if (kdbConnectionClosed) {
                T t;
                PoolableConnection connInner = this.getConnection(serverConfig);
                try {
                    t = f.apply(connInner);
                }
                catch (SQLException sqeInner) {
                    throw sqeInner;
                }
                finally {
                    this.returnConn(serverConfig, connInner, false);
                }
                return t;
            }
            throw sqe;
        }
        catch (Exception e) {
            kdbConnectionClosed = true;
            throw e;
        }
        finally {
            this.returnConn(serverConfig, conn, kdbConnectionClosed);
        }
    }

    private static CachedRowSet executeQuery(ServerConfig serverConfig, String sql, Connection conn) throws SQLException {
        Statement st2 = null;
        try {
            st2 = conn.createStatement();
            boolean hasRS = st2.execute(sql);
            ResultSet rs2 = null;
            int statementCount = 0;
            int updateCount = 0;
            CachedRowSet crs = null;
            do {
                ResultSet tempRs;
                if ((tempRs = st2.getResultSet()) != null && (rs2 = tempRs) != null) {
                    crs = RowSetProvider.newFactory().createCachedRowSet();
                    crs.populate(rs2);
                }
                updateCount += tempRs == null ? 0 : st2.getUpdateCount();
            } while ((st2.getMoreResults() || st2.getUpdateCount() != -1) && ++statementCount < 200000);
            if (statementCount > 200000) {
                LOG.warning("Possible error with JDBC driver. BReaking out of query loop as > 200_000 queries?!");
            }
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        catch (SQLException sqe) {
            LOG.warning("Error running sql:\r\n" + sql);
            throw sqe;
        }
        finally {
            try {
                if (st2 != null) {
                    st2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public int removeFolder(String folder) {
        List<ServerConfig> removedServers = this.getServersInFolder(folder);
        boolean[] r = this.removeServers(removedServers);
        int c2 = 0;
        for (boolean b : r) {
            if (!b) continue;
            ++c2;
        }
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renameFolder(String from, String to) {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        to = ServerConfig.cleanFolderName(to);
        from = ServerConfig.cleanFolderName(from);
        LOG.info("renameFolder(" + from + " -> " + to + ")");
        Object object = this.LOCK;
        synchronized (object) {
            this.reloadFromPreferences();
            List<ServerConfig> fromSCs = this.getServersInFolder(from);
            if (fromSCs.isEmpty()) {
                return 0;
            }
            for (ServerConfig existingSC : fromSCs) {
                this.serverConns.remove(existingSC);
                this.statusUpdate(existingSC, false);
                String newFolder = to + existingSC.getFolder().substring(from.length());
                ServerConfig sc = new ServerConfigBuilder(existingSC).setFolder(newFolder).build();
                this.serverConns.add(sc);
                this.statusUpdate(sc, false);
            }
            this.save();
            this.notifyListeners();
            return fromSCs.size();
        }
    }

    public List<ServerConfig> getServersInFolder(String folder) {
        Preconditions.checkNotNull(folder);
        String fn = ServerConfig.cleanFolderName(folder);
        ArrayList<ServerConfig> r = null;
        for (ServerConfig sc : this.serverConns) {
            if (!sc.getFolder().startsWith(fn)) continue;
            if (r == null) {
                r = new ArrayList<ServerConfig>();
            }
            r.add(sc);
        }
        return r == null ? Collections.emptyList() : r;
    }

    public boolean doesLoginWork() {
        Iterator<ServerConfig> iterator = this.serverConns.iterator();
        if (iterator.hasNext()) {
            ServerConfig sc = iterator.next();
            try {
                this.testConnection(sc);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        return true;
    }

    public String getDefaultLoginUsername() {
        return this.defaultLoginUsername;
    }

    public String getDefaultLoginPassword() {
        return this.defaultLoginPassword;
    }

    public static void setAppname(String appname) {
        ConnectionManager.appname = appname;
    }

    static {
        xstream.addPermission(AnyTypePermission.ANY);
        xstream.processAnnotations(ServerConfigDTO.class);
        appname = APP_TITLE;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }

    private static class MyDriverManagerConnectionFactory
    implements ConnectionFactory {
        private ServerConfig sc;

        public MyDriverManagerConnectionFactory(ServerConfig sc) {
            this.sc = sc;
        }

        @Override
        public Connection createConnection() throws SQLException {
            try {
                String driverName = this.sc.getJdbcType().getDriver();
                Class<?> driver = PluginLoader.getCClass(appname, driverName);
                Properties p = new Properties();
                p.setProperty("user", this.sc.getUsername());
                p.setProperty("password", this.sc.getPassword());
                return ((Driver)driver.newInstance()).connect(this.sc.getUrl(), p);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                e.printStackTrace();
                throw new SQLException(e);
            }
        }
    }

    public static abstract class Adapter
    implements Listener {
        @Override
        public void prefChange() {
        }

        @Override
        public void serverAdded(ServerConfig sc) {
        }

        @Override
        public void statusChange(ServerConfig serverConfig, boolean connected) {
        }
    }

    public static interface Listener {
        public void prefChange();

        public void serverAdded(ServerConfig var1);

        public void statusChange(ServerConfig var1, boolean var2);
    }
}

