/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.command;

import com.timestored.command.ChangeListener;
import com.timestored.command.Command;
import com.timestored.command.CommandPanel;
import com.timestored.command.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.ScrollableSizeHint;

public class CommandSplitPane
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private final DetailsPanel detailsPanel;
    private final CommandPanel commandPanel = new CommandPanel();
    private Color fgColor;
    private Color bgColor;

    public CommandSplitPane() {
        super(1, true);
        this.detailsPanel = new DetailsPanel();
        JScrollPane selectionScroll = new JScrollPane(this.commandPanel);
        selectionScroll.setMinimumSize(new Dimension(75, 50));
        this.setLeftComponent(selectionScroll);
        this.setRightComponent(this.detailsPanel);
        this.setResizeWeight(0.33);
        this.commandPanel.setChangeListener(new ChangeListener(){

            @Override
            public void changedTo(Command command) {
                CommandSplitPane.this.detailsPanel.displayDoc(command);
            }
        });
    }

    public void moveDown() {
        this.commandPanel.moveDown();
    }

    public void moveUp() {
        this.commandPanel.moveUp();
    }

    public void setDocsShown(List<Command> docsShown) {
        this.commandPanel.setCommands(docsShown);
        if (docsShown.size() > 0) {
            this.detailsPanel.displayDoc(docsShown.get(0));
        }
    }

    public Command getSelectedCommand() {
        return this.commandPanel.getSelectedCommand();
    }

    public void setSelectAction(AbstractAction action) {
        this.commandPanel.setSelectAction(action);
    }

    public void setCloseAction(AbstractAction action) {
        this.commandPanel.setCloseAction(action);
    }

    private JPanel getCommandPanel(Command command) {
        JXPanel p = new JXPanel(new BorderLayout());
        JTextPane txtPane = new JTextPane();
        txtPane.setContentType("text/html");
        txtPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    Utils.browse(e.getURL().toString());
                }
            }
        });
        JPanel header = Utils.getSubHeader(command.getTitle(), this.fgColor, this.bgColor);
        p.add((Component)header, "North");
        txtPane.setText(command.getDetailHtml());
        txtPane.setEditable(false);
        p.setBorder(BorderFactory.createRaisedBevelBorder());
        p.setScrollableTracksViewportWidth(true);
        p.setScrollableWidthHint(ScrollableSizeHint.FIT);
        JScrollPane scrollPane = new JScrollPane(txtPane, 22, 31);
        txtPane.setCaretPosition(0);
        p.add((Component)scrollPane, "Center");
        return p;
    }

    public void setFgColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    private class DetailsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DetailsPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setMinimumSize(new Dimension(100, 50));
        }

        void displayDoc(Command c2) {
            this.removeAll();
            if (c2 != null) {
                this.add((Component)CommandSplitPane.this.getCommandPanel(c2), "Center");
            }
            this.revalidate();
            this.repaint();
        }
    }
}

