/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.command;

import com.timestored.command.Command;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

class CommandRenderer
extends JLabel
implements ListCellRenderer {
    private static final CommandRenderer INSTANCE = new CommandRenderer();
    private static final long serialVersionUID = 1L;

    public static CommandRenderer getInstance() {
        return INSTANCE;
    }

    private CommandRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this, "West");
        if (value instanceof Command) {
            Command c2 = (Command)value;
            if (c2.getIcon() != null) {
                this.setIcon(c2.getIcon());
            }
            String t = c2.getTitle();
            String ta = c2.getTitleAdditional();
            if (ta != null && ta.length() > 0 && ta.length() < 60) {
                t = "<html>" + c2.getTitle() + "<font color='#666666'> - " + ta + "</font></html>";
            }
            this.setText(t);
            KeyStroke ks = c2.getKeyStroke();
            if (ks != null) {
                String s = ks.toString().replace("pressed ", "").replace("ctrl", "Ctrl").replace("shift", "Shift");
                JLabel l = new JLabel(s);
                l.setForeground(Color.DARK_GRAY);
                p.add((Component)l, "East");
            }
        } else {
            this.setText(value.toString());
        }
        if (isSelected) {
            p.setBackground(list.getSelectionBackground());
            p.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            p.setBackground(list.getBackground());
            p.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setOpaque(true);
        return p;
    }
}

