/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.command;

import com.timestored.command.ActionCommand;
import com.timestored.command.Command;
import com.timestored.command.CommandProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;

public class CommandManager
implements CommandProvider {
    private List<CommandProvider> providers = new ArrayList<CommandProvider>();
    private Map<String, List<CommandProvider>> languageSpecificProviders = new HashMap<String, List<CommandProvider>>();

    public Collection<Command> getCommands(String language) {
        List<CommandProvider> ls;
        ArrayList<Command> r = new ArrayList<Command>();
        for (CommandProvider cp : this.providers) {
            r.addAll(cp.getCommands());
        }
        if (language != null && (ls = this.languageSpecificProviders.get(language)) != null) {
            for (CommandProvider cp : ls) {
                r.addAll(cp.getCommands());
            }
        }
        return r;
    }

    @Override
    public Collection<Command> getCommands() {
        return this.getCommands(null);
    }

    public void registerProvider(String language, CommandProvider commandProvider) {
        List l = this.languageSpecificProviders.computeIfAbsent(language, s -> new ArrayList());
        l.add(commandProvider);
    }

    public void registerProvider(CommandProvider commandProvider) {
        this.providers.add(commandProvider);
    }

    public void removeProvider(CommandProvider commandProvider) {
        this.providers.remove(commandProvider);
    }

    public static Collection<Command> toCommands(List<Action> actions) {
        ArrayList<Command> cs2 = new ArrayList<Command>();
        for (Action a : actions) {
            cs2.add(new ActionCommand(a));
        }
        return cs2;
    }

    public static Command toCommand(Action action) {
        return new ActionCommand(action);
    }
}

