/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.command.Command;
import com.timestored.command.CommandPanel;
import com.timestored.command.CommandProvider;
import com.timestored.command.Utils;
import com.timestored.swingxx.AAction;
import com.timestored.swingxx.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CommandDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension PREF_DIMENSION = new Dimension(300, 400);
    private static final int RESULT_LIMIT = 100;
    private final CommandPanel commandPanel;
    private String prevSearch = "";
    private Collection<Command> commands = Collections.emptyList();
    private final ExecutorService executorService;

    public CommandDialog(String title, final List<Command> commands, ExecutorService executorService) {
        this(title, new CommandProvider(){

            @Override
            public Collection<Command> getCommands() {
                return commands;
            }
        }, executorService);
    }

    public CommandDialog(String title, final CommandProvider commandProvider, ExecutorService executorService) {
        this.executorService = Preconditions.checkNotNull(executorService);
        this.setTitle(title);
        this.setName("CodeOutlineDialog");
        this.setMinimumSize(PREF_DIMENSION);
        this.setPreferredSize(PREF_DIMENSION);
        this.commandPanel = new CommandPanel();
        final JTextField searchTextField = new JTextField();
        ActionMap am = searchTextField.getActionMap();
        InputMap im = searchTextField.getInputMap();
        am.put("upAction", new AAction(e -> this.commandPanel.moveUp()));
        im.put(KeyStroke.getKeyStroke("UP"), "upAction");
        am.put("downAction", new AAction(e -> this.commandPanel.moveDown()));
        im.put(KeyStroke.getKeyStroke("DOWN"), "downAction");
        am.put("escapeAction", new AAction(e -> this.dispose()));
        im.put(SwingUtils.ESC_KEYSTROKE, "escapeAction");
        searchTextField.addActionListener(new AAction(e -> {
            Command com = this.commandPanel.getSelectedCommand();
            if (com != null) {
                com.perform();
            }
            this.dispose();
        }));
        Utils.addEscapeCloseListener(this);
        Utils.putEscapeAction(searchTextField, new AAction(e -> this.dispose()));
        this.commandPanel.setSelectAction(new AAction(e -> {
            Command com = this.commandPanel.getSelectedCommand();
            if (com != null) {
                com.perform();
            }
            this.dispose();
        }));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                CommandDialog.this.dispose();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String txt;
                KeyStroke ks = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                if (!(ks.equals(KeyStroke.getKeyStroke("UP")) || ks.equals(KeyStroke.getKeyStroke("DOWN")) || (txt = searchTextField.getText()).equals(CommandDialog.this.prevSearch))) {
                    CommandDialog.this.showDocsForSearch(txt);
                    CommandDialog.this.prevSearch = txt;
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)searchTextField, "North");
        this.add((Component)this.commandPanel, "Center");
        searchTextField.requestFocus();
        this.pack();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CommandDialog.this.setVisible(false);
                CommandDialog.this.dispose();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                CommandDialog.this.commands = commandProvider.getCommands();
                EventQueue.invokeLater(() -> CommandDialog.this.showDocsForSearch(CommandDialog.this.prevSearch));
            }
        });
    }

    private void showDocsForSearch(String txt) {
        if (txt.trim().length() > 0) {
            String[] t = txt.trim().split(" ");
            ArrayList<Command> r = new ArrayList<Command>();
            for (Command c2 : this.commands) {
                boolean match = true;
                if (t.length > 0) {
                    for (String s : t) {
                        if (c2.getTitle().toUpperCase().contains(s.toUpperCase())) continue;
                        match = false;
                        break;
                    }
                }
                if (match) {
                    r.add(c2);
                }
                if (r.size() <= 100) continue;
                break;
            }
            this.commandPanel.setCommands(r);
        } else {
            List<Command> l = Lists.newArrayList(this.commands);
            if (l.size() > 100) {
                l = l.subList(0, 100);
            }
            this.commandPanel.setCommands(l);
        }
    }

    public void setSelectedCommand(Command command) {
        this.commandPanel.setSelectedCommand(command);
    }
}

