/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.command;

import com.google.common.collect.Lists;
import com.timestored.command.CodeSnippet;
import com.timestored.command.Command;
import com.timestored.command.CommandProvider;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.theme.Theme;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CodeSnippetCommandProvider
implements CommandProvider {
    private final OpenDocumentsModel openDocsModel;
    private final QueryManager queryManager;
    private final List<CodeSnippet> snippets = Lists.newArrayList();
    private static final String getProcessDetails = "{ t:(update d:`port`console`errorTrap`GC`precision`slaves`timer`Timeout`GMToffset`weekOffset`dateMode,v:system each s from ([] s:\"pcegPstToWz\"));\r\n    u:( [] s:`.z.a`.z.h`.z.i`.z.k`.z.K`.z.l`.z.o`.z.u`.z.x`.z.X);\r\n    u:update d:`ip`hostname`PID`releaseDate`releaseVersion`license`os`username`cmd`cmdLine,v:value each s from u;\r\n    u:update {\".\" sv string `int$0x00 vs x} each v from u where d=`ip;\r\n    `s xkey `s xasc t uj u}[]";
    private static final String getCountByForOneTable = "// Get count by date and column for one table\r\n{ t:?[x;();`date`s!`date,y;enlist[`cn]!enlist (count;`i)];\r\n P:`$string asc distinct (0!t)`s;\r\n exec P!((`$string s)!cn)P by date:date from t}[quote;`cond]";
    private static final String getHDBcounts = "(uj/) {(.Q.pf,x) xcol ?[x;enlist (in;.Q.pf;-20 sublist value .Q.pf);{x!x}(),.Q.pf;enlist[`cn]!enlist (count;(cols x) 1)]} each .Q.pt";
    private static final String getTableCounts = "// Get overview of  all tables\r\n{ [] \r\n    gett:{\r\n    \t// replace empty wqith blank, 1 dont show comma, many use -3!\r\n    \tformatVals:{@[{$[0=count x;\"\";$[(11h=type x) and 1=count x;\"`\",string first x;80 sublist trim -3!`#x]]};x;\"  \"]};\r\n        safeCount: {$[.Q.qp x; $[`pn in key `.Q; {$[count x;sum x;0N]} .Q.pn y; -1]; count x]};\r\n    \tgetFmt:{((0;0b;1b)!`memory`splayed`partitioned) .Q.qp[value x]};\r\n    \tcnames:`table`count`format`columns`keys;\r\n    \tcnames!(x; safeCount[value x;x]; getFmt x;formatVals asc cols x; k:asc keys x)};\r\n    `table xkey gett each asc system \"a\"}[]";

    public CodeSnippetCommandProvider(OpenDocumentsModel openDocsModel, QueryManager queryManager) {
        this.openDocsModel = openDocsModel;
        this.queryManager = queryManager;
        this.snippets.add(new CodeSnippet("getProcessDetails", getProcessDetails, true, false));
        this.snippets.add(new CodeSnippet("getHDBcounts", getHDBcounts, true, false));
        this.snippets.add(new CodeSnippet("getTableCounts", getTableCounts, true, false));
        this.snippets.add(new CodeSnippet("getCountByForOneTable", getCountByForOneTable, false, true));
    }

    @Override
    public Collection<Command> getCommands() {
        ArrayList<Command> commands = Lists.newArrayList();
        for (CodeSnippet snip : this.snippets) {
            if (snip.isPasteable()) {
                commands.add(new PasteSnippetCommand(snip));
            }
            if (!snip.isRunnable()) continue;
            commands.add(new RunSnippetCommand(snip));
        }
        return commands;
    }

    class RunSnippetCommand
    extends PasteSnippetCommand {
        public RunSnippetCommand(CodeSnippet codeSnippet) {
            super(codeSnippet);
        }

        @Override
        public Icon getIcon() {
            return Theme.CIcon.CLOCK_GO.get16();
        }

        @Override
        public String getTitle() {
            return "Run Snip: " + this.codeSnippet.getName();
        }

        @Override
        public void perform() {
            CodeSnippetCommandProvider.this.queryManager.sendQuery(this.codeSnippet.getCode(), this.getTitle());
        }
    }

    class PasteSnippetCommand
    implements Command {
        protected final CodeSnippet codeSnippet;

        @Override
        public Icon getIcon() {
            return Theme.CIcon.EDIT_PASTE.get16();
        }

        @Override
        public String getTitle() {
            return "Paste Snip: " + this.codeSnippet.getName();
        }

        @Override
        public String getDetailHtml() {
            return this.codeSnippet.getName();
        }

        @Override
        public KeyStroke getKeyStroke() {
            return null;
        }

        public String toString() {
            return this.getTitle();
        }

        @Override
        public String getTitleAdditional() {
            return "";
        }

        @Override
        public void perform() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeSnippetCommandProvider.this.openDocsModel.insertSelectedText(PasteSnippetCommand.this.codeSnippet.getCode());
                }
            });
        }

        public PasteSnippetCommand(CodeSnippet codeSnippet) {
            this.codeSnippet = codeSnippet;
        }
    }
}

