/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import com.google.common.base.Preconditions;
import com.timestored.babeldb.BaseResultSet;
import com.timestored.babeldb.DBHelper;
import com.timestored.babeldb.JsonResultSetBuilder;
import com.timestored.babeldb.SimpleResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

public class SimpleResultSet
extends BaseResultSet
implements CachedRowSet {
    private final String[] colNames;
    private final Object[] colValues;
    private final int size;
    private int idx = -1;
    private final ResultSetMetaData resultSetMetaData;
    private boolean wasNull;
    private static final Set<String> DTCOLS = new HashSet<String>();
    private static final SimpleDateFormat yyyyMMdd;
    private static final SimpleDateFormat yyyy;

    public static SimpleResultSet til(int n) {
        int[] a = new int[n];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        return new SimpleResultSet(new String[]{"v"}, new Object[]{a});
    }

    public SimpleResultSet(String[] colNames) {
        this(colNames, SimpleResultSet.getEmptyVals(colNames.length));
    }

    private static Object[] getEmptyVals(int numberColumns) {
        Object[] val2 = new Object[numberColumns];
        for (int i = 0; i < numberColumns; ++i) {
            val2[i] = new Object[0];
        }
        return val2;
    }

    public SimpleResultSet(List<String> colNames, List<Object> colValues) {
        this(colNames.toArray(new String[colNames.size()]), colValues.toArray(new Object[colValues.size()]));
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public SimpleResultSet getColumnSubset(List<String> originalColumnNames, List<String> optionalRenaming) throws SQLException {
        if (originalColumnNames == null || originalColumnNames.size() < 1) {
            throw new IllegalArgumentException("Must specify columns");
        }
        List<String> newNames = optionalRenaming != null ? optionalRenaming : originalColumnNames;
        ArrayList<Object> newColValues = new ArrayList<Object>(originalColumnNames.size());
        for (String colName : originalColumnNames) {
            newColValues.add(this.colValues[this.findColumn(colName) - 1]);
        }
        return new SimpleResultSet(newNames, newColValues);
    }

    public SimpleResultSet renameColumns(ArrayList<String> newColumnNames) {
        if (newColumnNames.size() != this.colNames.length) {
            throw new IllegalArgumentException("Must reame all columns");
        }
        return new SimpleResultSet(newColumnNames.toArray(new String[0]), this.colValues);
    }

    public SimpleResultSet(String[] colNamesArg, Object[] colValues) {
        int dupeCount = 1;
        Preconditions.checkArgument(colNamesArg.length == colValues.length);
        ArrayList<String> newColNames = new ArrayList<String>();
        for (String cn : colNamesArg) {
            boolean isEmpty = cn.trim().equals("");
            if (isEmpty || newColNames.contains(cn)) {
                while (newColNames.contains((isEmpty ? "c" : cn) + dupeCount)) {
                    ++dupeCount;
                }
                newColNames.add((isEmpty ? "c" : cn) + dupeCount);
                continue;
            }
            newColNames.add(cn);
        }
        this.colNames = newColNames.toArray(new String[0]);
        this.colValues = colValues;
        int[] types = null;
        if (colValues.length == 0) {
            types = new int[this.colNames.length];
            Arrays.fill(types, 12);
        } else {
            types = SimpleResultSet.getTypes(colValues);
        }
        this.size = this.colValues.length > 0 ? Array.getLength(colValues[0]) : 0;
        this.resultSetMetaData = new SimpleResultSetMetaData(this.colNames, types);
    }

    private static int getType(Object o) {
        if (o instanceof String[]) {
            return 12;
        }
        if (o instanceof boolean[]) {
            return -7;
        }
        if (o instanceof short[]) {
            return 5;
        }
        if (o instanceof int[]) {
            return 4;
        }
        if (o instanceof long[]) {
            return -5;
        }
        if (o instanceof float[]) {
            return 7;
        }
        if (o instanceof double[]) {
            return 8;
        }
        if (o instanceof Timestamp[]) {
            return 93;
        }
        if (o instanceof Date[]) {
            return 91;
        }
        if (o instanceof java.util.Date[]) {
            return 91;
        }
        if (o instanceof Time[]) {
            return 92;
        }
        if (o instanceof Instant[]) {
            return 93;
        }
        if (o instanceof LocalDate[]) {
            return 91;
        }
        if (o instanceof LocalTime[]) {
            return 92;
        }
        return 12;
    }

    private static int[] getTypes(Object[] colValues) {
        int[] r = new int[colValues.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = SimpleResultSet.getType(colValues[i]);
        }
        return r;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.colNames[i].equals(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object o = Array.get(this.colValues[columnIndex - 1], this.idx);
        this.wasNull = o == null || o instanceof Double && Double.isNaN((Double)o) || o instanceof Float && Float.isNaN(((Float)o).floatValue());
        return this.wasNull ? null : o;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.idx = row - 1;
        return true;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.idx = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.idx = this.size;
    }

    @Override
    public boolean first() throws SQLException {
        this.idx = 0;
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        return this.idx + 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.idx >= this.size;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.idx < 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.idx == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.idx == this.size - 1;
    }

    @Override
    public boolean last() throws SQLException {
        this.idx = this.size - 1;
        return this.size > 0;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.idx;
        return this.idx < this.size;
    }

    @Override
    public boolean previous() throws SQLException {
        --this.idx;
        return this.idx >= 0;
    }

    public SimpleResultSet castTypes(Map<String, Integer> colTypes, boolean autoconvertOtherCols) {
        Object[] colVals = new Object[this.colValues.length];
        for (int c2 = 0; c2 < colVals.length; ++c2) {
            String cn;
            Integer newT;
            colVals[c2] = this.colValues[c2];
            Integer n2 = newT = colTypes != null ? colTypes.get(this.colNames[c2]) : null;
            if (newT != null) {
                colVals[c2] = this.castArray(newT, colVals[c2]);
                continue;
            }
            if (!autoconvertOtherCols) continue;
            if (this.isStringAnd(colVals[c2], s -> s.matches("-?\\d+"))) {
                colVals[c2] = this.castArray(-5, colVals[c2]);
            }
            if (DTCOLS.contains(cn = this.colNames[c2].toLowerCase()) || cn.endsWith("date") || cn.endsWith("time")) {
                if (!this.isAll(colVals[c2], cv -> cv instanceof Long)) continue;
                if (this.isLongAnd(colVals[c2], n -> n > 19000101L && n <= 21001231L)) {
                    colVals[c2] = this.castArray(91, colVals[c2]);
                    continue;
                }
                colVals[c2] = this.castArray(93, colVals[c2]);
                continue;
            }
            if (!cn.trim().endsWith("year") || !this.isLongAnd(colVals[c2], n -> n > 1700L && n <= 2200L)) continue;
            colVals[c2] = this.castArray(91, colVals[c2]);
        }
        return new SimpleResultSet(this.colNames, colVals);
    }

    boolean isStringAnd(Object col, Predicate<String> predicate) {
        return this.isAll(col, v -> v != null && v instanceof String && predicate.test((String)v));
    }

    boolean isLongAnd(Object col, Predicate<Long> predicate) {
        return this.isAll(col, v -> v != null && v instanceof Long && predicate.test((Long)v));
    }

    boolean isAll(Object col, Predicate<Object> predicate) {
        int sz = Array.getLength(col);
        for (int i = 0; i < sz; ++i) {
            if (predicate.test(Array.get(col, i))) continue;
            return false;
        }
        return true;
    }

    public static Object[] getArray(List<Integer> sqlTypes, int sz) {
        Object[] r = new Object[sqlTypes.size()];
        for (int c2 = 0; c2 < r.length; ++c2) {
            r[c2] = SimpleResultSet.getArrayFromSqlType(sqlTypes.get(c2), sz);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int curIdx = this.idx;
        try {
            String string = DBHelper.toString(this, true);
            return string;
        }
        catch (SQLException e) {
            String string = "SimpleResultSet [colNames=" + Arrays.toString(this.colNames) + ", colValues=" + Arrays.toString(this.colValues) + ", size=" + this.size + ", idx=" + this.idx + "]";
            return string;
        }
        finally {
            this.idx = curIdx;
        }
    }

    public static Object getArray(Object o, int size) {
        if (o instanceof Instant) {
            return new Instant[size];
        }
        if (o instanceof Date) {
            return new Date[size];
        }
        if (o instanceof java.util.Date) {
            return new java.util.Date[size];
        }
        if (o instanceof LocalDate) {
            return new LocalDate[size];
        }
        if (o instanceof LocalTime) {
            return new LocalTime[size];
        }
        if (o instanceof LocalDateTime) {
            return new LocalDateTime[size];
        }
        if (o instanceof String) {
            return new String[size];
        }
        if (o instanceof Boolean) {
            return new boolean[size];
        }
        if (o instanceof Short) {
            return new short[size];
        }
        if (o instanceof Integer) {
            return new int[size];
        }
        if (o instanceof Long) {
            return new long[size];
        }
        if (o instanceof Float) {
            return new float[size];
        }
        if (o instanceof Double) {
            return new double[size];
        }
        if (o instanceof Timestamp) {
            return new Timestamp[size];
        }
        if (o instanceof Time) {
            return new Time[size];
        }
        throw new IllegalArgumentException("Unrecognised Object for SRS = " + o);
    }

    private static Object getArrayFromSqlType(int sqlType, int sz) {
        switch (sqlType) {
            case 8: {
                return new double[sz];
            }
            case 4: {
                return new int[sz];
            }
            case -5: {
                return new long[sz];
            }
            case 16: {
                return new boolean[sz];
            }
            case 12: {
                return new String[sz];
            }
            case 91: {
                return new java.util.Date[sz];
            }
            case 93: {
                return new Timestamp[sz];
            }
        }
        return new Object[sz];
    }

    private Object castArray(int newT, Object array) {
        int sz = Array.getLength(array);
        Object newArr = SimpleResultSet.getArrayFromSqlType(newT, sz);
        for (int r = 0; r < sz; ++r) {
            Object val2 = Array.get(array, r);
            JsonResultSetBuilder.arraySetUnlessNull(newArr, r, this.cast(newT, val2));
        }
        return newArr;
    }

    private Object castFromString(int sqlType, String val2) {
        switch (sqlType) {
            case 8: {
                return Double.parseDouble(val2);
            }
            case 4: {
                return Integer.parseInt(val2);
            }
            case -5: {
                return Long.parseLong(val2);
            }
            case 16: {
                return Boolean.parseBoolean(val2);
            }
            case 93: {
                try {
                    return new Timestamp(Long.parseLong(val2));
                }
                catch (NumberFormatException nfe) {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return val2;
    }

    private Object cast(int sqlType, Object val2) {
        if (val2 instanceof String) {
            return this.castFromString(sqlType, (String)val2);
        }
        switch (sqlType) {
            case 8: {
                return val2 instanceof Double ? val2 : Double.valueOf(Double.NaN);
            }
            case 4: {
                return val2 instanceof Integer ? val2 : Integer.valueOf(0);
            }
            case -5: {
                return val2 instanceof Long ? val2 : Integer.valueOf(0);
            }
            case 16: {
                return val2 instanceof Boolean ? val2 : Boolean.valueOf(false);
            }
            case 93: {
                if (val2 instanceof Long) {
                    long v = (Long)val2;
                    if (v > 1002857600L && v < 3002857600L) {
                        return new Timestamp(v * 1000L);
                    }
                    if (v > 2130220032L && v < 3002857600000L) {
                        return new Timestamp(v);
                    }
                }
                return val2 instanceof Timestamp ? val2 : (val2 instanceof Number ? new Timestamp(((Number)val2).longValue()) : null);
            }
            case 91: {
                if (val2 instanceof Timestamp) {
                    return new java.util.Date(((Timestamp)val2).getTime());
                }
                if (val2 instanceof java.util.Date) {
                    return val2;
                }
                if (val2 instanceof Long) {
                    long v = (Long)val2;
                    if (v > 1002857600L && v < 3002857600L) {
                        return new java.util.Date(v * 1000L);
                    }
                    if (v > 2130220032L && v < 3002857600000L) {
                        return new java.util.Date(v);
                    }
                    try {
                        return v < 2200L && v > 1700L ? yyyy.parse("" + v) : yyyyMMdd.parse("" + v);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return new java.util.Date(0L);
            }
        }
        return (String)val2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public RowSet createShared() throws SQLException {
        return new SimpleResultSet(this.colNames, this.colValues);
    }

    @Override
    public String getUrl() throws SQLException {
        return null;
    }

    @Override
    public void setUrl(String url) throws SQLException {
    }

    @Override
    public String getDataSourceName() {
        return null;
    }

    @Override
    public void setDataSourceName(String name) throws SQLException {
    }

    @Override
    public String getUsername() {
        return null;
    }

    @Override
    public void setUsername(String name) throws SQLException {
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public void setPassword(String password) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public String getCommand() {
        return null;
    }

    @Override
    public void setCommand(String cmd) throws SQLException {
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setReadOnly(boolean value) throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public boolean getEscapeProcessing() throws SQLException {
        return false;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void setType(int type) throws SQLException {
    }

    @Override
    public void setConcurrency(int concurrency) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setArray(int i, java.sql.Array x) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void execute() throws SQLException {
    }

    @Override
    public void addRowSetListener(RowSetListener listener) {
    }

    @Override
    public void removeRowSetListener(RowSetListener listener) {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public void setMatchColumn(int columnIdx) throws SQLException {
    }

    @Override
    public void setMatchColumn(int[] columnIdxes) throws SQLException {
    }

    @Override
    public void setMatchColumn(String columnName) throws SQLException {
    }

    @Override
    public void setMatchColumn(String[] columnNames) throws SQLException {
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        return null;
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        return null;
    }

    @Override
    public void unsetMatchColumn(int columnIdx) throws SQLException {
    }

    @Override
    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
    }

    @Override
    public void unsetMatchColumn(String columnName) throws SQLException {
    }

    @Override
    public void unsetMatchColumn(String[] columnName) throws SQLException {
    }

    @Override
    public void execute(Connection conn) throws SQLException {
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
    }

    @Override
    public void acceptChanges(Connection con) throws SyncProviderException {
    }

    @Override
    public void restoreOriginal() throws SQLException {
    }

    @Override
    public void release() throws SQLException {
    }

    @Override
    public void undoDelete() throws SQLException {
    }

    @Override
    public void undoInsert() throws SQLException {
    }

    @Override
    public void undoUpdate() throws SQLException {
    }

    @Override
    public boolean columnUpdated(int idx) throws SQLException {
        return false;
    }

    @Override
    public boolean columnUpdated(String columnName) throws SQLException {
        return false;
    }

    @Override
    public Collection<?> toCollection() throws SQLException {
        return null;
    }

    @Override
    public Collection<?> toCollection(int column) throws SQLException {
        return null;
    }

    @Override
    public Collection<?> toCollection(String column) throws SQLException {
        return null;
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return null;
    }

    @Override
    public void setSyncProvider(String provider) throws SQLException {
    }

    @Override
    public void setMetaData(RowSetMetaData md) throws SQLException {
    }

    @Override
    public void populate(ResultSet data) throws SQLException {
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        return null;
    }

    @Override
    public void setOriginalRow() throws SQLException {
    }

    @Override
    public String getTableName() throws SQLException {
        return null;
    }

    @Override
    public void setTableName(String tabName) throws SQLException {
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return null;
    }

    @Override
    public void setKeyColumns(int[] keys) throws SQLException {
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        return null;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        return null;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        return null;
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean getShowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void setShowDeleted(boolean b) throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint s) throws SQLException {
    }

    @Override
    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
    }

    @Override
    public void populate(ResultSet rs2, int startRow) throws SQLException {
    }

    @Override
    public void setPageSize(int size) throws SQLException {
    }

    @Override
    public int getPageSize() {
        return 0;
    }

    @Override
    public boolean nextPage() throws SQLException {
        return false;
    }

    @Override
    public boolean previousPage() throws SQLException {
        return false;
    }

    static {
        DTCOLS.add("d");
        DTCOLS.add("t");
        DTCOLS.add("date");
        DTCOLS.add("time");
        yyyyMMdd = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
        yyyy = new SimpleDateFormat("yyyy", Locale.ENGLISH);
    }
}

