/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

public enum PulseInterval {
    S1("1s", "second", null),
    M1("1m", "minute", "1min"),
    H1("1h", "hour", "1hour"),
    D1("1d", "day", "1day"),
    W1("1w", "week", "1week");

    private final String interval;
    final String polyName;
    final String kucoin;

    private static final PulseInterval lookup(String s) {
        if (s == null) {
            return null;
        }
        switch (s.toLowerCase()) {
            case "1s": {
                return S1;
            }
            case "1m": {
                return M1;
            }
            case "1h": {
                return H1;
            }
            case "": 
            case "1d": {
                return D1;
            }
            case "1w": {
                return W1;
            }
        }
        return null;
    }

    public static String toKucoin(String s) {
        String t = s == null ? "" : s;
        PulseInterval pi = PulseInterval.lookup(t);
        return pi == null ? t : (pi.kucoin == null ? t : pi.kucoin);
    }

    public static String toPoly(String s) {
        String t = s == null ? "" : s;
        PulseInterval pi = PulseInterval.lookup(t);
        return pi == null ? t : (pi.polyName == null ? t : pi.polyName);
    }

    public static String toStandard(String s) {
        String t = s == null ? "" : s;
        PulseInterval pi = PulseInterval.lookup(t);
        return pi == null ? t : (pi.interval == null ? t : pi.interval);
    }

    private PulseInterval(String interval, String polyName, String kucoin) {
        this.interval = interval;
        this.polyName = polyName;
        this.kucoin = kucoin;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getPolyName() {
        return this.polyName;
    }

    public String getKucoin() {
        return this.kucoin;
    }
}

