/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import com.google.common.collect.Lists;
import com.timestored.babeldb.BaseResultSet;
import com.timestored.babeldb.SimpleResultSetMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class PivotResultSet
extends BaseResultSet {
    private final List<String> colNames = new ArrayList<String>();
    private final List<Integer> colTypes = new ArrayList<Integer>();
    private final List<List<Object>> colValues = new ArrayList<List<Object>>();
    private int idx = -1;
    private final ResultSetMetaData resultSetMetaData;
    private boolean wasNull;
    private final int size;

    public PivotResultSet(ResultSet rs2, String byCol, String pivotCol) throws SQLException {
        this(rs2, Lists.newArrayList(byCol), Lists.newArrayList(pivotCol));
    }

    /*
     * WARNING - void declaration
     */
    public PivotResultSet(ResultSet rs2, List<String> byCols, List<String> pivotCols) throws SQLException {
        if (byCols.size() < 1) {
            throw new IllegalArgumentException("You must specify one by column at least.");
        }
        if (pivotCols.size() < 1) {
            throw new IllegalArgumentException("You must specify one pivot column at least.");
        }
        ResultSetMetaData rsmd = rs2.getMetaData();
        int numColumns = rsmd.getColumnCount();
        ArrayList<String> originalColNames = new ArrayList<String>(numColumns);
        ArrayList<Integer> originalColTypes = new ArrayList<Integer>(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            originalColNames.add(rsmd.getColumnLabel(i + 1));
            originalColTypes.add(rsmd.getColumnType(i + 1));
        }
        for (String byc : byCols) {
            if (!originalColNames.contains(byc)) {
                throw new IllegalArgumentException("by column not contained in original table: " + byc);
            }
            this.colNames.add(byc);
            this.colTypes.add(rsmd.getColumnType(1 + originalColNames.indexOf(byc)));
            this.colValues.add(new ArrayList());
        }
        for (String pc : pivotCols) {
            if (originalColNames.contains(pc)) continue;
            throw new IllegalArgumentException("pivot column not contained in original table: " + pc);
        }
        ArrayList<String> bcols = new ArrayList<String>();
        bcols.addAll(byCols);
        bcols.addAll(pivotCols);
        PivotResultSet.checkColsUniquelySorted(rs2, bcols);
        rs2.beforeFirst();
        int row = 0;
        while (rs2.next()) {
            void var12_16;
            String prefix = "";
            for (String string : pivotCols) {
                prefix = prefix + rs2.getObject(string) + "_";
            }
            boolean allBysMatch = true;
            if (row > 0) {
                for (String b : byCols) {
                    List<Object> clist = this.colValues.get(this.colNames.indexOf(b));
                    if (clist.get(clist.size() - 1).equals(rs2.getObject(b))) continue;
                    allBysMatch = false;
                    break;
                }
            }
            if (row == 0 || !allBysMatch) {
                this.makeRowsEqual(byCols.size());
                for (String b : byCols) {
                    this.putt(this.colTypes.get(this.colNames.indexOf(b)), b, rs2.getObject(b));
                }
            }
            boolean bl = false;
            while (var12_16 < numColumns) {
                String oname = (String)originalColNames.get((int)var12_16);
                if (!pivotCols.contains(oname) && !byCols.contains(oname)) {
                    String newColName = prefix + oname;
                    if (byCols.contains(newColName)) {
                        throw new IllegalArgumentException("Newly generated pivot column name clashed with by column name");
                    }
                    int otype = (Integer)originalColTypes.get((int)var12_16);
                    Object v = PivotResultSet.gett(otype, rs2, (int)var12_16);
                    this.putt(otype, newColName, v);
                }
                ++var12_16;
            }
            ++row;
        }
        this.makeRowsEqual(byCols.size());
        for (int i = byCols.size() + 1; i < this.colNames.size(); ++i) {
            for (int j = i; j > byCols.size() && this.colNames.get(j).compareTo(this.colNames.get(j - 1)) < 0; --j) {
                Collections.swap(this.colNames, j, j - 1);
                Collections.swap(this.colTypes, j, j - 1);
                Collections.swap(this.colValues, j, j - 1);
            }
        }
        this.size = this.colValues.size() > 0 ? this.colValues.get(0).size() : 0;
        this.resultSetMetaData = new SimpleResultSetMetaData(this.colNames, this.colTypes);
    }

    private static void checkColsUniquelySorted(ResultSet rs2, List<String> bcols) throws SQLException {
        ArrayList uniqValsPerCol = new ArrayList();
        ArrayList<Object> prevValPerCol = new ArrayList<Object>();
        for (int i = 0; i < bcols.size(); ++i) {
            uniqValsPerCol.add(new HashSet());
            prevValPerCol.add(null);
        }
        rs2.beforeFirst();
        while (rs2.next()) {
            for (int c2 = 0; c2 < bcols.size(); ++c2) {
                String cname = bcols.get(c2);
                Object obj = rs2.getObject(cname);
                if (!((HashSet)uniqValsPerCol.get(c2)).contains(obj)) {
                    ((HashSet)uniqValsPerCol.get(c2)).add(obj);
                    for (int cc = c2 + 1; cc < bcols.size(); ++cc) {
                        ((HashSet)uniqValsPerCol.get(cc)).clear();
                    }
                } else {
                    boolean matchesPrev;
                    boolean bl = obj == null ? prevValPerCol.get(c2) == null : (matchesPrev = obj.equals(prevValPerCol.get(c2)));
                    if (!matchesPrev) {
                        throw new IllegalArgumentException("already seen value isn't consecutive val=" + obj + " col = " + cname);
                    }
                    if (c2 == bcols.size() - 1) {
                        throw new IllegalArgumentException("repeating entry in column " + cname);
                    }
                }
                prevValPerCol.set(c2, obj);
            }
        }
    }

    private void makeRowsEqual(int numberByCols) {
        int maxRows = this.colValues.stream().map(l -> l.size()).mapToInt(Integer::intValue).max().getAsInt();
        for (int c2 = 0; c2 < this.colValues.size(); ++c2) {
            List<Object> curCol = this.colValues.get(c2);
            if (curCol.size() >= maxRows) continue;
            Object val2 = c2 < numberByCols ? curCol.get(curCol.size() - 1) : null;
            this.colValues.get(c2).add(val2);
        }
    }

    private void putt(int colType, String cname, Object v) {
        int idx = this.colNames.indexOf(cname);
        if (idx == -1) {
            this.colNames.add(cname);
            this.colTypes.add(colType);
            this.colValues.add(new ArrayList());
            int sz = this.colValues.size() - 1;
            int maxRows = this.colValues.stream().map(l -> l.size()).mapToInt(Integer::intValue).max().getAsInt();
            for (int r = 0; r < maxRows - 1; ++r) {
                this.colValues.get(sz).add(null);
            }
            this.colValues.get(sz).add(v);
        } else {
            this.colValues.get(idx).add(v);
        }
    }

    static Object gett(int colType, ResultSet rs2, int i) throws SQLException {
        Object l = null;
        switch (colType) {
            case 4: {
                l = rs2.getInt(i + 1);
                if (!rs2.wasNull()) break;
                l = null;
                break;
            }
            case -5: {
                l = rs2.getLong(i + 1);
                if (!rs2.wasNull()) break;
                l = null;
                break;
            }
            case 2: 
            case 3: {
                l = rs2.getBigDecimal(i + 1);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                l = rs2.getDouble(i + 1);
                if (!rs2.wasNull()) break;
                l = null;
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                l = rs2.getString(i + 1);
                break;
            }
            case -7: 
            case 16: {
                l = rs2.getBoolean(i + 1);
                if (!rs2.wasNull()) break;
                l = null;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                l = rs2.getBytes(i + 1);
                break;
            }
            case -6: 
            case 5: {
                l = rs2.getShort(i + 1);
                if (!rs2.wasNull()) break;
                l = null;
                break;
            }
            case 2004: {
                l = rs2.getBlob(i);
                break;
            }
            case 2005: {
                l = rs2.getClob(i);
                break;
            }
            case 2002: {
                throw new RuntimeException("ResultSetSerializer not yet implemented for SQL type STRUCT");
            }
            case 2001: {
                throw new RuntimeException("ResultSetSerializer not yet implemented for SQL type DISTINCT");
            }
            case 2006: {
                throw new RuntimeException("ResultSetSerializer not yet implemented for SQL type REF");
            }
            default: {
                l = rs2.getObject(i + 1);
            }
        }
        return l;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int idx = this.colNames.indexOf(columnLabel);
        if (idx != -1) {
            return idx;
        }
        throw new SQLException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.idx = row - 1;
        return true;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.idx = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.idx = this.size;
    }

    @Override
    public boolean first() throws SQLException {
        this.idx = 0;
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        return this.idx + 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.idx >= this.size;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.idx < 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.idx == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.idx == this.size - 1;
    }

    @Override
    public boolean last() throws SQLException {
        this.idx = this.size - 1;
        return this.size > 0;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.idx;
        return this.idx < this.size;
    }

    @Override
    public boolean previous() throws SQLException {
        --this.idx;
        return this.idx >= 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object o = this.colValues.get(columnIndex - 1).get(this.idx);
        this.wasNull = o == null;
        return o;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

