/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import com.google.common.base.Joiner;
import com.timestored.babeldb.DBHelper;
import com.timestored.babeldb.PivotResultSet;
import com.timestored.connections.JdbcTypes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class PivotProvider {
    public static final String KDB_PULSEAGG = "{[tbl; groupby; pivot; sel]\r\n    \r\n    piv:{[t;k;p;v]\r\n        / controls new columns names\r\n        f:{[v;P]`${-1 _ raze \"_\" sv x} each string raze P[;0],'/:v,/:\\:P[;1]};\r\n         v:(),v; k:(),k; p:(),p; / make sure args are lists\r\n         G:group flip k!(t:.Q.v t)k;\r\n         F:group flip p!t p;\r\n         sortAlpha:{(c iasc `$string c:cols x) xcols x};\r\n         key[G]!sortAlpha flip(C:f[v]P:flip value flip key F)!raze\r\n          {[i;j;k;x;y]\r\n           a:count[x]#x 0N;\r\n           a[y]:x y;\r\n           b:count[x]#0b;\r\n           b[y]:1b;\r\n           c:a i;\r\n           c[k]:first'[a[j]@'where'[b j]];\r\n           c}[I[;0];I J;J:where 1<>count'[I:value G]]/:\\:[t v;value F]};\r\n\r\n    g:groupby,pivot;\r\n    if[(0<count pivot) and 0=count groupby;'mustSpecifyGroupbyToAllowPivot];\r\n    s:@[;4] parse \"select \",sel,\" from t\";\r\n    t:$[0=count g;select from tbl where i<1000; ?[tbl;();g!g;s]];\r\n    () xkey $[count pivot; piv[() xkey t;groupby;pivot;$[count s;key s;cols[t] except g]]; t]}";

    public static ResultSet postProcess(JdbcTypes jdbcTypes, ResultSet rs2, List<String> byCols, List<String> pivotCols) throws SQLException {
        boolean pivotAlready;
        boolean bl = pivotAlready = jdbcTypes.equals((Object)JdbcTypes.KDB) || jdbcTypes.equals((Object)JdbcTypes.DUCKDB);
        if (pivotAlready || pivotCols.isEmpty()) {
            return rs2;
        }
        return new PivotResultSet(rs2, byCols, pivotCols);
    }

    public static String pivotSQL(JdbcTypes jdbcTypes, List<String> groupbylist, List<String> pivotlist, String sel, String translation) {
        boolean isKDB = jdbcTypes.isKDB();
        if (isKDB) {
            String ssel = sel.replace(":count *", ":count i");
            String groupby = DBHelper.toKdbStringList(groupbylist);
            if (pivotlist.isEmpty()) {
                if (groupbylist.isEmpty()) {
                    return translation;
                }
                return "select " + ssel + " by " + Joiner.on(',').join(groupbylist) + " from " + translation;
            }
            String pivot = DBHelper.toKdbStringList(pivotlist);
            return "{pulseagg:{[tbl; groupby; pivot; sel]\r\n    \r\n    piv:{[t;k;p;v]\r\n        / controls new columns names\r\n        f:{[v;P]`${-1 _ raze \"_\" sv x} each string raze P[;0],'/:v,/:\\:P[;1]};\r\n         v:(),v; k:(),k; p:(),p; / make sure args are lists\r\n         G:group flip k!(t:.Q.v t)k;\r\n         F:group flip p!t p;\r\n         sortAlpha:{(c iasc `$string c:cols x) xcols x};\r\n         key[G]!sortAlpha flip(C:f[v]P:flip value flip key F)!raze\r\n          {[i;j;k;x;y]\r\n           a:count[x]#x 0N;\r\n           a[y]:x y;\r\n           b:count[x]#0b;\r\n           b[y]:1b;\r\n           c:a i;\r\n           c[k]:first'[a[j]@'where'[b j]];\r\n           c}[I[;0];I J;J:where 1<>count'[I:value G]]/:\\:[t v;value F]};\r\n\r\n    g:groupby,pivot;\r\n    if[(0<count pivot) and 0=count groupby;'mustSpecifyGroupbyToAllowPivot];\r\n    s:@[;4] parse \"select \",sel,\" from t\";\r\n    t:$[0=count g;select from tbl where i<1000; ?[tbl;();g!g;s]];\r\n    () xkey $[count pivot; piv[() xkey t;groupby;pivot;$[count s;key s;cols[t] except g]]; t]};pulseagg[x;`$" + groupby + ";`$" + pivot + "; \"" + ssel + "\"]}[{" + translation + "}[]]";
        }
        return PivotProvider.pivotStandardSQL(jdbcTypes, groupbylist, pivotlist, sel, translation);
    }

    private static String pivotStandardSQL(JdbcTypes jdbcTypes, List<String> groupbylist, List<String> pivotlist, String sel, String translation) {
        String t;
        if (pivotlist.size() > 0 && groupbylist.size() == 0) {
            throw new RuntimeException("mustSpecifyGroupbyToAllowPivot");
        }
        if (groupbylist.size() > 0 && (sel == null || sel.trim().length() == 0)) {
            throw new RuntimeException("mustSpecifyAggregatesForGroupBy");
        }
        ArrayList<String> g = new ArrayList<String>();
        g.addAll(groupbylist);
        g.addAll(pivotlist);
        if (translation.trim().endsWith(";")) {
            translation = translation.substring(0, translation.lastIndexOf(";"));
        }
        String string = t = translation.contains(" ") ? "(" + translation + ")" : translation;
        if (g.size() == 0) {
            translation = "SELECT * FROM " + t + " LIMIT 1000";
        } else {
            String gby = PivotProvider.toColumnCSV(jdbcTypes, g);
            String plist = PivotProvider.toColumnCSV(jdbcTypes, pivotlist);
            String sclauses = Arrays.asList(sel.split(",", -1)).stream().map(s -> PivotProvider.toSqlSel(jdbcTypes, s)).collect(Collectors.joining(","));
            String selec = gby + ", " + sclauses;
            if (jdbcTypes.equals((Object)JdbcTypes.DUCKDB) && pivotlist.size() > 0) {
                String grpby = PivotProvider.toColumnCSV(jdbcTypes, groupbylist);
                translation = "PIVOT " + t + " ON " + plist + " USING " + sclauses + " GROUP BY " + grpby + " ORDER BY " + grpby;
            } else {
                translation = "SELECT " + selec + " FROM " + t + " GROUP BY " + gby + " ORDER BY " + gby;
            }
        }
        return translation;
    }

    private static String e(JdbcTypes jdbcTypes, String columnName) {
        if (jdbcTypes.equals((Object)JdbcTypes.H2)) {
            return columnName.equals("*") ? "*" : "\"" + columnName.replace("\"", "\\\"") + "\"";
        }
        return columnName.equals("*") ? "*" : (columnName.contains(" ") ? "\"" + columnName.replace("\"", "\\\"") + "\"" : columnName);
    }

    private static String toColumnCSV(JdbcTypes jdbcTypes, List<String> sclause) {
        return sclause.stream().map(s -> PivotProvider.e(jdbcTypes, s)).collect(Collectors.joining(","));
    }

    private static String toSqlSel(JdbcTypes jdbcTypes, String sclause) {
        int p;
        String[] assign = sclause.split(":");
        String op = assign[1].substring(0, p = assign[1].indexOf(" ")).trim().toLowerCase();
        if (op.equals("var")) {
            op = "VAR_POP";
        }
        if (op.equals("svar")) {
            op = "VAR_SAMP";
        }
        if (op.equals("dev")) {
            op = "STDDEV_POP";
        }
        if (op.equals("sdev")) {
            op = "STDDEV_SAMP";
        }
        String cname = assign[1].substring(p + 1).trim();
        return op + "(" + PivotProvider.e(jdbcTypes, cname) + ") as " + PivotProvider.e(jdbcTypes, assign[0]);
    }
}

