/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.timestored.babeldb.BabelDBJdbcDriver;
import com.timestored.babeldb.SimpleResultSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.rowset.CachedRowSet;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Versions;

public class JsonResultSetBuilder {
    private static final Logger log = Logger.getLogger(JsonResultSetBuilder.class.getName());
    public static SqlTypeMerger SQL_TYPE_MERGER = new SqlTypeMerger();

    public static CachedRowSet fromJSON(String json) throws JsonMappingException, JsonProcessingException {
        return JsonResultSetBuilder.fromJSON(json, "");
    }

    public static JsonMapper getObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true)).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true)).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true)).build();
    }

    public static SimpleResultSet fromJSON(String json, String path) throws JsonMappingException, JsonProcessingException {
        JsonMapper objectMapper = JsonResultSetBuilder.getObjectMapper();
        JsonNode n = objectMapper.readTree(json);
        try {
            ArrayNode an;
            if (!path.isEmpty()) {
                an = objectMapper.createArrayNode();
                JsonQuery q = JsonQuery.compile(path, Versions.JQ_1_6);
                Scope sc = Scope.newEmptyScope();
                BuiltinFunctionLoader.getInstance().loadFunctions(Versions.JQ_1_6, sc);
                q.apply(sc, n, an::add);
                JsonNode jsonNode = n = an.size() == 1 ? an.get(0) : an;
                if (n instanceof NullNode) {
                    throw new IllegalStateException(json);
                }
            }
            if ((an = JsonResultSetBuilder.findArrayNode(n)) != null) {
                return JsonResultSetBuilder.fromJSON(an);
            }
            if (n instanceof ObjectNode) {
                return JsonResultSetBuilder.fromSingleObjectNode((ObjectNode)n);
            }
            if (n instanceof ValueNode) {
                an = objectMapper.createArrayNode();
                an.add(n);
                return JsonResultSetBuilder.fromJSON(an);
            }
        }
        catch (JsonProcessingException | ClassCastException e) {
            if (n != null) {
                return new SimpleResultSet(new String[]{"jsonError"}, new Object[]{new String[]{json, n.toPrettyString(), e.toString()}});
            }
            return new SimpleResultSet(new String[]{"jsonError"}, new Object[]{new String[]{json, e.toString()}});
        }
        return new SimpleResultSet(new String[]{"InvalidJson"}, new Object[]{new String[]{json}});
    }

    private static Stream<Map.Entry<String, JsonNode>> toStream(ObjectNode n) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(n.fields(), 16), false);
    }

    private static Stream<JsonNode> toStream(ArrayNode n) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(n.elements(), 16), false);
    }

    private static SimpleResultSet fromSingleObjectNode(ObjectNode n) {
        ArrayList keys = new ArrayList();
        ArrayList vals = new ArrayList();
        JsonResultSetBuilder.toStream(n).forEach(e -> {
            keys.add((String)e.getKey());
            vals.add(((JsonNode)e.getValue()).toPrettyString());
        });
        Object[] cols = new Object[]{keys.toArray(new String[0]), vals.toArray(new String[0])};
        return new SimpleResultSet(new String[]{"keys", "vals"}, cols);
    }

    private static ArrayNode findArrayNode(JsonNode n) {
        if (n instanceof ArrayNode) {
            return (ArrayNode)n;
        }
        if (n.isObject()) {
            ObjectNode objectNode = (ObjectNode)n;
            Iterator<Map.Entry<String, JsonNode>> iter = objectNode.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                if (!entry.getValue().isArray()) continue;
                return (ArrayNode)entry.getValue();
            }
        }
        return null;
    }

    private static SimpleResultSet fromJSON(ArrayNode arrayNode) throws JsonMappingException, JsonProcessingException {
        int sz = arrayNode.size();
        if (sz == 0) {
            return new SimpleResultSet(new String[]{"empty"});
        }
        if (arrayNode.get(0).isValueNode()) {
            return JsonResultSetBuilder.fromArrayOfvalueNodes(arrayNode);
        }
        if (arrayNode.get(0).isObject()) {
            return JsonResultSetBuilder.fromArrayOfObjectNodes(arrayNode);
        }
        if (arrayNode.get(0).isArray()) {
            return JsonResultSetBuilder.fromArrayOfObjectNodes(arrayNode);
        }
        return new SimpleResultSet(new String[]{"a"}, new Object[]{new String[]{"v1", "v2"}});
    }

    private static SimpleResultSet fromArrayOfObjectNodes(ArrayNode arrayNode) {
        int sz = arrayNode.size();
        LinkedHashSet keys = new LinkedHashSet();
        HashMap<String, Integer> cTypes = new HashMap<String, Integer>();
        JsonResultSetBuilder.toStream(arrayNode).forEach(jsn -> {
            if (jsn instanceof ObjectNode) {
                JsonResultSetBuilder.toStream((ObjectNode)jsn).forEach(e -> {
                    String k = (String)e.getKey();
                    keys.add(k);
                    cTypes.merge(k, JsonResultSetBuilder.toSQLtype((JsonNode)e.getValue()), new SqlTypeMerger());
                });
            } else {
                ArrayNode an = (ArrayNode)jsn;
                for (int i = 0; i < an.size(); ++i) {
                    String k = "c" + i;
                    keys.add(k);
                    cTypes.merge(k, JsonResultSetBuilder.toSQLtype(an.get(i)), new SqlTypeMerger());
                }
            }
        });
        SqlTypeMerger.replaceNulls(cTypes);
        String[] colNames = keys.toArray(new String[0]);
        List<String> cNames = Arrays.asList(colNames);
        Object[] colVals = SimpleResultSet.getArray(cNames.stream().map(cTypes::get).collect(Collectors.toList()), sz);
        int r = 0;
        for (JsonNode jsn2 : arrayNode) {
            int row = r;
            if (jsn2 instanceof ObjectNode) {
                JsonResultSetBuilder.toStream((ObjectNode)jsn2).forEach(e -> {
                    block2: {
                        int c2 = cNames.indexOf(e.getKey());
                        Object val2 = JsonResultSetBuilder.getValue((JsonNode)e.getValue(), (Integer)cTypes.get(e.getKey()));
                        try {
                            JsonResultSetBuilder.arraySetUnlessNull(colVals[c2], row, val2);
                        }
                        catch (IllegalArgumentException iae) {
                            if (val2 == null || colVals[c2] == null) break block2;
                            log.fine("Tried to place object of type " + val2.getClass().getSimpleName() + " into " + colVals[c2].getClass().getSimpleName());
                        }
                    }
                });
            } else {
                ArrayNode an = (ArrayNode)jsn2;
                for (int i = 0; i < an.size(); ++i) {
                    String k = "c" + i;
                    int c2 = cNames.indexOf(k);
                    Object val2 = JsonResultSetBuilder.getValue(an.get(i), (Integer)cTypes.get(k));
                    JsonResultSetBuilder.arraySetUnlessNull(colVals[c2], row, val2);
                }
            }
            ++r;
        }
        return new SimpleResultSet(colNames, colVals);
    }

    public static void arraySetUnlessNull(Object array, int row, Object val2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (val2 != null || array instanceof Object[]) {
            Array.set(array, row, val2);
        }
    }

    private static Object getValue(JsonNode on, int sqlType) {
        switch (sqlType) {
            case 8: {
                return on.isNull() ? Double.NaN : on.asDouble();
            }
            case 4: {
                return on.isNull() ? null : Integer.valueOf(on.asInt());
            }
            case -5: {
                return on.isNull() ? null : Long.valueOf(on.asLong());
            }
            case 16: {
                return on.isNull() ? null : Boolean.valueOf(on.asBoolean());
            }
        }
        if (on.isNull()) {
            return null;
        }
        return BabelDBJdbcDriver.getValue(JsonResultSetBuilder.unquote(on.toString()), sqlType);
    }

    public static String unquote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1).replaceAll("\\\"", "\"");
        }
        return value;
    }

    private static Integer toSQLtype(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            return 0;
        }
        JsonNodeType nodeType = jsonNode.getNodeType();
        switch (nodeType) {
            case NUMBER: {
                return jsonNode.asText().contains(".") ? 8 : -5;
            }
            case BOOLEAN: {
                return 16;
            }
        }
        return BabelDBJdbcDriver.toSQLtype(jsonNode.asText());
    }

    private static SimpleResultSet fromArrayOfvalueNodes(ArrayNode arrayNode) {
        int sz = arrayNode.size();
        Object[] valArray = null;
        ValueNode vn = (ValueNode)arrayNode.get(0);
        String t = vn.getNodeType().name();
        Iterator<JsonNode> it = arrayNode.iterator();
        int i = 0;
        switch (vn.getNodeType()) {
            case BOOLEAN: 
            case NULL: 
            case OBJECT: 
            case STRING: 
            case POJO: 
            case ARRAY: 
            case BINARY: 
            case MISSING: {
                String[] v;
                valArray = v = new String[sz];
                while (it.hasNext()) {
                    v[i++] = it.next().toString();
                }
                break;
            }
            case NUMBER: {
                double[] d = new double[sz];
                valArray = d;
                while (it.hasNext()) {
                    d[i++] = it.next().asDouble();
                }
                break;
            }
        }
        return new SimpleResultSet(new String[]{t}, new Object[]{valArray});
    }

    static class SqlTypeMerger
    implements BiFunction<Integer, Integer, Integer> {
        SqlTypeMerger() {
        }

        @Override
        public Integer apply(Integer a, Integer b) {
            if (a.equals(8) && b.equals(-5)) {
                return 8;
            }
            if (a.equals(-5) && b.equals(8)) {
                return 8;
            }
            if (a.equals(0)) {
                return b;
            }
            if (b.equals(0)) {
                return a;
            }
            return a.equals(b) ? a : 12;
        }

        static void replaceNulls(Map<String, Integer> cTypes) {
            cTypes.forEach((s, i) -> {
                if (i == 0) {
                    cTypes.put((String)s, 12);
                }
            });
        }
    }
}

