/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import com.google.common.base.Preconditions;
import com.timestored.babeldb.JsonResultSetBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class HtmlToCsvConverter {
    private static final Logger log = Logger.getLogger(HtmlToCsvConverter.class.getName());

    HtmlToCsvConverter() {
    }

    public static List<String[]> toStringArray(String htmlTxt) {
        Document doc = Jsoup.parse(htmlTxt);
        boolean isWiki = htmlTxt.contains("- Wikipedia</title>");
        if (isWiki) {
            doc.select("sup").remove();
        }
        Elements tables = doc.select("table");
        ArrayList<String[]> all = new ArrayList<String[]>();
        ArrayList<String> headers = new ArrayList<String>();
        boolean raggedArray = false;
        all.add(new String[0]);
        for (Element tbl : tables) {
            List<String[]> cur;
            Set<String> cns = tbl.classNames();
            if (cns.contains("sidebar") || cns.contains("navbox-inner") || cns.contains("infobox") || cns.contains("vcard") || cns.contains("navbox-subgroup") || (cur = HtmlToCsvConverter.toStringArray(tbl)).size() < 2) continue;
            if (headers.size() == 0) {
                for (String s : cur.get(0)) {
                    headers.add(s);
                }
            }
            if (HtmlToCsvConverter.equalsIgnoreCase(cur.get(0), headers.toArray(new String[0]))) {
                for (int r = 1; r < cur.size(); ++r) {
                    all.add(cur.get(r));
                }
                continue;
            }
            raggedArray = true;
            int[] newIndices = new int[cur.get(0).length];
            for (int c2 = 0; c2 < cur.get(0).length; ++c2) {
                String e = cur.get(0)[c2];
                int p = headers.indexOf(e);
                if (p == -1) {
                    headers.add(e);
                    newIndices[c2] = headers.size() - 1;
                    continue;
                }
                newIndices[c2] = p;
            }
            for (int r = 1; r < cur.size(); ++r) {
                String[] cols = cur.get(r);
                String[] newRow = new String[headers.size()];
                for (int c3 = 0; c3 < cols.length; ++c3) {
                    if (c3 >= newIndices.length) continue;
                    newRow[newIndices[c3]] = cols[c3];
                }
            }
        }
        all.set(0, headers.toArray(new String[0]));
        HtmlToCsvConverter.autoConvertRecognisedTypes(all);
        return all;
    }

    private static void autoConvertRecognisedTypes(List<String[]> all) {
        for (int c2 = 0; c2 < all.get(0).length; ++c2) {
            String s;
            int r;
            int type = 0;
            for (r = 1; r < all.size(); ++r) {
                if (c2 >= all.get(r).length) continue;
                s = all.get(r)[c2];
                type = JsonResultSetBuilder.SQL_TYPE_MERGER.apply(type, HtmlToCsvConverter.toSQLtype(s));
            }
            if (type == 0) continue;
            for (r = 1; r < all.size(); ++r) {
                if (c2 >= all.get(r).length) continue;
                s = all.get(r)[c2];
                all.get((int)r)[c2] = HtmlToCsvConverter.getValue(s, type);
            }
        }
    }

    static String getValue(String s, Integer sqlType) {
        if (sqlType == 91) {
            try {
                SimpleDateFormat fmt = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
                Date d = fmt.parse(s);
                SimpleDateFormat oFormat = new SimpleDateFormat("yyyy-MM-dd");
                return oFormat.format(d);
            }
            catch (ParseException e) {
                log.fine("Error parsing " + s + " " + e.getLocalizedMessage());
            }
        }
        return s;
    }

    static Integer toSQLtype(String s) {
        if (s.contains(",") && "JFMASOND".contains("" + s.charAt(0))) {
            try {
                SimpleDateFormat fmt = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
                Date d = fmt.parse(s);
                return 91;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static boolean equalsIgnoreCase(String[] a, String[] b) {
        Preconditions.checkNotNull(a);
        if (b == null || a.length != b.length) {
            return false;
        }
        int i = 0;
        if (i < a.length) {
            if (a[i] == null && b[i] == null) {
                return true;
            }
            if (a[i] == null || b[i] == null) {
                return false;
            }
            return a[i].equalsIgnoreCase(b[i]);
        }
        return false;
    }

    public static List<String[]> toStringArray(Element table) {
        Element tbl = table;
        Element head = tbl.selectFirst("thead");
        Elements body = tbl.select("tbody");
        boolean hasBody = body.size() == 1 && head != null;
        tbl = hasBody ? table : (Element)body.get(0);
        Elements rows = tbl.select("tr:not(:first-child)");
        Elements headerRows = new Elements(tbl.selectFirst("tr"));
        if ((double)tbl.select("tr:has(> th)").size() < 0.5 * (double)rows.size()) {
            headerRows = tbl.select("tr:has(> th)");
            rows = tbl.select("tr:not(:has(> th))");
        }
        if (tbl.selectFirst("tr").classNames().contains("static-row-header")) {
            rows = tbl.select("tr:not(.static-row-header)");
            headerRows = tbl.select("tr.static-row-header");
        }
        if (rows.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String[]> tList = new ArrayList<String[]>(rows.size());
        tList.add(new String[0]);
        for (int r = 0; r < rows.size(); ++r) {
            tList.add(HtmlToCsvConverter.toArray((Element)rows.get(r)));
        }
        ArrayList<String[]> headers = new ArrayList<String[]>();
        for (Element element : headerRows) {
            headers.add(HtmlToCsvConverter.toArray(element));
        }
        for (Object[] objectArray : headers) {
            if (objectArray.length <= ((String[])tList.get(0)).length || Arrays.toString(objectArray).length() <= Arrays.toString((Object[])tList.get(0)).length() || objectArray.length <= 1) continue;
            tList.set(0, (String[])objectArray);
        }
        int maxLength = tList.stream().mapToInt(e -> ((String[])e).length).max().getAsInt();
        String[] stringArray = (String[])tList.get(0);
        if (stringArray.length < maxLength) {
            String[] sa = new String[maxLength];
            for (int i = 0; i < maxLength; ++i) {
                sa[i] = i < stringArray.length ? stringArray[i] : "c" + i;
            }
        }
        return tList;
    }

    private static String[] toArray(Element row) {
        Elements colVals = row.select("td,th");
        String[] colStrings = new String[colVals.size()];
        int c2 = 0;
        for (Element e : colVals) {
            colStrings[c2++] = e.text();
        }
        return colStrings;
    }
}

