/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import com.google.common.base.Preconditions;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.sqldash.chart.SqlHelper;
import jakarta.annotation.Nullable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialJavaObject;

public class DBHelper {
    private static final Logger LOG = Logger.getLogger(DBHelper.class.getName());

    public static int getSize(ResultSet rs2) throws SQLException {
        rs2.last();
        int size = rs2.getRow();
        rs2.beforeFirst();
        return size;
    }

    @Nullable
    public static TblDelta calculateDelta(ResultSet prevRS, ResultSet latestRS) {
        Preconditions.checkNotNull(prevRS);
        Preconditions.checkNotNull(latestRS);
        try {
            if (!DBHelper.isMetaEqual(prevRS, latestRS)) {
                return null;
            }
            int cols = prevRS.getMetaData().getColumnCount();
            int prevC = DBHelper.getSize(prevRS);
            int mid = (int)Math.floor(prevC / 2);
            prevRS.absolute(mid);
            int latestRSmatchRow = -1;
            while (latestRS.next()) {
                int c2;
                for (c2 = 1; c2 <= cols && Objects.equals(prevRS.getObject(c2), latestRS.getObject(c2)); ++c2) {
                }
                if (c2 != cols + 1) continue;
                latestRSmatchRow = latestRS.getRow();
            }
            int equalsWidthUp = 0;
            while (prevRS.next() & latestRS.next()) {
                int c3;
                for (c3 = 1; c3 <= cols && Objects.equals(prevRS.getObject(c3), latestRS.getObject(c3)); ++c3) {
                }
                if (c3 != cols + 1) break;
                ++equalsWidthUp;
            }
            prevRS.absolute(mid);
            latestRS.absolute(latestRSmatchRow);
            int equalsWidthDown = 0;
            while (prevRS.previous() & latestRS.previous()) {
                int c4;
                for (c4 = 1; c4 <= cols && Objects.equals(prevRS.getObject(c4), latestRS.getObject(c4)); ++c4) {
                }
                if (c4 != cols + 1) break;
                ++equalsWidthDown;
            }
            int droppedHeadRows = mid - equalsWidthDown;
            int droppedTailRows = DBHelper.getSize(prevRS) - (mid + equalsWidthUp);
            int newHeadRowCount = latestRSmatchRow - equalsWidthDown;
            int newTailRowCount = DBHelper.getSize(latestRS) - (latestRSmatchRow + equalsWidthUp);
            if (newHeadRowCount > 0) {
                // empty if block
            }
            return new TblDelta(prevRS, latestRS, equalsWidthUp, equalsWidthDown);
        }
        catch (SQLException e) {
            LOG.log(Level.WARNING, "Error. Assuming TblDelta not possible", e);
            return null;
        }
    }

    public static boolean isEqual(ResultSet rsA, ResultSet rsB) {
        if (rsB == null) {
            return rsA == null;
        }
        if (rsA == null) {
            return rsB == null;
        }
        try {
            if (!DBHelper.isMetaEqual(rsA, rsB)) {
                return false;
            }
            int cols = rsA.getMetaData().getColumnCount();
            rsA.beforeFirst();
            rsB.beforeFirst();
            while (rsA.next() & rsB.next()) {
                for (int c2 = 1; c2 <= cols; ++c2) {
                    boolean eq = Objects.equals(rsA.getObject(c2), rsB.getObject(c2));
                    if (eq) continue;
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINE, " rsA.getObject(c) = " + rsA.getObject(c2));
                        LOG.log(Level.FINE, " rsB.getObject(c) = " + rsB.getObject(c2));
                    }
                    return false;
                }
            }
            return rsA.isAfterLast() && rsB.isAfterLast();
        }
        catch (SQLException e) {
            LOG.log(Level.WARNING, "Error. Assuming isEqualResultSets false", e);
            return false;
        }
    }

    public static List<String> getColumnNames(ResultSetMetaData rsmd) throws SQLException {
        int cols = rsmd.getColumnCount();
        ArrayList<String> cns = new ArrayList<String>(cols);
        for (int c2 = 1; c2 <= cols; ++c2) {
            cns.add(rsmd.getColumnName(c2));
        }
        return cns;
    }

    private static boolean isMetaEqual(ResultSet rsA, ResultSet rsB) throws SQLException {
        ResultSetMetaData mdB;
        ResultSetMetaData mdA = rsA.getMetaData();
        int cols = mdA.getColumnCount();
        if (cols != (mdB = rsB.getMetaData()).getColumnCount()) {
            return false;
        }
        for (int c2 = 1; c2 <= cols; ++c2) {
            if (!mdA.getColumnName(c2).equals(mdB.getColumnName(c2))) {
                return false;
            }
            if (mdA.getColumnType(c2) == mdB.getColumnType(c2)) continue;
            return false;
        }
        return true;
    }

    public static final String toString(ResultSet rs2, boolean withTypesInHeader) throws SQLException {
        int i;
        StringBuilder sb = new StringBuilder();
        ResultSetMetaData rsmd = rs2.getMetaData();
        int cn = rsmd.getColumnCount();
        if (withTypesInHeader) {
            for (i = 1; i <= cn; ++i) {
                if (i > 1) {
                    sb.append(" | ");
                }
                sb.append(rsmd.getColumnType(i));
            }
            sb.append("\r\n");
        }
        for (i = 1; i <= cn; ++i) {
            if (i > 1) {
                sb.append(" | ");
            }
            sb.append(rsmd.getColumnLabel(i));
        }
        sb.append("\r\n");
        rs2.beforeFirst();
        Object o = null;
        while (rs2.next()) {
            block7: for (int i2 = 1; i2 <= cn; ++i2) {
                int ct = rsmd.getColumnType(i2);
                if (i2 > 1) {
                    sb.append(" | ");
                }
                switch (ct) {
                    case 91: {
                        o = rs2.getObject(i2);
                        if (o == null || rs2.wasNull()) {
                            sb.append(" ");
                            continue block7;
                        }
                        if (o instanceof Date) {
                            sb.append(new SimpleDateFormat("yyyy-MM-dd").format((Date)o));
                            continue block7;
                        }
                        sb.append("" + o);
                        continue block7;
                    }
                    case 2003: {
                        o = rs2.getObject(i2);
                        sb.append(DBHelper.convertArrayToString(o));
                        continue block7;
                    }
                    default: {
                        o = rs2.getObject(i2);
                        sb.append(o == null || rs2.wasNull() ? " " : "" + o);
                    }
                }
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static CachedRowSet toCRS(ResultSet rs2) throws SQLException {
        if (rs2 == null) {
            return null;
        }
        if (rs2 instanceof CachedRowSet) {
            return (CachedRowSet)rs2;
        }
        CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();
        crs.populate(rs2);
        return crs;
    }

    public static String convertArrayToString(Object o) throws SQLException {
        boolean duckdbArray;
        if (o == null) {
            return "";
        }
        if (o instanceof SerialArray) {
            SerialArray sa = (SerialArray)o;
            o = sa.getArray();
        }
        boolean bl = duckdbArray = o instanceof Object[] && ((Object[])o).length > 0 && ((Object[])o)[0] instanceof SerialJavaObject;
        if (duckdbArray) {
            Object[] sa = o;
            Object[] oa = new Object[sa.length];
            for (int i = 0; i < sa.length; ++i) {
                oa[i] = ((SerialJavaObject)sa[i]).getObject();
            }
            o = oa;
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        if (o instanceof String[]) {
            return Arrays.toString((String[])o);
        }
        if (o instanceof Object[]) {
            return Arrays.toString(o);
        }
        return o.toString();
    }

    public static String toKdbStringList(Collection<String> l) {
        if (l.size() == 1) {
            StringBuilder sb = new StringBuilder("(");
            sb.append("enlist ").append(DBHelper.wrapKdbString("" + l.iterator().next()));
            sb.append(")");
            return sb.toString();
        }
        return DBHelper.toStringList("(", ")", ";", l, o -> DBHelper.wrapKdbString("" + o));
    }

    public static String toStringList(String starter, String ender, String sep, Collection<String> l, Function<String, String> wrapper) {
        StringBuilder sb = new StringBuilder(starter);
        boolean firstEntry = true;
        for (String o : l) {
            if (!firstEntry) {
                sb.append(sep);
            }
            sb.append(wrapper.apply("" + o));
            firstEntry = false;
        }
        sb.append(ender);
        return sb.toString();
    }

    public static String wrapKdbString(String s) {
        String r = "";
        if (s.length() < 2) {
            r = "enlist ";
        }
        r = r + "\"" + s.replace("\"", "\\\"") + "\"";
        return r;
    }

    public static ColumnInfo[] getColumnInfos(ResultSet rs2) throws SQLException {
        ResultSetMetaData rsmd = rs2.getMetaData();
        int cn = rsmd.getColumnCount();
        ColumnInfo[] ci = new ColumnInfo[cn];
        for (int i = 1; i <= cn; ++i) {
            String ctn;
            int ct = rsmd.getColumnType(i);
            ci[i - 1] = SqlHelper.isNumeric(ct, ctn = rsmd.getColumnTypeName(i)) ? new NumericColumnInfo() : new GenericColumnInfo();
        }
        rs2.beforeFirst();
        Object o = null;
        while (rs2.next()) {
            for (int i = 1; i <= cn; ++i) {
                o = rs2.getObject(i);
                boolean wasNull = rs2.wasNull();
                ci[i - 1].addEntry(o, wasNull);
            }
        }
        return ci;
    }

    private static class NumericColumnInfo
    extends ColumnInfo {
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;
        private double sum = 0.0;

        @Override
        public String getColumnInfo() {
            return super.getColumnInfo() + "\nmin: " + KdbHelper.formatFloatingPt(this.min) + "\nmax: " + KdbHelper.formatFloatingPt(this.max) + "\nsum: " + KdbHelper.formatFloatingPt(this.sum) + "\naverage: " + KdbHelper.formatFloatingPt(this.sum / (double)(this.count - ((ColumnInfo)this).nullCount));
        }

        @Override
        public void addEntry(Object o, boolean wasNull) {
            super.addEntry(o, wasNull);
            if (o != null && o instanceof Number) {
                Number n = (Number)o;
                double d = n.doubleValue();
                this.sum += d;
                this.min = Math.min(d, this.min);
                this.max = Math.max(d, this.max);
            }
        }

        @Override
        public String toString() {
            return this.getColumnInfo();
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getSum() {
            return this.sum;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public void setSum(double sum) {
            this.sum = sum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NumericColumnInfo)) {
                return false;
            }
            NumericColumnInfo other = (NumericColumnInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getMin(), other.getMin()) != 0) {
                return false;
            }
            if (Double.compare(this.getMax(), other.getMax()) != 0) {
                return false;
            }
            return Double.compare(this.getSum(), other.getSum()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof NumericColumnInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $min = Double.doubleToLongBits(this.getMin());
            result = result * 59 + (int)($min >>> 32 ^ $min);
            long $max = Double.doubleToLongBits(this.getMax());
            result = result * 59 + (int)($max >>> 32 ^ $max);
            long $sum = Double.doubleToLongBits(this.getSum());
            result = result * 59 + (int)($sum >>> 32 ^ $sum);
            return result;
        }
    }

    public static abstract class ColumnInfo {
        private static final int MAX_SIZE = 10000;
        private int nullCount;
        protected int count;
        private Map<Object, Integer> distinctCountMap = new HashMap<Object, Integer>();

        void addEntry(Object o, boolean wasNull) {
            ++this.count;
            boolean isNull = wasNull || o == null;
            this.nullCount += isNull ? 1 : 0;
            if (this.distinctCountMap.size() < 10000) {
                this.distinctCountMap.merge(o, 1, Integer::sum);
            }
        }

        public String getColumnInfo() {
            if (this.count == 0) {
                return "";
            }
            String s = "nulls: " + this.nullCount + "\ncount: " + this.count;
            if (this.distinctCountMap.size() == this.count) {
                s = s + "\ndistincts: Every row unique.";
            } else if (this.distinctCountMap.size() == this.count) {
                s = s + "\ndistincts: All same value.";
            } else if (this.distinctCountMap.size() < 10000) {
                s = s + "\ndistincts: " + (this.distinctCountMap.size() < 10 ? this.distinctCountMap.toString() : Integer.valueOf(this.distinctCountMap.size()));
            }
            return s;
        }

        public String toString() {
            return this.getColumnInfo();
        }
    }

    public static class GenericColumnInfo
    extends ColumnInfo {
        private String min = null;
        private String max = null;

        @Override
        public String getColumnInfo() {
            return super.getColumnInfo() + (this.count > 1 && this.min != null && this.max != null ? "\nmin: " + this.min + "\nmax: " + this.max : "");
        }

        @Override
        public void addEntry(Object o, boolean wasNull) {
            super.addEntry(o, wasNull);
            if (!wasNull && o != null) {
                String s = o.toString();
                String string = this.min == null ? s : (this.min = s.compareTo(this.min) > 0 ? this.min : s);
                this.max = this.max == null ? s : (s.compareTo(this.max) > 0 ? s : this.max);
            }
        }

        @Override
        public String toString() {
            return this.getColumnInfo();
        }
    }

    private static class TblDelta {
        private final ResultSet newHeadRows;
        private final ResultSet newTailRows;
        private final int droppedHeadRows;
        private final int droppedTailRows;

        public TblDelta(ResultSet newHeadRows, ResultSet newTailRows, int droppedHeadRows, int droppedTailRows) {
            this.newHeadRows = newHeadRows;
            this.newTailRows = newTailRows;
            this.droppedHeadRows = droppedHeadRows;
            this.droppedTailRows = droppedTailRows;
        }

        public ResultSet getNewHeadRows() {
            return this.newHeadRows;
        }

        public ResultSet getNewTailRows() {
            return this.newTailRows;
        }

        public int getDroppedHeadRows() {
            return this.droppedHeadRows;
        }

        public int getDroppedTailRows() {
            return this.droppedTailRows;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TblDelta)) {
                return false;
            }
            TblDelta other = (TblDelta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDroppedHeadRows() != other.getDroppedHeadRows()) {
                return false;
            }
            if (this.getDroppedTailRows() != other.getDroppedTailRows()) {
                return false;
            }
            ResultSet this$newHeadRows = this.getNewHeadRows();
            ResultSet other$newHeadRows = other.getNewHeadRows();
            if (this$newHeadRows == null ? other$newHeadRows != null : !this$newHeadRows.equals(other$newHeadRows)) {
                return false;
            }
            ResultSet this$newTailRows = this.getNewTailRows();
            ResultSet other$newTailRows = other.getNewTailRows();
            return !(this$newTailRows == null ? other$newTailRows != null : !this$newTailRows.equals(other$newTailRows));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TblDelta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDroppedHeadRows();
            result = result * 59 + this.getDroppedTailRows();
            ResultSet $newHeadRows = this.getNewHeadRows();
            result = result * 59 + ($newHeadRows == null ? 43 : $newHeadRows.hashCode());
            ResultSet $newTailRows = this.getNewTailRows();
            result = result * 59 + ($newTailRows == null ? 43 : $newTailRows.hashCode());
            return result;
        }

        public String toString() {
            return "DBHelper.TblDelta(newHeadRows=" + this.getNewHeadRows() + ", newTailRows=" + this.getNewTailRows() + ", droppedHeadRows=" + this.getDroppedHeadRows() + ", droppedTailRows=" + this.getDroppedTailRows() + ")";
        }
    }
}

