/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Curler {
    private static String TEST_URL = "http://localhost:8080";
    private static Logger log = LoggerFactory.getLogger(Curler.class);
    private static boolean curlExists = false;
    private static boolean curlTested = false;

    private static boolean doesCurlExist() {
        if (curlTested) {
            return curlExists;
        }
        curlTested = true;
        try {
            String s = Curler.curlFetchURL(TEST_URL, "GET", "text/plain");
            boolean bl = curlExists = s != null && s.length() > 0;
            if (!curlExists) {
                log.warn("curl does NOT exist. Pinging testurl failed");
            }
        }
        catch (IOException e) {
            log.warn("curl failed: " + e.getLocalizedMessage());
        }
        return curlExists;
    }

    public static String fetchURL(String url) {
        return Curler.fetchURL(url, "GET", "text/plain");
    }

    public static String fetchURL(String url, String method, String acceptRequestType) {
        String u = url.replace(" ", "%20");
        String r = null;
        try {
            r = Curler.javaFetchURL(u, method, acceptRequestType, null, null);
        }
        catch (Exception e) {
            log.warn("javaFetchURL failed: " + e.getLocalizedMessage().replace(url, "URLURL"));
        }
        if (r == null && Curler.doesCurlExist()) {
            try {
                r = Curler.curlFetchURL(u, method, acceptRequestType);
            }
            catch (IOException e) {
                log.warn("curlFetchURL failed: " + e.getLocalizedMessage().replace(url, "URLURL"));
            }
        }
        return r;
    }

    private static String getUrlArgForCurl(URLdetails ud) {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        return isWin ? "\"" + ud.u.replace("\"", "\\\"") + "\"" : ud.u;
    }

    static String curlFetchURL(String url, String method, String acceptRequestType) throws IOException {
        URLdetails ud = new URLdetails(Objects.requireNonNull(url));
        String auth = ud.getAuth() == null || ud.getAuth().length() < 1 ? "a:b" : ud.getAuth();
        ArrayList<String> args = new ArrayList<String>();
        args.add("curl");
        if (method != null) {
            args.add("-X");
            args.add(method);
        }
        if (acceptRequestType != null) {
            args.add("-H");
            args.add("Accept: " + acceptRequestType);
        }
        for (String s : new String[]{"--globoff", "--silent", "-u", auth, Curler.getUrlArgForCurl(ud)}) {
            args.add(s);
        }
        return Curler.runArgs(args.toArray(new String[0]));
    }

    private static String runArgs(String[] args) throws IOException {
        Process process = new ProcessBuilder(args).redirectErrorStream(true).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append(System.getProperty("line.separator"));
        }
        reader.close();
        while ((line = bre.readLine()) != null) {
            System.err.println(line);
        }
        bre.close();
        if (process.exitValue() != 0) {
            throw new IOException("Non-zero exit value for runArgs: " + args[0]);
        }
        return sb.toString();
    }

    public static String POST(String url, String acceptRequestType, String reqContentType, byte[] reqDataSent) throws IOException {
        return Curler.javaFetchURL(url, "POST", acceptRequestType, reqContentType, reqDataSent);
    }

    static String javaFetchURL(String url, String method, String acceptRequestType, String reqContentType, byte[] reqDataSent) throws IOException {
        URLdetails ud = new URLdetails(Objects.requireNonNull(url));
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(ud.u).openConnection();
        if (ud.base64 != null) {
            urlConnection.setRequestProperty("Authorization", "Basic " + ud.base64);
        }
        if (acceptRequestType != null) {
            urlConnection.setRequestProperty("Accept", acceptRequestType);
        }
        urlConnection.setRequestMethod(method);
        if (reqContentType != null) {
            urlConnection.setRequestProperty("Content-Type", reqContentType);
        }
        if (reqDataSent != null) {
            urlConnection.setDoOutput(reqDataSent != null);
            try (OutputStream os = urlConnection.getOutputStream();){
                os.write(reqDataSent);
            }
        }
        if (urlConnection.getResponseCode() == 200) {
            StringBuffer response = new StringBuffer();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine).append("\n");
                }
            }
            return response.toString();
        }
        log.warn("HTTP request failed, code:" + urlConnection.getResponseCode());
        return null;
    }

    public static boolean downloadFileTo(String url, File f) throws IOException {
        if (!f.getParentFile().isDirectory() && !f.getParentFile().mkdirs()) {
            throw new IOException(f.getAbsolutePath() + " not creatable");
        }
        log.info("Downloading " + url + " -> " + f.getAbsolutePath());
        boolean r = false;
        try {
            Curler.javaDownloadFileTo(url, f);
            r = true;
        }
        catch (Exception e) {
            log.warn("javaDownloadFileTo failed: " + e.getLocalizedMessage().replace(url, "URLURL"));
        }
        if (!r && Curler.doesCurlExist()) {
            try {
                Curler.curlDownloadFileTo(url, f);
                r = true;
            }
            catch (Exception e) {
                log.warn("curlDownloadFileTo failed: " + e.getLocalizedMessage().replace(url, "URLURL"));
            }
        }
        return r;
    }

    static void curlDownloadFileTo(String url, File f) throws IOException {
        URLdetails ud = new URLdetails(Objects.requireNonNull(url));
        String auth = ud.getAuth() == null || ud.getAuth().length() < 1 ? "a:b" : ud.getAuth();
        String[] args = new String[]{"curl", "--globoff", "-L", "--fail", "-o", f.getAbsolutePath(), Curler.getUrlArgForCurl(ud)};
        Curler.runArgs(args);
    }

    static void javaDownloadFileTo(String url, File f) throws FileNotFoundException, IOException {
        try (InputStream in = new URL(url).openStream();
             ReadableByteChannel rbc = Channels.newChannel(in);
             FileOutputStream fos = new FileOutputStream(f);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    public static void setTEST_URL(String TEST_URL) {
        Curler.TEST_URL = TEST_URL;
    }

    private static class URLdetails {
        private final String u;
        private final String auth;
        private final String base64;

        public URLdetails(String fullURL) {
            String auth = "";
            String base64 = null;
            String u = Objects.requireNonNull(fullURL);
            if (u.contains("@") && u.contains("//")) {
                auth = fullURL.substring(u.indexOf("//") + 2, u.indexOf(64));
                u = fullURL.substring(0, fullURL.indexOf("//") + 2) + fullURL.substring(fullURL.indexOf(64) + 1);
                try {
                    byte[] data1 = auth.getBytes(StandardCharsets.UTF_8.name());
                    base64 = Base64.getEncoder().encodeToString(data1);
                }
                catch (UnsupportedEncodingException e) {
                    log.error("URLdetails UnsupportedEncodingException1");
                }
            }
            this.u = u;
            this.auth = auth;
            this.base64 = base64;
        }

        public String getU() {
            return this.u;
        }

        public String getAuth() {
            return this.auth;
        }

        public String getBase64() {
            return this.base64;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof URLdetails)) {
                return false;
            }
            URLdetails other = (URLdetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$u = this.getU();
            String other$u = other.getU();
            if (this$u == null ? other$u != null : !this$u.equals(other$u)) {
                return false;
            }
            String this$auth = this.getAuth();
            String other$auth = other.getAuth();
            if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
                return false;
            }
            String this$base64 = this.getBase64();
            String other$base64 = other.getBase64();
            return !(this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64));
        }

        protected boolean canEqual(Object other) {
            return other instanceof URLdetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $u = this.getU();
            result = result * 59 + ($u == null ? 43 : $u.hashCode());
            String $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
            String $base64 = this.getBase64();
            result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
            return result;
        }

        public String toString() {
            return "Curler.URLdetails(u=" + this.getU() + ", auth=" + this.getAuth() + ", base64=" + this.getBase64() + ")";
        }
    }
}

