/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import com.timestored.babeldb.ArgParser;
import com.timestored.babeldb.BaseJdbcDriver;
import com.timestored.babeldb.Curler;
import com.timestored.babeldb.DBHelper;
import com.timestored.babeldb.Dbrunner;
import com.timestored.babeldb.HtmlToCsvConverter;
import com.timestored.babeldb.JsonResultSetBuilder;
import com.timestored.babeldb.SimpleDatabaseMetaData;
import com.timestored.babeldb.SimpleResultSet;
import com.timestored.babeldb.SymPart;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BabelDBJdbcDriver
extends BaseJdbcDriver
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(BabelDBJdbcDriver.class);
    public static CopyOnWriteArrayList<SymbolDetails> SYMBOL_DETAILS = new CopyOnWriteArrayList();
    public static final String BABEL_SYMBOL_qry = "SELECT * FROM symbols;";
    public static final String BABEL_SYMBOL_QRY = "SELECT * FROM SYMBOLS;";
    public static final String QUERY_SYM = "QUERY_SYM";
    private final String jdbcURL;
    private final Connection memConn;
    private final Dbrunner dbrunner;
    private final SqlHandler sqlHandler;
    private static Dbrunner DEFAULT_DBRUNNER;
    public static final String BABEL_SYMBOL_JDBC_URL = "jdbc:babeldb:";
    public static final ConcurrentHashMap<String, BabelDBJdbcDriver> existingDrivers;
    public static String H2_PARAMS;
    private static final String TMPNAME = "temptbl";
    private static final String QRU = "QUERY_";
    private static final String WEBERROR = "Unable to fetch data from WWW. Have you lost internet or been firewalled.";

    public BabelDBJdbcDriver() throws SQLException {
        this(BABEL_SYMBOL_JDBC_URL, null);
    }

    public static BabelDBJdbcDriver getDriverIfExists(String jdbcURL) {
        BabelDBJdbcDriver bab = existingDrivers.computeIfAbsent(jdbcURL, url -> {
            try {
                return new BabelDBJdbcDriver((String)url, null);
            }
            catch (SQLException e) {
                return null;
            }
        });
        return bab;
    }

    @Override
    public Connection connect(String jdbcURL, Properties p) throws SQLException {
        if (!this.acceptsURL(jdbcURL)) {
            return null;
        }
        if (jdbcURL != null && jdbcURL.equals(this.jdbcURL)) {
            return super.connect(jdbcURL, p);
        }
        BabelDBJdbcDriver bab = BabelDBJdbcDriver.getDriverIfExists(jdbcURL);
        if (bab == null) {
            throw new IllegalStateException("Problem connecting to babel");
        }
        return bab.connect(jdbcURL, p);
    }

    public BabelDBJdbcDriver(String jdbcURL, Dbrunner dbrunner) throws SQLException {
        super(BABEL_SYMBOL_JDBC_URL);
        this.jdbcURL = jdbcURL;
        if (jdbcURL != null && !jdbcURL.equals(BABEL_SYMBOL_JDBC_URL)) {
            String underlyingURL = jdbcURL.replace(BABEL_SYMBOL_JDBC_URL, "jdbc:");
            this.memConn = DriverManager.getConnection(underlyingURL);
        } else {
            this.memConn = null;
        }
        this.sqlHandler = jdbcURL.contains(":duckdb:") ? DuckDbSqlHandler.INSTANCE : DefaultSqlHandler.INSTANCE;
        this.dbrunner = dbrunner == null ? DEFAULT_DBRUNNER : dbrunner;
    }

    public static BabelDBJdbcDriver standardH2(String uniqueName, Dbrunner dbrunner) throws SQLException {
        return new BabelDBJdbcDriver("jdbc:babeldb:h2:mem:" + uniqueName + H2_PARAMS, dbrunner);
    }

    public static BabelDBJdbcDriver standardQDuckdb(String uniqueName, Dbrunner dbrunner, File qduckdb) throws SQLException {
        BabelDBJdbcDriver babelDB = new BabelDBJdbcDriver("jdbc:babeldb:duckdb:", dbrunner);
        if (qduckdb != null) {
            babelDB.loadExistingParquet(qduckdb);
        }
        return babelDB;
    }

    @Override
    public void close() throws IOException {
        if (this.memConn != null) {
            try {
                this.memConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void main(String ... args) throws ClassNotFoundException, SQLException {
        try (Connection conn = DriverManager.getConnection(BABEL_SYMBOL_JDBC_URL, "bob", "pass");){
            System.out.println("Connecting to database...");
            try (Statement stmt = conn.createStatement();){
                try (ResultSet rs2 = stmt.executeQuery("https://api.github.com/search/repositories?q=more+useful+keyboard");){
                    while (rs2.next()) {
                        System.out.print(" a: " + rs2.getString("name"));
                        System.out.println(" s: " + rs2.getString("fullName"));
                    }
                }
                rs2 = stmt.executeQuery("SELECT * FROM binance.bookTicker");
                try {
                    System.out.println(DBHelper.toString(rs2, true));
                }
                finally {
                    if (rs2 != null) {
                        rs2.close();
                    }
                }
            }
        }
    }

    private static QueryTranslation translateFromsToSym(QueryTranslation qt) throws IOException, SQLException {
        String FR;
        String sql = qt.getTranslatedQuery();
        String SQL = sql.toUpperCase();
        if (!SQL.contains(FR = " FROM ")) {
            return qt;
        }
        ArrayList<List<String>> commands = new ArrayList<List<String>>(qt.getCmdWithArgs());
        StringBuilder sb = new StringBuilder();
        char[] ca = sql.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (BabelDBJdbcDriver.U(ca[i]) == 'F' && BabelDBJdbcDriver.U(ca[i + 1]) == 'R' && BabelDBJdbcDriver.U(ca[i + 2]) == 'O' && BabelDBJdbcDriver.U(ca[i + 3]) == 'M' && ca[i + 4] == ' ') {
                sb.append(ca[i++]);
                sb.append(ca[i++]);
                sb.append(ca[i++]);
                sb.append(ca[i++]);
                sb.append(ca[i++]);
                while (i < ca.length && ca[i] == ' ') {
                    sb.append(ca[i++]);
                }
                StringBuilder idSB = new StringBuilder(10);
                while (i < ca.length && BabelDBJdbcDriver.isID(ca[i])) {
                    idSB.append(ca[i++]);
                }
                String id = idSB.toString();
                if (id.length() > 2 && id.toUpperCase().startsWith("S_")) {
                    id = id.substring(2);
                    sb.append(id);
                    commands.add(Lists.newArrayList(id, "sym", id));
                } else {
                    sb.append(id);
                }
                if (i >= ca.length) continue;
                sb.append(ca[i]);
                continue;
            }
            sb.append(ca[i]);
        }
        return new QueryTranslation(sql, sb.toString(), commands);
    }

    private static char U(char u) {
        return Character.toUpperCase(u);
    }

    private static boolean isID(char u) {
        return Character.isAlphabetic(u) || Character.isDigit(u) || u == '_' || u == ':' || u == '.';
    }

    private static QueryTranslation translateQueryUnderscore(QueryTranslation qt) throws IOException, SQLException {
        String sql = qt.getTranslatedQuery();
        String SQL = sql.toUpperCase();
        if (!SQL.contains(QRU)) {
            return qt;
        }
        ArrayList<List<String>> commands = new ArrayList<List<String>>(qt.getCmdWithArgs());
        StringBuilder sb = new StringBuilder();
        String[] queries = SQL.split(QRU);
        int start = 0;
        for (int i = 0; i < queries.length; ++i) {
            String S = queries[i];
            String s = sql.substring(start, start + S.length());
            start += S.length() + QRU.length();
            if (i == 0) {
                sb.append(sql.substring(0, S.length()));
                continue;
            }
            int p = s.indexOf("(");
            if (p < 0) {
                throw new IllegalStateException("( missing from query_");
            }
            ArgParser.ParseResult parseRes = ArgParser.parse(s.substring(p));
            String cmd = s.substring(0, p);
            String tname = TMPNAME + commands.size();
            if (cmd.equals("sym")) {
                List<String> symArgs = parseRes.getArgs();
                for (int j = 0; j < symArgs.size(); ++j) {
                    tname = symArgs.get(j).replace(":", "_").replace("-", "_").replace(".", "_");
                    commands.add(Lists.newArrayList(tname, cmd, symArgs.get(j)));
                    sb.append(tname + parseRes.getRemainingCode());
                }
                continue;
            }
            ArrayList<String> cmdArgs = new ArrayList<String>(5);
            cmdArgs.add(tname);
            cmdArgs.add(cmd);
            cmdArgs.addAll(parseRes.getArgs());
            commands.add(cmdArgs);
            sb.append(tname + parseRes.getRemainingCode());
        }
        return new QueryTranslation(sql, sb.toString(), commands);
    }

    public static QueryTranslation translateQry(String sqlToRun) throws IOException, SQLException {
        String q = sqlToRun.trim();
        String SQL = q.toUpperCase().trim();
        if (SQL.length() == 0) {
            return new QueryTranslation(q, null, Collections.emptyList());
        }
        if (SQL.startsWith("HTTP:") || SQL.startsWith("HTTPS:")) {
            return QueryTranslation.withOneCommand(q, Lists.newArrayList("", "web", q));
        }
        if (!SQL.contains(" ") && SQL.matches("^[a-zA-Z0-9_:\\.\\-]*$")) {
            return QueryTranslation.withOneCommand(q, Lists.newArrayList("", "sym", q));
        }
        QueryTranslation qt = new QueryTranslation(sqlToRun, q, Collections.emptyList());
        qt = BabelDBJdbcDriver.translateFromsToSym(qt);
        qt = BabelDBJdbcDriver.translateQueryUnderscore(qt);
        return qt;
    }

    private static <T> List<T> dropFirst(int n, List<T> list) {
        ArrayList<T> r = new ArrayList<T>(list.size() - n);
        for (int i = n; i < list.size(); ++i) {
            r.add(list.get(i));
        }
        return r;
    }

    public ResultSet executeQryForTestsOnly(String sqlToRun) throws IOException {
        try {
            ResultSet rs2 = this.executeQry(sqlToRun, 0);
            return DBHelper.toCRS(rs2);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ResultSet executeQry(String sqlToRun, int millisStalenessPermitted) throws IOException, SQLException {
        QueryTranslation qt = BabelDBJdbcDriver.translateQry(sqlToRun);
        List<List<String>> commands = qt.getCmdWithArgs();
        if (sqlToRun.equals("SYMBOLS") || sqlToRun.equalsIgnoreCase(BABEL_SYMBOL_QRY)) {
            return BabelDBJdbcDriver.getSymbolDetailsRS();
        }
        if (commands.size() == 1) {
            List<String> cmdArg = commands.get(0);
            Preconditions.checkArgument(cmdArg.size() >= 3);
            if (qt.getTranslatedQuery() == null || qt.getTranslatedQuery().equals(cmdArg.get(0))) {
                return this.run(cmdArg.get(1), BabelDBJdbcDriver.dropFirst(2, cmdArg), millisStalenessPermitted);
            }
        }
        for (int i = 0; i < commands.size(); ++i) {
            List<String> cmdArg = commands.get(i);
            ResultSet rs2 = this.run(cmdArg.get(1), BabelDBJdbcDriver.dropFirst(2, cmdArg), millisStalenessPermitted);
            this.dropCreatePopulate(rs2, cmdArg.get(0));
        }
        return this.underlyingQuery(qt.getTranslatedQuery());
    }

    private static ResultSet getSymbolDetailsRS() {
        String[] symbols = new String[SYMBOL_DETAILS.size()];
        String[] dbs = new String[SYMBOL_DETAILS.size()];
        String[] query = new String[SYMBOL_DETAILS.size()];
        String[] title = new String[SYMBOL_DETAILS.size()];
        String[] description = new String[SYMBOL_DETAILS.size()];
        for (int i = 0; i < SYMBOL_DETAILS.size(); ++i) {
            SymbolDetails sd = SYMBOL_DETAILS.get(i);
            symbols[i] = sd.symbol;
            dbs[i] = sd.database;
            query[i] = sd.query;
            title[i] = sd.title;
            description[i] = sd.description;
        }
        String[] cns = new String[]{"symbol", "database", "query", "title", "description"};
        return new SimpleResultSet(cns, new Object[]{symbols, dbs, query, title, description});
    }

    private ResultSet run(String cmd, List<String> cmdArgs, int millisStalenessPermitted) throws IOException {
        switch (cmd.toLowerCase()) {
            case "web": {
                return BabelDBJdbcDriver.fetch(Joiner.on("#").join(cmdArgs));
            }
            case "data": {
                if (cmdArgs.size() == 1) {
                    return BabelDBJdbcDriver.fromTxt(cmdArgs.get(0));
                }
                if (cmdArgs.size() == 2) {
                    return BabelDBJdbcDriver.fromTxt(cmdArgs.get(0), cmdArgs.get(1), "", false);
                }
                if (cmdArgs.size() == 3) {
                    return BabelDBJdbcDriver.fromTxt(cmdArgs.get(0), cmdArgs.get(1), cmdArgs.get(2), false);
                }
                throw new UnsupportedOperationException("query_data takes 1-3 arg");
            }
            case "sym": {
                String arg0 = cmdArgs.get(0);
                if (cmdArgs.size() != 1) {
                    throw new UnsupportedOperationException("query_sym takes 1 arg");
                }
                SymbolDetails sq = BabelDBJdbcDriver.getSymbolQuery(arg0);
                if (sq.getDatabase() != null) {
                    return this.dbrunner.executeQry(sq.getDatabase(), sq.getQueryToRun(), millisStalenessPermitted);
                }
                int p = arg0.indexOf(58);
                if (p > -1) {
                    String inferredDb = arg0.substring(p + 1).toUpperCase();
                    return this.dbrunner.executeQry(inferredDb, arg0.substring(0, p), millisStalenessPermitted);
                }
                throw new UnsupportedOperationException("Couldn't find symbol = " + arg0);
            }
            case "symbols": {
                if (cmdArgs.size() != 1) {
                    throw new UnsupportedOperationException("query_symbols takes 1 arg");
                }
                List<SymbolDetails> sl = this.searchSymbols(cmdArgs.get(0));
                return this.toRS(sl);
            }
            case "db": {
                if (cmdArgs.size() != 2 && cmdArgs.size() != 3) {
                    throw new UnsupportedOperationException("query_db takes 2 or 3 args");
                }
                if (this.dbrunner == null) {
                    throw new UnsupportedOperationException("dbrunner not configued");
                }
                String targetDB = cmdArgs.get(0);
                if (this.dbrunner.getServer(targetDB) == null) {
                    throw new UnsupportedOperationException("Database '" + targetDB + "' doesn't exist");
                }
                int millis = millisStalenessPermitted;
                if (cmdArgs.size() >= 3) {
                    millis = Integer.parseInt(cmdArgs.get(2));
                }
                return this.dbrunner.executeQry(targetDB, cmdArgs.get(1), millis);
            }
        }
        throw new UnsupportedOperationException(QRU + cmd);
    }

    public void dropCreatePopulate(ResultSet rs2, String fullTblName) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN TRANSACTION;\r\n");
        sb.append("DROP TABLE IF EXISTS " + fullTblName + ";\r\n");
        sb.append("CREATE TABLE " + fullTblName + BabelDBJdbcDriver.getCreate(rs2, this.sqlHandler));
        BabelDBJdbcDriver.appendTableInserts(sb, fullTblName, rs2, this.sqlHandler);
        sb.append("\r\nCOMMIT;");
        this.run(sb.toString());
    }

    public boolean run(String sql) throws SQLException {
        log.debug(sql);
        return this.memConn.createStatement().execute(sql);
    }

    ResultSet underlyingQuery(String sql) throws SQLException {
        Statement st2 = this.memConn.createStatement();
        log.info(sql);
        st2.execute(sql);
        ResultSet rs2 = st2.getResultSet();
        if (rs2 == null) {
            rs2 = new SimpleResultSet(new String[]{"res"}, new Object[]{new String[]{"Ran " + sql}});
        }
        return rs2;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DatabaseMetaData getDatabaseMetaData(Connection conn) {
        return new SimpleDatabaseMetaData(conn, this.getMajorVersion(), this.getMinorVersion()){

            @Override
            public ResultSet getColumns(String cat, String schema, String table, String colPattern) throws SQLException {
                return BabelDBJdbcDriver.this.memConn.getMetaData().getColumns(colPattern, cat, table, colPattern);
            }
        };
    }

    private static int appendTableInserts(StringBuilder sb, String tableName, ResultSet rs2, SqlHandler sqlHandler) throws SQLException {
        int rows = 0;
        ResultSetMetaData rsmd = rs2.getMetaData();
        int cn = rsmd.getColumnCount();
        sb.append("INSERT INTO " + tableName + " VALUES");
        while (rs2.next()) {
            if (rows > 0) {
                sb.append(",");
            }
            sb.append("(");
            for (int i = 1; i <= cn; ++i) {
                int ct = rsmd.getColumnType(i);
                Object o = null;
                switch (ct) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: {
                        String d = rs2.getString(i);
                        if (d == null || rs2.wasNull()) {
                            sb.append("NULL");
                            break;
                        }
                        sb.append("'" + d.replace("'", "''") + "'");
                        break;
                    }
                    case -5: 
                    case 16: {
                        o = rs2.getObject(i);
                        sb.append(rs2.wasNull() ? "NULL" : o);
                        break;
                    }
                    case 91: {
                        o = rs2.getObject(i);
                        if (o == null || rs2.wasNull()) {
                            sb.append("NULL");
                            break;
                        }
                        String ds = null;
                        if (o instanceof Date) {
                            ds = new SimpleDateFormat("yyyy-MM-dd").format((Date)o);
                        } else if (o instanceof java.util.Date) {
                            ds = new SimpleDateFormat("yyyy-MM-dd").format((java.util.Date)o);
                        } else if (o instanceof LocalDate) {
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            ds = formatter.format((LocalDate)o);
                        } else {
                            log.warn("Warning unsupported type = " + ct + " -> " + o);
                        }
                        sb.append(ds == null ? "NULL" : "'" + ds + "'");
                        break;
                    }
                    case 6: 
                    case 8: {
                        o = rs2.getObject(i);
                        if (rs2.wasNull() || o == null) {
                            sb.append("NULL");
                            break;
                        }
                        if (o instanceof Double) {
                            sb.append(Double.isNaN((Double)o) ? "NULL" : Double.valueOf((Double)o));
                            break;
                        }
                        if (!(o instanceof Float)) break;
                        sb.append(Float.isNaN(((Float)o).floatValue()) ? "NULL" : Float.valueOf(((Float)o).floatValue()));
                        break;
                    }
                    case -6: 
                    case -2: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        o = rs2.getObject(i);
                        sb.append(rs2.wasNull() || o == null ? "NULL" : o);
                        break;
                    }
                    case -7: {
                        sb.append((Boolean)rs2.getObject(i));
                        break;
                    }
                    case 92: {
                        sb.append(sqlHandler.getTime(rs2, i));
                        break;
                    }
                    case 93: 
                    case 2013: 
                    case 2014: {
                        o = rs2.getObject(i);
                        if (rs2.wasNull() || o == null) {
                            sb.append("NULL");
                            break;
                        }
                        String os = o.toString();
                        sb.append("'").append(sqlHandler.adaptTimestamp(os)).append("'");
                        break;
                    }
                    case 2003: {
                        o = rs2.getObject(i);
                        if (o == null || rs2.wasNull()) {
                            sb.append("NULL");
                            break;
                        }
                        if (o instanceof String) {
                            sb.append("'" + ((String)o).replace("'", "''") + "'");
                            break;
                        }
                        sb.append(sqlHandler.getArray(o));
                        break;
                    }
                    default: {
                        o = rs2.getObject(i);
                        if (!(o instanceof UUID)) {
                            log.warn("Warning unsupported type = " + ct + " -> " + o);
                        }
                        sb.append("'").append(o).append("'");
                    }
                }
                if (i == cn) continue;
                sb.append(", ");
            }
            ++rows;
            sb.append(")");
        }
        sb.append(";");
        return rows;
    }

    public static String getCreate(String[] colNames, int[] colSqlTypes, Object[] firstVals, SqlHandler sqlHandler) throws SQLException {
        int columnCount = colNames.length;
        StringBuilder sb = new StringBuilder(columnCount * 30);
        if (columnCount > 0) {
            sb.append(" ( ");
        }
        for (int i = 0; i < columnCount; ++i) {
            String typ;
            if (i > 0) {
                sb.append(", ");
            }
            String columnName = colNames[i];
            int columnType = colSqlTypes[i];
            String ct = "VARCHAR";
            ct = JDBCType.valueOf(columnType).getName();
            if (ct.equals("ARRAY") && firstVals[i] instanceof String) {
                ct = "VARCHAR";
            }
            typ = (typ = sqlHandler.map(ct, firstVals[i])) == null ? "VARCHAR" : typ;
            sb.append("\"").append(columnName).append("\"").append(" ").append(typ);
        }
        sb.append(" );");
        return sb.toString();
    }

    public static String getCreate(ResultSet rs2, SqlHandler sqlHandler) throws SQLException {
        int i;
        ResultSetMetaData rsmd = rs2.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] colNames = new String[columnCount];
        int[] colSqlTypes = new int[columnCount];
        Object[] firstVals = new Object[columnCount];
        rs2.beforeFirst();
        if (rs2.next()) {
            for (i = 1; i <= columnCount; ++i) {
                firstVals[i - 1] = rs2.getObject(i);
            }
        }
        rs2.beforeFirst();
        for (i = 1; i <= columnCount; ++i) {
            colNames[i - 1] = rsmd.getColumnLabel(i);
            colSqlTypes[i - 1] = rsmd.getColumnType(i);
        }
        return BabelDBJdbcDriver.getCreate(colNames, colSqlTypes, firstVals, sqlHandler);
    }

    public static Map<String, Integer> getColTypeMap(String columns) throws JsonMappingException, JsonProcessingException {
        JsonMapper objectMapper = JsonResultSetBuilder.getObjectMapper();
        if (!columns.isEmpty()) {
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            Map colTypeMap = objectMapper.readValue(columns, typeRef);
            HashMap<String, Integer> cTypes = new HashMap<String, Integer>();
            colTypeMap.forEach((typKey, typVal) -> {
                String t = typVal.toUpperCase();
                int typ = t.equals("DOUBLE") ? 8 : (t.equals("BOOLEAN") ? 16 : (t.equals("INTEGER") ? 4 : (t.equals("TIMESTAMP") ? 93 : 12)));
                cTypes.put((String)typKey, typ);
            });
            return cTypes;
        }
        return Collections.emptyMap();
    }

    private static int countOccurrences(String s, char c2) {
        if (s == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c2) continue;
            ++count;
        }
        return count;
    }

    private static int countOccurrences(String text, String find) {
        int index = 0;
        int count = 0;
        int length = find.length();
        while ((index = text.indexOf(find, index)) != -1) {
            index += length;
            ++count;
        }
        return count;
    }

    public static SimpleResultSet fetch(String urlWithPathOrTypes) throws IOException {
        log.info("fetch:" + urlWithPathOrTypes);
        String[] args = urlWithPathOrTypes.split("\\#");
        String url = args[0].trim();
        String path = args.length > 1 ? args[1] : "";
        String colTypeTxt = args.length > 2 ? args[2] : "";
        String urlTxt = Curler.fetchURL(url, "GET", null);
        if (urlTxt == null) {
            throw new IOException(WEBERROR);
        }
        boolean forceCSV = url.toLowerCase().contains(".csv");
        SimpleResultSet srs = BabelDBJdbcDriver.fromTxt(urlTxt, path, colTypeTxt, forceCSV);
        return srs;
    }

    public static JsonNode toJSON(String fullUrl, String method) throws IOException {
        String urlTxt = Curler.fetchURL(fullUrl, method, null);
        if (urlTxt == null) {
            throw new IOException(WEBERROR);
        }
        JsonMapper jsonMapper = JsonResultSetBuilder.getObjectMapper();
        return jsonMapper.readTree(urlTxt);
    }

    public static JsonNode toJSON(String fullUrl) throws IOException {
        return BabelDBJdbcDriver.toJSON(fullUrl, "GET");
    }

    public static SimpleResultSet fromTxt(String txt) throws IOException {
        try {
            return BabelDBJdbcDriver.fromTxt(txt, "", "", false);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public static SimpleResultSet fromTxt(String txtArg, String path, String colTypeTxt, boolean forceCSV) throws JsonMappingException, JsonProcessingException, IOException {
        String txt = txtArg.trim() + "\r\n";
        SimpleResultSet srs = null;
        Map<String, Integer> colTypes = BabelDBJdbcDriver.getColTypeMap(colTypeTxt);
        int curlies = BabelDBJdbcDriver.countOccurrences(txt, '}');
        boolean manyCommas = BabelDBJdbcDriver.countOccurrences(txt, ',') > 2 * curlies;
        int TRcount = BabelDBJdbcDriver.countOccurrences(txt, "<tr");
        if (txt.startsWith("{") || txt.startsWith("[")) {
            srs = JsonResultSetBuilder.fromJSON(txt, path);
        } else if (TRcount > 3 && txt.contains("<table")) {
            List<String[]> sa = HtmlToCsvConverter.toStringArray(txt);
            try {
                srs = BabelDBJdbcDriver.fromStringArray(sa, Collections.emptyMap(), true);
            }
            catch (CsvException | IOException e) {
                throw new IOException(e);
            }
        } else if (forceCSV || manyCommas || curlies == 0) {
            try {
                srs = BabelDBJdbcDriver.fromCSV(txt, colTypes);
            }
            catch (CsvException e) {
                throw new IOException(e);
            }
        } else {
            srs = JsonResultSetBuilder.fromJSON(txt, path);
        }
        srs = srs.castTypes(colTypes, true);
        return srs;
    }

    private static int countChar(String s, IntFunction<Boolean> f) {
        char[] ca = s.toCharArray();
        int c2 = 0;
        for (int i = 0; i < ca.length; ++i) {
            if (!f.apply(ca[i]).booleanValue()) continue;
            ++c2;
        }
        return c2;
    }

    private static char findMostPopularSeparator(String s) {
        char[] chars = new char[]{',', ';', '\t', '|'};
        int[] count = new int[4];
        char[] ca = s.toCharArray();
        boolean c2 = false;
        block6: for (int i = 0; i < ca.length; ++i) {
            switch (ca[i]) {
                case ',': {
                    count[0] = count[0] + 1;
                    continue block6;
                }
                case ';': {
                    count[1] = count[1] + 1;
                    continue block6;
                }
                case '\t': {
                    count[2] = count[2] + 1;
                    continue block6;
                }
                case '|': {
                    count[3] = count[3] + 1;
                }
            }
        }
        int maxPos = 0;
        for (int i = 1; i < count.length; ++i) {
            if (count[i] <= count[maxPos]) continue;
            maxPos = i;
        }
        return chars[maxPos];
    }

    private static SimpleResultSet fromCSV(String urlTxt, Map<String, Integer> colTypes) throws IOException, CsvException {
        int p = urlTxt.indexOf("\n");
        char sep = BabelDBJdbcDriver.findMostPopularSeparator(urlTxt);
        if (p > 0) {
            String headerTxt = urlTxt.substring(0, p);
            boolean header = true;
            int q = urlTxt.indexOf("\n", p + 1);
            if (q > 0) {
                String secondTxt = urlTxt.substring(p, q);
                double headerRatio = (double)BabelDBJdbcDriver.countChar(headerTxt, Character::isAlphabetic) / (1.0 + (double)BabelDBJdbcDriver.countChar(headerTxt, i -> i == 46));
                double secondRatio = (double)BabelDBJdbcDriver.countChar(secondTxt, Character::isAlphabetic) / (1.0 + (double)BabelDBJdbcDriver.countChar(secondTxt, i -> i == 46));
                int headerDigs = BabelDBJdbcDriver.countChar(headerTxt, Character::isDigit);
                int secondDigs = BabelDBJdbcDriver.countChar(secondTxt, Character::isDigit);
                if (Math.abs(headerRatio - secondRatio) < 0.05 && Math.abs(headerDigs - secondDigs) < 10) {
                    header = false;
                }
            }
            CSVParser csvParser = new CSVParserBuilder().withSeparator(sep).build();
            CSVReader reader = new CSVReaderBuilder(new StringReader(urlTxt)).withCSVParser(csvParser).build();
            List<String[]> csvData = reader.readAll();
            return BabelDBJdbcDriver.fromStringArray(csvData, colTypes, header);
        }
        throw new IllegalArgumentException("No newline found.");
    }

    static SimpleResultSet fromStringArray(List<String[]> csvData, Map<String, Integer> colTypes, boolean header) throws IOException, CsvException {
        HashMap<String, Integer> cTypes = new HashMap<String, Integer>();
        ArrayList<String> cNames = new ArrayList<String>();
        for (int i = 0; i < csvData.get(0).length; ++i) {
            cNames.add(header ? csvData.get(0)[i].trim() : "c" + i);
        }
        int r = 0;
        Iterator<String[]> it = csvData.iterator();
        if (header) {
            it.next();
        }
        while (it.hasNext()) {
            String[] on = it.next();
            for (int c2 = 0; c2 < cNames.size() && c2 < on.length; ++c2) {
                cTypes.merge((String)cNames.get(c2), BabelDBJdbcDriver.toSQLtype((String)on[c2]), new JsonResultSetBuilder.SqlTypeMerger());
            }
            ++r;
        }
        cTypes.putAll(colTypes);
        for (String cName : cNames) {
            cTypes.putIfAbsent(cName, 12);
        }
        JsonResultSetBuilder.SqlTypeMerger.replaceNulls(cTypes);
        int sz = csvData.size() - (header ? 1 : 0);
        Object[] colVals = SimpleResultSet.getArray(cNames.stream().map(cTypes::get).collect(Collectors.toList()), sz);
        r = 0;
        it = csvData.iterator();
        if (header) {
            it.next();
        }
        while (it.hasNext()) {
            String[] on = it.next();
            for (int c3 = 0; c3 < cNames.size() && c3 < on.length; ++c3) {
                JsonResultSetBuilder.arraySetUnlessNull(colVals[c3], r, BabelDBJdbcDriver.getValue(on[c3], (Integer)cTypes.get(cNames.get(c3))));
            }
            ++r;
        }
        return new SimpleResultSet(cNames.toArray(new String[0]), colVals);
    }

    static Integer toSQLtype(String s) {
        if (s == null || s.trim().length() == 0) {
            return 0;
        }
        if (s.equals("-") || s.equals("--") || s.equals("\u00e2\u20ac\u201c") || s.equals("\u00e2\u20ac\u201c\u00e2\u20ac\u201c")) {
            return 0;
        }
        if (BabelDBJdbcDriver.isNumeric(s) || s.equals(".")) {
            return s.contains(".") ? 8 : -5;
        }
        String S = s.toUpperCase().trim();
        if (S.equals("TRUE") || S.equals("FALSE")) {
            return 16;
        }
        if (BabelDBJdbcDriver.isISOorUkDate(S)) {
            return S.length() > 10 ? 93 : 91;
        }
        return 12;
    }

    private static boolean isNNsNNsNN(String S) {
        return S.length() >= 8 && BabelDBJdbcDriver.isN(S, 0) && BabelDBJdbcDriver.isN(S, 1) && S.charAt(2) == '/' && BabelDBJdbcDriver.isN(S, 3) && BabelDBJdbcDriver.isN(S, 4) && S.charAt(5) == '/' && BabelDBJdbcDriver.isN(S, 6) && BabelDBJdbcDriver.isN(S, 7);
    }

    private static boolean in(char needle, String listOfChars) {
        for (char c2 : listOfChars.toCharArray()) {
            if (c2 != needle) continue;
            return true;
        }
        return false;
    }

    private static boolean isUSDate(String S) {
        try {
            if (BabelDBJdbcDriver.isNNsNNsNN(S)) {
                return Integer.parseInt(S.substring(0, 1)) <= 12 && Integer.parseInt(S.substring(3, 4)) <= 31;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isUKDate(String S) {
        try {
            if (BabelDBJdbcDriver.isNNsNNsNN(S)) {
                return Integer.parseInt(S.substring(0, 2)) <= 31 && Integer.parseInt(S.substring(3, 5)) <= 12;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isISOorUkDate(String S) {
        boolean isDDslashYYYY;
        boolean isNNNN = S.length() >= 4 && BabelDBJdbcDriver.isN(S, 0) && BabelDBJdbcDriver.isN(S, 1) && BabelDBJdbcDriver.isN(S, 2) && BabelDBJdbcDriver.isN(S, 3);
        boolean isNNNNhNNhNN = S.length() >= 10 && isNNNN && S.charAt(4) == '-' && BabelDBJdbcDriver.isN(S, 5) && BabelDBJdbcDriver.isN(S, 6) && S.charAt(7) == '-' && BabelDBJdbcDriver.isN(S, 8) && BabelDBJdbcDriver.isN(S, 9);
        boolean isYYYYhMs = false;
        boolean bl = isDDslashYYYY = BabelDBJdbcDriver.isUSDate(S) && (S.length() == 8 || S.length() == 10 && BabelDBJdbcDriver.isN(S, 8) && BabelDBJdbcDriver.isN(S, 9));
        if (S.length() == 7 && isNNNN && S.charAt(4) == '-') {
            isYYYYhMs = BabelDBJdbcDriver.isN(S, 5) && BabelDBJdbcDriver.isN(S, 6) || Character.toUpperCase(S.charAt(5)) == 'Q' && BabelDBJdbcDriver.in(S.charAt(6), "1234");
        }
        boolean isYYYY = isNNNN && S.length() == 4 && S.charAt(0) == '1' || S.charAt(0) == '2';
        return S.length() >= 10 && isNNNNhNNhNN || isYYYYhMs || isYYYY || isDDslashYYYY;
    }

    private static boolean isN(String s, int i) {
        return Character.isDigit(s.charAt(i));
    }

    private static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        String s = strNum.trim().toLowerCase();
        if (s.endsWith("million")) {
            s = s.substring(0, s.length() - 7);
        }
        try {
            Double.parseDouble(s.replace(",", ""));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static <T> T castElse(Function<String, T> caster, String s, T fallbackVal) {
        try {
            return caster.apply(s);
        }
        catch (NumberFormatException numberFormatException) {
            return fallbackVal;
        }
    }

    private static DateTimeFormatter getDateTimeFormatterBuilder() {
        DateTimeFormatterBuilder dtfb = new DateTimeFormatterBuilder();
        dtfb.appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.S")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm")).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L);
        return dtfb.toFormatter();
    }

    private static String cleanNum(String num) {
        String s = num.trim().toLowerCase();
        if (s.endsWith("million") && s.length() > 7) {
            s = s.substring(0, s.length() - 7).trim() + "000000";
        }
        return s.replace(",", "");
    }

    static Object getValue(String val2, Integer sqlType) {
        String s = val2.trim();
        switch (sqlType) {
            case 8: {
                return BabelDBJdbcDriver.castElse(Double::parseDouble, BabelDBJdbcDriver.cleanNum(s), Double.NaN);
            }
            case 4: {
                return BabelDBJdbcDriver.castElse(Integer::parseInt, BabelDBJdbcDriver.cleanNum(s), null);
            }
            case -5: {
                return BabelDBJdbcDriver.castElse(Long::parseLong, BabelDBJdbcDriver.cleanNum(s), null);
            }
            case 16: {
                return BabelDBJdbcDriver.castElse(Boolean::parseBoolean, s, null);
            }
            case 93: {
                try {
                    if (s.length() > 10 && (s.charAt(10) == 'T' || s.charAt(10) == ' ')) {
                        DateTimeFormatter dtf = BabelDBJdbcDriver.getDateTimeFormatterBuilder();
                        String t = s.charAt(10) == ' ' ? s.substring(0, 10) + "T" + s.substring(11) : s;
                        t = t.endsWith("Z") ? t.substring(0, s.length() - 1) : t;
                        TemporalAccessor accessor = dtf.parse(t);
                        return Timestamp.valueOf(LocalDateTime.from(accessor));
                    }
                }
                catch (DateTimeParseException e) {
                    return null;
                }
                return null;
            }
            case 91: {
                try {
                    SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                    if (s.length() == 4) {
                        df1 = new SimpleDateFormat("yyyy");
                    } else if (s.length() == 7 && s.charAt(4) == '-') {
                        df1 = new SimpleDateFormat("yyyy-MM");
                        String yyyyh = s.substring(0, 5);
                        if (Character.toUpperCase(s.charAt(5)) == 'Q') {
                            switch (s.charAt(6)) {
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': {
                                    return df1.parse(yyyyh + "0" + s.charAt(6));
                                }
                            }
                        }
                    } else if (s.length() == 8 && BabelDBJdbcDriver.isUSDate(s)) {
                        df1 = new SimpleDateFormat("MM/dd/yy");
                    } else if (s.length() == 10 && s.charAt(2) == '/' && s.charAt(5) == '/') {
                        df1 = new SimpleDateFormat("MM/dd/yyyy");
                    }
                    return df1.parse(s);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case 12: {
                return s;
            }
        }
        return s;
    }

    private ResultSet toRS(List<SymbolDetails> sl) {
        ArrayList<Integer> colTypes = Lists.newArrayList(12, 12, 12, 12, 12);
        Object[] colVals = SimpleResultSet.getArray(colTypes, sl.size());
        for (int row = 0; row < sl.size(); ++row) {
            SymbolDetails sd = sl.get(row);
            Array.set(colVals[0], row, sd.getSymbol());
            Array.set(colVals[1], row, sd.getDatabase());
            Array.set(colVals[2], row, sd.getQueryToRun());
            Array.set(colVals[3], row, sd.getTitle());
            Array.set(colVals[4], row, sd.getDescription());
        }
        String[] colNames = new String[]{"symbol", "database", "query", "title", "description"};
        return new SimpleResultSet(colNames, colVals);
    }

    public List<SymbolDetails> searchSymbols(@Nullable String qry) {
        ArrayList<SymbolDetails> l = new ArrayList<SymbolDetails>(100);
        String Q = qry.toUpperCase();
        if (qry.length() == 0) {
            for (SymbolDetails sd : SYMBOL_DETAILS) {
                if (sd.getSymbol().length() != 1) continue;
                l.add(sd);
            }
        }
        for (SymbolDetails sd : SYMBOL_DETAILS) {
            if (!sd.getSymbol().equals(Q)) continue;
            l.add(sd);
        }
        for (SymbolDetails sd : SYMBOL_DETAILS) {
            if (l.size() > 99) break;
            if (!sd.getSymbol().startsWith(Q) || sd.getSymbol().equals(Q)) continue;
            l.add(sd);
        }
        for (SymbolDetails sd : SYMBOL_DETAILS) {
            if (l.size() > 99) break;
            if (Q.length() < 4 || !sd.getTitle().toUpperCase().contains(Q) || sd.getSymbol().equals(Q)) continue;
            l.add(sd);
        }
        return l;
    }

    public static void generateSymbolsCache() {
        Executors.newSingleThreadScheduledExecutor().execute(() -> {
            try (BabelDBJdbcDriver babel = BabelDBJdbcDriver.standardH2("", DEFAULT_DBRUNNER);){
                ArrayList<SymbolDetails> l = new ArrayList<SymbolDetails>(babel.generateSymbols());
                Collections.sort(l, (a, b) -> a.getSymbol().compareTo(b.getSymbol()));
                SYMBOL_DETAILS = new CopyOnWriteArrayList<SymbolDetails>(l);
            }
            catch (IOException | SQLException e) {
                log.error("No symbols cached." + e.getLocalizedMessage());
            }
        });
    }

    public List<SymbolDetails> generateSymbols() {
        ArrayList<SymbolDetails> s = new ArrayList<SymbolDetails>();
        if (this.dbrunner != null) {
            for (String serverName : this.dbrunner.getServerWithSymbols()) {
                String db = serverName.toUpperCase();
                int added = 0;
                try {
                    ResultSet rs2 = this.dbrunner.executeQry(db, BABEL_SYMBOL_QRY, 0);
                    List<String> colNames = DBHelper.getColumnNames(rs2.getMetaData());
                    while (rs2.next()) {
                        String title = colNames.contains("title") ? rs2.getString("title") : "";
                        String description = colNames.contains("description") ? rs2.getString("description") : "";
                        String t = title == null ? "" : title;
                        String d = description == null ? "" : description;
                        s.add(new SymbolDetails(db, rs2.getString("symbol").toUpperCase(), rs2.getString("query"), t, d));
                        ++added;
                    }
                }
                catch (Exception e) {
                    log.warn("Could not fetch symbols for:" + db + " " + e.getLocalizedMessage());
                }
                log.info("generateSymbols added " + added + " symbols from " + db);
            }
        }
        return s;
    }

    public static ResultSet toSymbolRS(List<String> symbols) {
        ArrayList<Object> colValues = new ArrayList<Object>(2);
        colValues.add(symbols.stream().map(s -> s.toUpperCase()).collect(Collectors.toList()).toArray(new String[0]));
        colValues.add(symbols.stream().map(s -> "XXX").collect(Collectors.toList()).toArray(new String[0]));
        return new SimpleResultSet(Lists.newArrayList("symbol", "query"), colValues);
    }

    private static SymbolDetails getSymbolQuery(String symbol) {
        String S = symbol.toUpperCase();
        String end = S.contains(":") ? S.substring(S.lastIndexOf(58)) : "";
        for (SymbolDetails sd : SYMBOL_DETAILS) {
            String fullSym;
            if (sd.getSymbol().equals(S)) {
                return sd;
            }
            if (end.length() <= 0 || !S.startsWith(sd.getSymbol()) || !end.equalsIgnoreCase(sd.getDatabase()) || !(fullSym = sd.getSymbol() + ":" + sd.getDatabase().toUpperCase()).equals(symbol)) continue;
            return sd;
        }
        return new SymbolDetails(null, symbol, symbol);
    }

    @Nullable
    public static SymbolDetails checkForSymbolQuery(String query) {
        String Q = query.toUpperCase().trim();
        if (Q.startsWith("QUERY_SYM(") && Q.endsWith(")")) {
            int p = Q.indexOf("(");
            List<String> symbols = ArgParser.parse(Q.substring(p)).getArgs();
            if (symbols.size() > 1) {
                throw new UnsupportedOperationException("Only 1 arg supported now");
            }
            try {
                return BabelDBJdbcDriver.getSymbolQuery(symbols.get(0));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void addToSymbols_ONLY_FOR_TESTING(List<SymbolDetails> sds) {
        SYMBOL_DETAILS.addAll(sds);
    }

    public void loadExistingParquet(File folder) throws SQLException {
        File[] files = folder.listFiles();
        ArrayList<File> dataFiles = new ArrayList<File>();
        if (files != null) {
            for (File f : files) {
                String n = f.getName().toLowerCase();
                if (!n.endsWith(".parquet") && !n.endsWith(".csv")) continue;
                dataFiles.add(f);
            }
        }
        if (dataFiles.size() > 0) {
            this.run(BabelDBJdbcDriver.getReplaceView(dataFiles));
        }
    }

    public static String getTblName(File dfile) {
        int e;
        String df = dfile.getAbsolutePath();
        int p = df.lastIndexOf(File.separator) + 1;
        if (p < 0) {
            p = 0;
        }
        if ((e = df.lastIndexOf(46)) < p) {
            e = df.length();
        }
        return df.substring(p, e).replace(" ", "_");
    }

    public static String getReplaceView(List<File> dataFiles) {
        StringBuilder sb = new StringBuilder();
        for (File dfile : dataFiles) {
            String df = dfile.getAbsolutePath();
            String name = BabelDBJdbcDriver.getTblName(dfile);
            if (df.toLowerCase().endsWith(".csv")) {
                sb.append("CREATE OR REPLACE VIEW " + name + " AS SELECT * FROM read_csv('" + df + "');\n");
                continue;
            }
            if (!df.toLowerCase().endsWith(".parquet")) continue;
            sb.append("CREATE OR REPLACE VIEW " + name + " AS SELECT * FROM read_parquet('" + df + "');\n");
        }
        return sb.toString();
    }

    public static void setDEFAULT_DBRUNNER(Dbrunner DEFAULT_DBRUNNER) {
        BabelDBJdbcDriver.DEFAULT_DBRUNNER = DEFAULT_DBRUNNER;
    }

    static {
        existingDrivers = new ConcurrentHashMap();
        try {
            DriverManager.registerDriver(new BabelDBJdbcDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        H2_PARAMS = ";CASE_INSENSITIVE_IDENTIFIERS=TRUE;TIME ZONE=UTC";
    }

    public static class SymbolDetails {
        @Nullable
        private final String database;
        @NonNull
        private final String symbol;
        @NonNull
        private final String query;
        @NonNull
        private final String title;
        @NonNull
        private final String description;

        public SymbolDetails(String database, String symbol, String query) {
            this(database, symbol, query, "", "");
        }

        public String toString() {
            return "SymD[" + this.symbol + ":" + this.database + "=" + this.query + "]";
        }

        public String getQueryToRun() {
            SymPart sp = new SymPart(this.getSymbol());
            return this.getQuery().replace("{{XXX}}", this.getSymbol()).replace("XXX", this.getSymbol()).replace("{{SYM}}", sp.getSYM()).replace("{{TYP}}", sp.getTyp());
        }

        public String getDatabase() {
            return this.database;
        }

        @NonNull
        public String getSymbol() {
            return this.symbol;
        }

        @NonNull
        public String getQuery() {
            return this.query;
        }

        @NonNull
        public String getTitle() {
            return this.title;
        }

        @NonNull
        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolDetails)) {
                return false;
            }
            SymbolDetails other = (SymbolDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$database = this.getDatabase();
            String other$database = other.getDatabase();
            if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SymbolDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $database = this.getDatabase();
            result = result * 59 + ($database == null ? 43 : $database.hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public SymbolDetails(String database, @NonNull String symbol, @NonNull String query, @NonNull String title, @NonNull String description) {
            if (symbol == null) {
                throw new NullPointerException("symbol is marked non-null but is null");
            }
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.database = database;
            this.symbol = symbol;
            this.query = query;
            this.title = title;
            this.description = description;
        }
    }

    public static class QueryTranslation {
        private final String originalQuery;
        private final String translatedQuery;
        private final List<List<String>> cmdWithArgs;

        public static QueryTranslation withOneCommand(String originalQuery, List<String> cmdWithArgs) {
            ArrayList<List<String>> ll = Lists.newArrayList();
            ll.add(cmdWithArgs);
            return new QueryTranslation(originalQuery, null, ll);
        }

        public QueryTranslation(String originalQuery, String translatedQuery, List<List<String>> cmdWithArgs) {
            this.originalQuery = originalQuery;
            this.translatedQuery = translatedQuery;
            this.cmdWithArgs = cmdWithArgs;
        }

        public String getOriginalQuery() {
            return this.originalQuery;
        }

        public String getTranslatedQuery() {
            return this.translatedQuery;
        }

        public List<List<String>> getCmdWithArgs() {
            return this.cmdWithArgs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryTranslation)) {
                return false;
            }
            QueryTranslation other = (QueryTranslation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$originalQuery = this.getOriginalQuery();
            String other$originalQuery = other.getOriginalQuery();
            if (this$originalQuery == null ? other$originalQuery != null : !this$originalQuery.equals(other$originalQuery)) {
                return false;
            }
            String this$translatedQuery = this.getTranslatedQuery();
            String other$translatedQuery = other.getTranslatedQuery();
            if (this$translatedQuery == null ? other$translatedQuery != null : !this$translatedQuery.equals(other$translatedQuery)) {
                return false;
            }
            List<List<String>> this$cmdWithArgs = this.getCmdWithArgs();
            List<List<String>> other$cmdWithArgs = other.getCmdWithArgs();
            return !(this$cmdWithArgs == null ? other$cmdWithArgs != null : !((Object)this$cmdWithArgs).equals(other$cmdWithArgs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueryTranslation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $originalQuery = this.getOriginalQuery();
            result = result * 59 + ($originalQuery == null ? 43 : $originalQuery.hashCode());
            String $translatedQuery = this.getTranslatedQuery();
            result = result * 59 + ($translatedQuery == null ? 43 : $translatedQuery.hashCode());
            List<List<String>> $cmdWithArgs = this.getCmdWithArgs();
            result = result * 59 + ($cmdWithArgs == null ? 43 : ((Object)$cmdWithArgs).hashCode());
            return result;
        }

        public String toString() {
            return "BabelDBJdbcDriver.QueryTranslation(originalQuery=" + this.getOriginalQuery() + ", translatedQuery=" + this.getTranslatedQuery() + ", cmdWithArgs=" + this.getCmdWithArgs() + ")";
        }
    }

    private static class DuckDbSqlHandler
    extends SqlHandler {
        public static final SqlHandler INSTANCE = new DuckDbSqlHandler();

        private DuckDbSqlHandler() {
        }

        @Override
        public String getTime(ResultSet rs2, int columnPosition) throws SQLException {
            Object o = rs2.getObject(columnPosition);
            if (o == null || rs2.wasNull()) {
                return "NULL";
            }
            String os = o.toString().trim();
            if (os.length() == 5 && os.charAt(2) == ':') {
                os = os + ":00";
            }
            return "'" + os + "'";
        }

        @Override
        public String getArray(Object o) throws SQLException {
            return this.toArray(o, "list_value(", ")");
        }

        @Override
        public String map(String ct, Object firstVal) {
            return ct != null && ct.equals("ARRAY") ? DuckDbSqlHandler.javaObjectToSqlTypeName(firstVal).getName() + "[]" : (firstVal instanceof UUID ? "UUID" : ct);
        }

        @Override
        public String adaptTimestamp(String timestampString) {
            String s = timestampString.replace("T", " ");
            if (s.length() == "2000-01-01T12:00".length() && s.charAt(10) == ' ' && s.charAt(13) == ':') {
                return s + ":00";
            }
            return s.replace("Z", "");
        }

        @Override
        String arrItemToString(Object obj) {
            String s = super.arrItemToString(obj);
            if (obj instanceof Float) {
                return s + "::FLOAT";
            }
            if (obj instanceof Double) {
                return s + "::DOUBLE";
            }
            return s;
        }
    }

    private static class DefaultSqlHandler
    extends SqlHandler {
        public static final SqlHandler INSTANCE = new DefaultSqlHandler();

        private DefaultSqlHandler() {
        }

        @Override
        public String getTime(ResultSet rs2, int columnPosition) throws SQLException {
            Object o = rs2.getObject(columnPosition);
            return o == null || rs2.wasNull() ? "NULL" : "'" + o.toString().replace("Z", "") + "'";
        }

        @Override
        public String getArray(Object o) throws SQLException {
            return this.toArray(o, "array[", "]");
        }

        @Override
        public String map(String ct, Object firstVal) {
            return ct != null && ct.equals("ARRAY") ? DefaultSqlHandler.javaObjectToSqlTypeName(firstVal).getName() + " ARRAY" : (firstVal instanceof UUID ? "UUID" : ct);
        }
    }

    private static abstract class SqlHandler {
        private SqlHandler() {
        }

        public abstract String getTime(ResultSet var1, int var2) throws SQLException;

        public abstract String getArray(Object var1) throws SQLException;

        String arrItemToString(Object obj) {
            if (obj == null) {
                return "NULL";
            }
            if (obj instanceof Boolean) {
                return ((Boolean)obj).toString();
            }
            String s = obj instanceof String ? (String)obj : (obj instanceof char[] ? new String((char[])obj) : obj.toString());
            return "'" + s.replace("'", "''") + "'";
        }

        String toArray(Object o, String leftSt, String rightSt) throws SQLException {
            StringBuilder sb = new StringBuilder(leftSt);
            if (o == null) {
                return null;
            }
            if (o != null && o.getClass().isArray()) {
                int n = Array.getLength(o);
                if (n > 0) {
                    sb.append(this.arrItemToString(Array.get(o, 0)));
                }
                for (int i = 1; i < n; ++i) {
                    sb.append(",").append(this.arrItemToString(Array.get(o, i)));
                }
                sb.append(rightSt);
                return sb.toString();
            }
            throw new UnsupportedOperationException("Array not recognised: " + o.toString());
        }

        abstract String map(String var1, Object var2);

        String adaptTimestamp(String timestampString) {
            return timestampString.replace("Z", "");
        }

        static JDBCType javaObjectToSqlTypeName(Object o) {
            if (o instanceof int[]) {
                return JDBCType.INTEGER;
            }
            if (o instanceof long[]) {
                return JDBCType.BIGINT;
            }
            if (o instanceof float[]) {
                return JDBCType.FLOAT;
            }
            if (o instanceof double[]) {
                return JDBCType.DOUBLE;
            }
            if (o instanceof boolean[]) {
                return JDBCType.BIT;
            }
            if (o instanceof Date[] || o instanceof java.util.Date[]) {
                return JDBCType.DATE;
            }
            return JDBCType.VARCHAR;
        }
    }
}

