/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.babeldb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgParser {
    private final String s;
    private final char[] ca;
    private int p = 0;
    List<String> l;

    private ArgParser(String argsPlusPossibleCode) {
        this.s = argsPlusPossibleCode;
        this.ca = this.s == null ? new char[]{} : this.s.toCharArray();
    }

    public static ParseResult parse(String argsPlusPossibleCode) {
        String S = argsPlusPossibleCode.toUpperCase().trim();
        if (!S.startsWith("(") || !S.contains(")")) {
            throw new IllegalArgumentException();
        }
        return new ArgParser(argsPlusPossibleCode).run();
    }

    private ParseResult run() {
        if (this.ca.length == 0) {
            return new ParseResult(Collections.emptyList(), "");
        }
        this.skipWS();
        this.swallow('(');
        this.l = new ArrayList<String>();
        this.skipWS();
        while (this.p < this.ca.length && this.ca[this.p] != ')') {
            this.acceptOneArg();
            this.skipWS();
            if (this.p >= this.ca.length || this.ca[this.p] != ',') break;
            ++this.p;
            this.skipWS();
        }
        this.swallow(')');
        String remainingCode = this.s.substring(this.p, this.s.length());
        return new ParseResult(this.l, remainingCode);
    }

    void swallow(char c2) {
        if (this.ca[this.p] == c2) {
            ++this.p;
            return;
        }
        throw new IllegalStateException("char " + c2 + " not found");
    }

    void acceptOneArg() {
        char c2 = this.ca[this.p];
        int st2 = this.p++;
        switch (c2) {
            case '\'': {
                st2 = this.p;
                this.skipUntil('\'');
                this.l.add(this.s.substring(st2, this.p));
                ++this.p;
                break;
            }
            case '\"': {
                ++this.p;
                st2 = this.p;
                this.skipUntil('\"');
                this.l.add(this.s.substring(st2, this.p));
                ++this.p;
                break;
            }
            case '(': {
                ++this.p;
                st2 = this.p;
                this.skipUntil(')');
                this.l.add(this.s.substring(st2, this.p));
                ++this.p;
                break;
            }
            case '{': {
                ++this.p;
                st2 = this.p;
                this.skipUntil('}');
                this.l.add(this.s.substring(st2, this.p));
                ++this.p;
                break;
            }
            default: {
                st2 = this.p;
                while (this.p < this.ca.length && this.ca[this.p] != ',' && this.ca[this.p] != ')') {
                    ++this.p;
                }
                this.l.add(this.s.substring(st2, this.p));
            }
        }
    }

    boolean isWS() {
        return this.p < this.ca.length && (this.ca[this.p] == '\t' || this.ca[this.p] == ' ' || this.ca[this.p] == '\r' || this.ca[this.p] == '\n');
    }

    void skipWS() {
        while (this.p < this.ca.length && this.isWS()) {
            ++this.p;
        }
    }

    void skipUntil(char end) {
        while (this.p < this.ca.length) {
            if (this.ca[this.p] == end && this.ca[this.p - 1] != '\\') {
                return;
            }
            ++this.p;
        }
        throw new IllegalStateException("Ending not found: " + end);
    }

    static boolean isStarter(char[] ca, int p) {
        int prevc = p > 0 ? ca[p] : 32;
        char c2 = ca[p];
        return (c2 == '(' || c2 == ')' || c2 == '\'' || c2 == '\"') && prevc != 92;
    }

    public static class ParseResult {
        private final List<String> args;
        private final String remainingCode;

        public ParseResult(List<String> args, String remainingCode) {
            this.args = args;
            this.remainingCode = remainingCode;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public String getRemainingCode() {
            return this.remainingCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseResult)) {
                return false;
            }
            ParseResult other = (ParseResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$args = this.getArgs();
            List<String> other$args = other.getArgs();
            if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
                return false;
            }
            String this$remainingCode = this.getRemainingCode();
            String other$remainingCode = other.getRemainingCode();
            return !(this$remainingCode == null ? other$remainingCode != null : !this$remainingCode.equals(other$remainingCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParseResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $args = this.getArgs();
            result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
            String $remainingCode = this.getRemainingCode();
            result = result * 59 + ($remainingCode == null ? 43 : $remainingCode.hashCode());
            return result;
        }

        public String toString() {
            return "ArgParser.ParseResult(args=" + this.getArgs() + ", remainingCode=" + this.getRemainingCode() + ")";
        }
    }
}

