/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Messages;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.DataReadException;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.protocol.InternalDate;
import com.mysql.cj.protocol.InternalTime;
import com.mysql.cj.protocol.InternalTimestamp;
import com.mysql.cj.result.AbstractDateTimeValueFactory;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SqlTimestampValueFactory
extends AbstractDateTimeValueFactory<Timestamp> {
    private final Calendar cal;
    private final TimeZone defaultTimeZone;
    private final Lock defaultTimeZoneLock = new ReentrantLock();
    private final TimeZone connectionTimeZone;

    public SqlTimestampValueFactory(PropertySet pset, Calendar calendar, TimeZone defaultTimeZone, TimeZone connectionTimeZone) {
        super(pset);
        this.defaultTimeZone = defaultTimeZone;
        this.connectionTimeZone = connectionTimeZone;
        this.cal = calendar != null ? (Calendar)calendar.clone() : null;
    }

    @Override
    public Timestamp localCreateFromDate(InternalDate idate) {
        if (idate.getYear() == 0 && idate.getMonth() == 0 && idate.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        this.defaultTimeZoneLock.lock();
        try {
            Calendar c2;
            if (this.cal != null) {
                c2 = this.cal;
            } else {
                c2 = Calendar.getInstance(this.defaultTimeZone, Locale.US);
                c2.setLenient(false);
            }
            try {
                c2.clear();
                c2.set(idate.getYear(), idate.getMonth() - 1, idate.getDay(), 0, 0, 0);
                Timestamp timestamp = new Timestamp(c2.getTimeInMillis());
                return timestamp;
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, e.getMessage(), e);
            }
        }
        finally {
            this.defaultTimeZoneLock.unlock();
        }
    }

    @Override
    public Timestamp localCreateFromTime(InternalTime it) {
        if (it.getHours() < 0 || it.getHours() >= 24) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidTimeValue", new Object[]{it.toString()}));
        }
        this.defaultTimeZoneLock.lock();
        try {
            Calendar c2;
            if (this.cal != null) {
                c2 = this.cal;
            } else {
                c2 = Calendar.getInstance(this.defaultTimeZone, Locale.US);
                c2.setLenient(false);
            }
            try {
                c2.set(1970, 0, 1, it.getHours(), it.getMinutes(), it.getSeconds());
                Timestamp ts = new Timestamp(c2.getTimeInMillis());
                ts.setNanos(it.getNanos());
                Timestamp timestamp = ts;
                return timestamp;
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, e.getMessage(), e);
            }
        }
        finally {
            this.defaultTimeZoneLock.unlock();
        }
    }

    @Override
    public Timestamp localCreateFromTimestamp(InternalTimestamp its) {
        if (its.getYear() == 0 && its.getMonth() == 0 && its.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        this.defaultTimeZoneLock.lock();
        try {
            Calendar c2;
            if (this.cal != null) {
                c2 = this.cal;
            } else {
                c2 = Calendar.getInstance(this.pset.getBooleanProperty(PropertyKey.preserveInstants).getValue() != false ? this.connectionTimeZone : this.defaultTimeZone, Locale.US);
                c2.setLenient(false);
            }
            try {
                c2.set(its.getYear(), its.getMonth() - 1, its.getDay(), its.getHours(), its.getMinutes(), its.getSeconds());
                Timestamp ts = new Timestamp(c2.getTimeInMillis());
                ts.setNanos(its.getNanos());
                Timestamp timestamp = ts;
                return timestamp;
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, e.getMessage(), e);
            }
        }
        finally {
            this.defaultTimeZoneLock.unlock();
        }
    }

    @Override
    public Timestamp localCreateFromDatetime(InternalTimestamp its) {
        if (its.getYear() == 0 && its.getMonth() == 0 && its.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        this.defaultTimeZoneLock.lock();
        try {
            Calendar c2;
            if (this.cal != null) {
                c2 = this.cal;
            } else {
                c2 = Calendar.getInstance(this.pset.getBooleanProperty(PropertyKey.preserveInstants).getValue() != false ? this.connectionTimeZone : this.defaultTimeZone, Locale.US);
                c2.setLenient(false);
            }
            try {
                c2.set(its.getYear(), its.getMonth() - 1, its.getDay(), its.getHours(), its.getMinutes(), its.getSeconds());
                Timestamp ts = new Timestamp(c2.getTimeInMillis());
                ts.setNanos(its.getNanos());
                Timestamp timestamp = ts;
                return timestamp;
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, e.getMessage(), e);
            }
        }
        finally {
            this.defaultTimeZoneLock.unlock();
        }
    }

    @Override
    public String getTargetTypeName() {
        return Timestamp.class.getName();
    }
}

