/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.core;

import com.github.vertical_blank.sqlformatter.core.FormatConfig;
import com.github.vertical_blank.sqlformatter.core.Indentation;
import com.github.vertical_blank.sqlformatter.core.InlineBlock;
import com.github.vertical_blank.sqlformatter.core.Params;
import com.github.vertical_blank.sqlformatter.core.Token;
import com.github.vertical_blank.sqlformatter.core.TokenTypes;
import com.github.vertical_blank.sqlformatter.core.Tokenizer;
import com.github.vertical_blank.sqlformatter.core.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Formatter {
    private final Indentation indentation;
    private final InlineBlock inlineBlock;
    private final Params params;
    private final Tokenizer tokenizer;
    private Token previousReservedWord;
    private List<Token> tokens;
    private int index;

    public Formatter(FormatConfig cfg, Tokenizer tokenizer) {
        this.indentation = new Indentation(cfg.indent);
        this.inlineBlock = new InlineBlock(cfg.maxColumnLength);
        this.params = new Params(cfg.params);
        this.tokenizer = tokenizer;
        this.previousReservedWord = null;
        this.tokens = Collections.emptyList();
        this.index = 0;
    }

    public String format(String query) {
        this.tokens = this.tokenizer.tokenize(query);
        String formattedQuery = this.getFormattedQueryFromTokens();
        return formattedQuery.trim();
    }

    private String getFormattedQueryFromTokens() {
        String formattedQuery = "";
        int _index = -1;
        for (Token token : this.tokens) {
            this.index = ++_index;
            if (token.type == TokenTypes.WHITESPACE) continue;
            if (token.type == TokenTypes.LINE_COMMENT) {
                formattedQuery = this.formatLineComment(token, formattedQuery);
                continue;
            }
            if (token.type == TokenTypes.BLOCK_COMMENT) {
                formattedQuery = this.formatBlockComment(token, formattedQuery);
                continue;
            }
            if (token.type == TokenTypes.RESERVED_TOPLEVEL) {
                formattedQuery = this.formatToplevelReservedWord(token, formattedQuery);
                this.previousReservedWord = token;
                continue;
            }
            if (token.type == TokenTypes.RESERVED_NEWLINE) {
                formattedQuery = this.formatNewlineReservedWord(token, formattedQuery);
                this.previousReservedWord = token;
                continue;
            }
            if (token.type == TokenTypes.RESERVED) {
                formattedQuery = this.formatWithSpaces(token, formattedQuery);
                this.previousReservedWord = token;
                continue;
            }
            if (token.type == TokenTypes.OPEN_PAREN) {
                formattedQuery = this.formatOpeningParentheses(token, formattedQuery);
                continue;
            }
            if (token.type == TokenTypes.CLOSE_PAREN) {
                formattedQuery = this.formatClosingParentheses(token, formattedQuery);
                continue;
            }
            if (token.type == TokenTypes.PLACEHOLDER) {
                formattedQuery = this.formatPlaceholder(token, formattedQuery);
                continue;
            }
            if (token.value.equals(",")) {
                formattedQuery = this.formatComma(token, formattedQuery);
                continue;
            }
            if (token.value.equals(":")) {
                formattedQuery = this.formatWithSpaceAfter(token, formattedQuery);
                continue;
            }
            if (token.value.equals(".")) {
                formattedQuery = this.formatWithoutSpaces(token, formattedQuery);
                continue;
            }
            if (token.value.equals(";")) {
                formattedQuery = this.formatQuerySeparator(token, formattedQuery);
                continue;
            }
            formattedQuery = this.formatWithSpaces(token, formattedQuery);
        }
        return formattedQuery;
    }

    private String formatLineComment(Token token, String query) {
        return this.addNewline(query + token.value);
    }

    private String formatBlockComment(Token token, String query) {
        return this.addNewline(this.addNewline(query) + this.indentComment(token.value));
    }

    private String indentComment(String comment) {
        return comment.replaceAll("\n", "\n" + this.indentation.getIndent());
    }

    private String formatToplevelReservedWord(Token token, String query) {
        this.indentation.decreaseTopLevel();
        query = this.addNewline(query);
        this.indentation.increaseToplevel();
        query = query + this.equalizeWhitespace(token.value);
        return this.addNewline(query);
    }

    private String formatNewlineReservedWord(Token token, String query) {
        return this.addNewline(query) + this.equalizeWhitespace(token.value) + " ";
    }

    private String equalizeWhitespace(String string) {
        return string.replaceAll("\\s+", " ");
    }

    private String formatOpeningParentheses(Token token, String query) {
        List<TokenTypes> preserveWhitespaceFor = Arrays.asList(TokenTypes.WHITESPACE, TokenTypes.OPEN_PAREN, TokenTypes.LINE_COMMENT);
        if (!this.previousToken().filter(t -> Util.nullToEmpty(preserveWhitespaceFor).contains((Object)t.type)).isPresent()) {
            query = Util.trimEnd(query);
        }
        query = query + token.value;
        this.inlineBlock.beginIfPossible(this.tokens, this.index);
        if (!this.inlineBlock.isActive()) {
            this.indentation.increaseBlockLevel();
            query = this.addNewline(query);
        }
        return query;
    }

    private String formatClosingParentheses(Token token, String query) {
        if (this.inlineBlock.isActive()) {
            this.inlineBlock.end();
            return this.formatWithSpaceAfter(token, query);
        }
        this.indentation.decreaseBlockLevel();
        return this.formatWithSpaces(token, this.addNewline(query));
    }

    private String formatPlaceholder(Token token, String query) {
        return query + this.params.get(token) + " ";
    }

    private String formatComma(Token token, String query) {
        query = this.trimTrailingWhitespace(query) + token.value + " ";
        if (this.inlineBlock.isActive()) {
            return query;
        }
        if (this.previousReservedWord != null && this.previousReservedWord.value.matches("(?i)^LIMIT$")) {
            return query;
        }
        return this.addNewline(query);
    }

    private String formatWithSpaceAfter(Token token, String query) {
        return this.trimTrailingWhitespace(query) + token.value + " ";
    }

    private String formatWithoutSpaces(Token token, String query) {
        return this.trimTrailingWhitespace(query) + token.value;
    }

    private String formatWithSpaces(Token token, String query) {
        return query + token.value + " ";
    }

    private String formatQuerySeparator(Token token, String query) {
        return this.trimTrailingWhitespace(query) + token.value + "\n";
    }

    private String addNewline(String query) {
        return Util.trimEnd(query) + "\n" + this.indentation.getIndent();
    }

    private String trimTrailingWhitespace(String query) {
        Optional<Token> token = this.previousNonWhitespaceToken();
        if (token.filter(t -> t.type == TokenTypes.LINE_COMMENT).isPresent()) {
            return Util.trimEnd(query) + "\n";
        }
        return Util.trimEnd(query);
    }

    private Optional<Token> previousNonWhitespaceToken() {
        int n = 1;
        while (this.previousToken(n).filter(t -> t.type == TokenTypes.WHITESPACE).isPresent()) {
            ++n;
        }
        return this.previousToken(n);
    }

    private Optional<Token> previousToken(int offset) {
        if (this.index - offset < 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.tokens.get(this.index - offset));
    }

    private Optional<Token> previousToken() {
        return this.previousToken(1);
    }
}

