/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FullWindowContentSupport;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class FlatPanelUI
extends BasicPanelUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    @FlatStylingSupport.Styleable
    protected int arc = -1;
    private final boolean shared;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c2) {
        return FlatUIUtils.canUseSharedUI(c2) ? FlatUIUtils.createSharedUI(FlatPanelUI.class, () -> new FlatPanelUI(true)) : new FlatPanelUI(false);
    }

    protected FlatPanelUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.addPropertyChangeListener(this);
        if (c2.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.registerPlaceholder(c2);
        }
        this.installStyle((JPanel)c2);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        c2.removePropertyChangeListener(this);
        if (c2.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.unregisterPlaceholder(c2);
        }
        this.oldStyleValues = null;
    }

    @Override
    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        if (p.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            LookAndFeel.installProperty(p, "opaque", false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JPanel c2 = (JPanel)e.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(c2)) {
                    c2.updateUI();
                } else {
                    this.installStyle(c2);
                }
                c2.revalidate();
                c2.repaint();
                break;
            }
            case "FlatLaf.fullWindowContent.buttonsPlaceholder": {
                JPanel p = (JPanel)e.getSource();
                if (e.getOldValue() != null) {
                    FullWindowContentSupport.unregisterPlaceholder(p);
                }
                if (e.getNewValue() != null) {
                    FullWindowContentSupport.registerPlaceholder(p);
                }
                LookAndFeel.installProperty(p, "opaque", e.getNewValue() == null);
            }
        }
    }

    protected void installStyle(JPanel c2) {
        try {
            this.applyStyle(c2, FlatStylingSupport.getResolvedStyle(c2, "Panel"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(JPanel c2, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(c2, (String)key, value));
    }

    protected Object applyStyleProperty(JPanel c2, String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, c2, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c2) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c2, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public void update(Graphics g, JComponent c2) {
        if (c2.isOpaque()) {
            int arc;
            int width = c2.getWidth();
            int height = c2.getHeight();
            int n = this.arc >= 0 ? this.arc : (arc = c2.getBorder() instanceof FlatLineBorder ? ((FlatLineBorder)c2.getBorder()).getArc() : 0);
            if (arc > 0) {
                FlatUIUtils.paintParentBackground(g, c2);
            }
            g.setColor(c2.getBackground());
            if (arc > 0) {
                Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g);
                FlatUIUtils.paintComponentBackground((Graphics2D)g, 0, 0, width, height, 0.0f, UIScale.scale(arc));
                FlatUIUtils.resetRenderingHints(g, oldRenderingHints);
            } else {
                g.fillRect(0, 0, width, height);
            }
        }
        this.paint(g, c2);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Object value = c2.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder");
        if (value != null) {
            return FullWindowContentSupport.getPlaceholderPreferredSize(c2, (String)value);
        }
        return super.getPreferredSize(c2);
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        if (c2.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.debugPaint(g, c2);
        }
    }
}

