/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import java.awt.Color;
import java.awt.Insets;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jdesktop.swingx.plaf.basic.CalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;

public class FlatMonthViewUI
extends BasicMonthViewUI {
    public static ComponentUI createUI(JComponent c2) {
        return new FlatMonthViewUI();
    }

    @Override
    protected CalendarRenderingHandler createRenderingHandler() {
        return new FlatRenderingHandler();
    }

    private static class FlatRenderingHandler
    extends BasicMonthViewUI.RenderingHandler {
        private final Color todayColor = UIManager.getColor("JXMonthView.todayColor");

        private FlatRenderingHandler() {
        }

        @Override
        public JComponent prepareRenderingComponent(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
            JComponent c2 = super.prepareRenderingComponent(monthView, calendar, dayState);
            int px = monthView.getBoxPaddingX();
            int py = monthView.getBoxPaddingY();
            AbstractBorder border = null;
            if (dayState == CalendarState.TITLE && monthView.isTraversable()) {
                Border b = c2.getBorder();
                if (b instanceof CompoundBorder && ((CompoundBorder)b).getInsideBorder() instanceof EmptyBorder) {
                    border = new CompoundBorder(((CompoundBorder)b).getOutsideBorder(), new FlatEmptyBorder(py * 2, 0, py * 2, 0));
                }
            } else if (dayState == CalendarState.TODAY) {
                Color lineColor = monthView.getTodayBackground();
                if (lineColor == null) {
                    lineColor = this.todayColor;
                }
                border = new FlatLineBorder(new Insets(py, px, py, px), lineColor);
            }
            if (border == null) {
                border = new FlatEmptyBorder(py, px, py, px);
            }
            c2.setBorder(border);
            return c2;
        }
    }
}

