/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.plaf.basic.BasicHyperlinkUI;

public class FlatHyperlinkUI
extends BasicHyperlinkUI {
    protected Color disabledText;

    public static ComponentUI createUI(JComponent c2) {
        return new FlatHyperlinkUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.disabledText = UIManager.getColor("Hyperlink.disabledText");
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.disabledText = null;
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        FlatButtonUI.paintText(g, b, textRect, text, b.isEnabled() ? b.getForeground() : this.disabledText);
        if (b.getModel().isRollover()) {
            this.paintUnderline(g, textRect);
        }
    }

    private void paintUnderline(Graphics g, Rectangle rect) {
        int descent = g.getFontMetrics().getDescent();
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g);
        ((Graphics2D)g).fill(new Rectangle2D.Float(rect.x, (float)(rect.y + rect.height - descent) + UIScale.scale(1.0f), rect.width, UIScale.scale(1.0f)));
        FlatUIUtils.resetRenderingHints(g, oldRenderingHints);
    }
}

