/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.ParseException;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.plaf.basic.BasicDatePickerUI;

public class FlatDatePickerUI
extends BasicDatePickerUI {
    protected Insets padding;
    protected String arrowType;
    protected Color borderColor;
    protected Color disabledBorderColor;
    protected Color disabledBackground;
    protected Color buttonBackground;
    protected Color buttonArrowColor;
    protected Color buttonDisabledArrowColor;
    protected Color buttonHoverArrowColor;
    protected Color buttonPressedArrowColor;
    private JButton popupButton;

    public static ComponentUI createUI(JComponent c2) {
        return new FlatDatePickerUI();
    }

    @Override
    public void installUI(JComponent c2) {
        this.padding = UIManager.getInsets("ComboBox.padding");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.borderColor = UIManager.getColor("Component.borderColor");
        this.disabledBorderColor = UIManager.getColor("Component.disabledBorderColor");
        this.disabledBackground = UIManager.getColor("ComboBox.disabledBackground");
        this.buttonBackground = UIManager.getColor("ComboBox.buttonBackground");
        this.buttonArrowColor = UIManager.getColor("ComboBox.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("ComboBox.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("ComboBox.buttonHoverArrowColor");
        this.buttonPressedArrowColor = UIManager.getColor("ComboBox.buttonPressedArrowColor");
        super.installUI(c2);
        LookAndFeel.installProperty(this.datePicker, "opaque", false);
        JPanel linkPanel = this.datePicker.getLinkPanel();
        if (linkPanel instanceof JXPanel && linkPanel.getClass().getName().equals("org.jdesktop.swingx.JXDatePicker$TodayPanel")) {
            ((JXPanel)linkPanel).setBackgroundPainter(null);
            linkPanel.setBackground(UIManager.getColor("JXMonthView.background"));
            if (linkPanel.getComponentCount() >= 1 && linkPanel.getComponent(0) instanceof JXHyperlink) {
                JXHyperlink todayLink = (JXHyperlink)linkPanel.getComponent(0);
                todayLink.setUnclickedColor(UIManager.getColor("Hyperlink.linkColor"));
                todayLink.setClickedColor(UIManager.getColor("Hyperlink.visitedColor"));
            }
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColors(this.datePicker, "ComboBox.background", "ComboBox.foreground");
        LookAndFeel.installBorder(this.datePicker, "JXDatePicker.border");
        LookAndFeel.installProperty(this.datePicker, "opaque", Boolean.TRUE);
        MigLayoutVisualPadding.install(this.datePicker);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.borderColor = null;
        this.disabledBorderColor = null;
        this.disabledBackground = null;
        this.buttonBackground = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        this.buttonPressedArrowColor = null;
        if (this.datePicker.getBorder() instanceof UIResource) {
            this.datePicker.setBorder(null);
        }
        MigLayoutVisualPadding.uninstall(this.datePicker);
    }

    @Override
    protected JFormattedTextField createEditor() {
        DefaultEditor editor = new DefaultEditor(new DatePickerFormatter.DatePickerFormatterUIResource(this.datePicker.getLocale()));
        editor.setName("dateField");
        editor.setBorder(BorderFactory.createEmptyBorder());
        editor.setOpaque(false);
        editor.addFocusListener(new FlatUIUtils.RepaintFocusListener(this.datePicker, null));
        return editor;
    }

    @Override
    protected JButton createPopupButton() {
        this.popupButton = new FlatArrowButton(5, this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null);
        this.popupButton.setName("popupButton");
        return this.popupButton;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return parent.getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets insets = FlatDatePickerUI.this.datePicker.getInsets();
                int x = insets.left;
                int y = insets.top;
                int width = FlatDatePickerUI.this.datePicker.getWidth() - insets.left - insets.right;
                int height = FlatDatePickerUI.this.datePicker.getHeight() - insets.top - insets.bottom;
                int popupButtonWidth = FlatDatePickerUI.this.popupButton != null ? height : 0;
                boolean ltr = FlatDatePickerUI.this.datePicker.getComponentOrientation().isLeftToRight();
                Rectangle r = new Rectangle(x + (ltr ? 0 : popupButtonWidth), y, width - popupButtonWidth, height);
                r = FlatUIUtils.subtractInsets(r, UIScale.scale(FlatDatePickerUI.this.padding));
                FlatDatePickerUI.this.datePicker.getEditor().setBounds(r);
                if (FlatDatePickerUI.this.popupButton != null) {
                    FlatDatePickerUI.this.popupButton.setBounds(x + (ltr ? width - popupButtonWidth : 0), y, popupButtonWidth, height);
                }
            }
        };
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension dim = this.datePicker.getEditor().getPreferredSize();
        dim = FlatUIUtils.addInsets(dim, UIScale.scale(this.padding));
        if (this.popupButton != null) {
            dim.width += dim.height;
        }
        return FlatUIUtils.addInsets(dim, this.datePicker.getInsets());
    }

    @Override
    public void update(Graphics g, JComponent c2) {
        if (c2.isOpaque()) {
            FlatUIUtils.paintParentBackground(g, c2);
        }
        Graphics2D g2 = (Graphics2D)g;
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
        int width = c2.getWidth();
        int height = c2.getHeight();
        float focusWidth = FlatUIUtils.getBorderFocusWidth(c2);
        float arc = FlatUIUtils.getBorderArc(c2);
        int arrowX = this.popupButton.getX();
        int arrowWidth = this.popupButton.getWidth();
        boolean enabled = c2.isEnabled();
        boolean isLeftToRight = c2.getComponentOrientation().isLeftToRight();
        g2.setColor(enabled ? c2.getBackground() : this.disabledBackground);
        FlatUIUtils.paintComponentBackground(g2, 0, 0, width, height, focusWidth, arc);
        if (enabled) {
            g2.setColor(this.buttonBackground);
            Shape oldClip = g2.getClip();
            if (isLeftToRight) {
                g2.clipRect(arrowX, 0, width - arrowX, height);
            } else {
                g2.clipRect(0, 0, arrowX + arrowWidth, height);
            }
            FlatUIUtils.paintComponentBackground(g2, 0, 0, width, height, focusWidth, arc);
            g2.setClip(oldClip);
        }
        g2.setColor(enabled ? this.borderColor : this.disabledBorderColor);
        float lw = UIScale.scale(1.0f);
        float lx = isLeftToRight ? (float)arrowX : (float)(arrowX + arrowWidth) - lw;
        g2.fill(new Rectangle2D.Float(lx, focusWidth, lw, (float)(height - 1) - focusWidth * 2.0f));
        this.paint(g, c2);
        FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
    }

    private class DefaultEditor
    extends JFormattedTextField
    implements UIResource {
        DefaultEditor(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
            this.setColumns(1);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            Calendar calendar = Calendar.getInstance(FlatDatePickerUI.this.datePicker.getLocale());
            calendar.set(2000, 11, 30);
            try {
                JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
                String str = formatter.valueToString(calendar.getTime());
                Insets insets = this.getInsets();
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                int minWidth = metrics.stringWidth(str) + insets.left + insets.right + 2;
                return new Dimension(Math.max(minWidth, prefSize.width), prefSize.height);
            }
            catch (ParseException ex) {
                return prefSize;
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

