/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.plaf.basic.BasicBusyLabelUI;

public class FlatBusyLabelUI
extends BasicBusyLabelUI {
    private Color disabledForeground;

    public static ComponentUI createUI(JComponent c2) {
        return new FlatBusyLabelUI((JXBusyLabel)c2);
    }

    public FlatBusyLabelUI(JXBusyLabel busyLabel) {
        super(busyLabel);
    }

    @Override
    protected void installDefaults(JLabel c2) {
        super.installDefaults(c2);
        this.disabledForeground = UIManager.getColor("Label.disabledForeground");
        if (c2.getIcon() != null) {
            JXBusyLabel busyLabel = (JXBusyLabel)c2;
            boolean oldBusy = busyLabel.isBusy();
            busyLabel.setBusy(false);
            busyLabel.setBusyPainter(null);
            busyLabel.setBusy(oldBusy);
        }
    }

    @Override
    protected void uninstallDefaults(JLabel c2) {
        super.uninstallDefaults(c2);
        this.disabledForeground = null;
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l.getDisplayedMnemonicIndex() : -1;
        g.setColor(this.disabledForeground);
        FlatUIUtils.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }
}

