/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MnemonicHandler
implements KeyEventPostProcessor,
ChangeListener {
    private static boolean showMnemonics;
    private static WeakReference<Window> lastShowMnemonicWindow;
    private static WindowListener windowListener;
    private static int altPressedEventCount;
    private static boolean selectMenuOnAltReleased;

    MnemonicHandler() {
    }

    static boolean isShowMnemonics() {
        return showMnemonics || !UIManager.getBoolean("Component.hideMnemonics");
    }

    void install() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this);
        MenuSelectionManager.defaultManager().addChangeListener(this);
    }

    void uninstall() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this);
        MenuSelectionManager.defaultManager().removeChangeListener(this);
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (SystemInfo.isMacOS) {
            if (keyCode == 17 || keyCode == 18) {
                MnemonicHandler.showMnemonics(this.shouldShowMnemonics(e) && e.isControlDown() && e.isAltDown(), e.getComponent());
            }
        } else {
            if (SystemInfo.isWindows) {
                return this.processKeyEventOnWindows(e);
            }
            if (keyCode == 18) {
                MnemonicHandler.showMnemonics(this.shouldShowMnemonics(e), e.getComponent());
            }
        }
        return false;
    }

    private boolean shouldShowMnemonics(KeyEvent e) {
        return e.getID() == 401 || MenuSelectionManager.defaultManager().getSelectedPath().length > 0;
    }

    private boolean processKeyEventOnWindows(KeyEvent e) {
        if (e.getKeyCode() != 18) {
            selectMenuOnAltReleased = false;
            return false;
        }
        if (e.getID() == 401) {
            if (++altPressedEventCount == 1 && !e.isConsumed()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                boolean bl = selectMenuOnAltReleased = menuSelectionManager.getSelectedPath().length == 0;
                if (!selectMenuOnAltReleased) {
                    menuSelectionManager.clearSelectedPath();
                }
            }
            MnemonicHandler.showMnemonics(this.shouldShowMnemonics(e), e.getComponent());
            e.consume();
            return true;
        }
        if (e.getID() == 402) {
            MenuSelectionManager menuSelectionManager;
            altPressedEventCount = 0;
            boolean mnemonicsShown = false;
            if (selectMenuOnAltReleased && !e.isConsumed() && (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath().length == 0) {
                JMenu firstMenu;
                JMenuBar menuBar;
                Component c2 = e.getComponent();
                JRootPane rootPane = SwingUtilities.getRootPane(c2);
                JMenuBar jMenuBar = menuBar = rootPane != null ? rootPane.getJMenuBar() : null;
                if (menuBar == null) {
                    Window window = SwingUtilities.getWindowAncestor(c2);
                    if (window instanceof JFrame) {
                        menuBar = ((JFrame)window).getJMenuBar();
                    } else if (window instanceof JDialog) {
                        menuBar = ((JDialog)window).getJMenuBar();
                    }
                }
                JMenu jMenu = firstMenu = menuBar != null ? menuBar.getMenu(0) : null;
                if (firstMenu != null) {
                    menuSelectionManager.setSelectedPath(new MenuElement[]{menuBar, firstMenu});
                    MnemonicHandler.showMnemonics(true, c2);
                    mnemonicsShown = true;
                }
            }
            selectMenuOnAltReleased = false;
            if (!mnemonicsShown) {
                MnemonicHandler.showMnemonics(this.shouldShowMnemonics(e), e.getComponent());
            }
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
        if (selectedPath.length == 0 && altPressedEventCount == 0) {
            MnemonicHandler.showMnemonics(false, null);
        }
    }

    static void showMnemonics(boolean show, Component c2) {
        if (show == showMnemonics) {
            return;
        }
        showMnemonics = show;
        if (!UIManager.getBoolean("Component.hideMnemonics")) {
            return;
        }
        if (show) {
            JRootPane rootPane = SwingUtilities.getRootPane(c2);
            if (rootPane == null) {
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(rootPane);
            if (window == null) {
                return;
            }
            MnemonicHandler.repaintMnemonics(window);
            windowListener = new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e) {
                    altPressedEventCount = 0;
                    selectMenuOnAltReleased = false;
                    EventQueue.invokeLater(() -> MnemonicHandler.showMnemonics(false, null));
                }
            };
            window.addWindowListener(windowListener);
            lastShowMnemonicWindow = new WeakReference<Window>(window);
        } else if (lastShowMnemonicWindow != null) {
            Window window = (Window)lastShowMnemonicWindow.get();
            if (window != null) {
                MnemonicHandler.repaintMnemonics(window);
                if (windowListener != null) {
                    window.removeWindowListener(windowListener);
                    windowListener = null;
                }
            }
            lastShowMnemonicWindow = null;
        }
    }

    private static void repaintMnemonics(Container container) {
        for (Component c2 : container.getComponents()) {
            if (!c2.isVisible()) continue;
            if (MnemonicHandler.hasMnemonic(c2)) {
                c2.repaint();
            }
            if (!(c2 instanceof Container)) continue;
            MnemonicHandler.repaintMnemonics((Container)c2);
        }
    }

    private static boolean hasMnemonic(Component c2) {
        if (c2 instanceof JLabel && ((JLabel)c2).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c2 instanceof AbstractButton && ((AbstractButton)c2).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c2 instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)c2;
            int tabCount = tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (tabPane.getDisplayedMnemonicIndexAt(i) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

