/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.styles;

import ch.rabanti.nanoxlsx4j.exceptions.StyleException;
import ch.rabanti.nanoxlsx4j.styles.AbstractStyle;
import ch.rabanti.nanoxlsx4j.styles.Border;
import ch.rabanti.nanoxlsx4j.styles.CellXf;
import ch.rabanti.nanoxlsx4j.styles.Fill;
import ch.rabanti.nanoxlsx4j.styles.Font;
import ch.rabanti.nanoxlsx4j.styles.NumberFormat;
import ch.rabanti.nanoxlsx4j.styles.Style;
import java.util.ArrayList;
import java.util.Collections;

public class StyleManager {
    private final ArrayList<AbstractStyle> borders = new ArrayList();
    private final ArrayList<AbstractStyle> cellXfs = new ArrayList();
    private final ArrayList<AbstractStyle> fills = new ArrayList();
    private final ArrayList<AbstractStyle> fonts = new ArrayList();
    private final ArrayList<AbstractStyle> numberFormats = new ArrayList();
    private final ArrayList<AbstractStyle> styles = new ArrayList();
    private final ArrayList<String> styleNames = new ArrayList();

    private AbstractStyle getComponentByHash(ArrayList<AbstractStyle> list, int hash) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (list.get(i).hashCode() != hash) continue;
            return list.get(i);
        }
        return null;
    }

    public Border getBorderByHash(int hash) {
        AbstractStyle component = this.getComponentByHash(this.borders, hash);
        if (component == null) {
            throw new StyleException("MissingReferenceException", "The style component with the hash '" + hash + "' was not found");
        }
        return (Border)component;
    }

    public Border[] getBorders() {
        return this.borders.toArray(new Border[this.borders.size()]);
    }

    public int getBorderStyleNumber() {
        return this.borders.size();
    }

    public CellXf getCellXfByHash(int hash) {
        AbstractStyle component = this.getComponentByHash(this.cellXfs, hash);
        if (component == null) {
            throw new StyleException("MissingReferenceException", "The style component with the hash '" + hash + "' was not found");
        }
        return (CellXf)component;
    }

    public CellXf[] getCellXfs() {
        return this.cellXfs.toArray(new CellXf[this.cellXfs.size()]);
    }

    public int getCellXfStyleNumber() {
        return this.cellXfs.size();
    }

    public Fill getFillByHash(int hash) {
        AbstractStyle component = this.getComponentByHash(this.fills, hash);
        if (component == null) {
            throw new StyleException("MissingReferenceException", "The style component with the hash '" + hash + "' was not found");
        }
        return (Fill)component;
    }

    public Fill[] getFills() {
        return this.fills.toArray(new Fill[this.fills.size()]);
    }

    public int getFillStyleNumber() {
        return this.fills.size();
    }

    public Font getFontByHash(int hash) {
        AbstractStyle component = this.getComponentByHash(this.fonts, hash);
        if (component == null) {
            throw new StyleException("MissingReferenceException", "The style component with the hash '" + hash + "' was not found");
        }
        return (Font)component;
    }

    public Font[] getFonts() {
        return this.fonts.toArray(new Font[this.fonts.size()]);
    }

    public int getFontStyleNumber() {
        return this.fonts.size();
    }

    public NumberFormat getNumberFormatByHash(int hash) {
        AbstractStyle component = this.getComponentByHash(this.numberFormats, hash);
        if (component == null) {
            throw new StyleException("MissingReferenceException", "The style component with the hash '" + hash + "' was not found");
        }
        return (NumberFormat)component;
    }

    public NumberFormat[] getNumberFormats() {
        return this.numberFormats.toArray(new NumberFormat[this.numberFormats.size()]);
    }

    public int getNumberFormatStyleNumber() {
        return this.numberFormats.size();
    }

    public Style getStyleByName(String name) {
        int len = this.styles.size();
        for (int i = 0; i < len; ++i) {
            if (!((Style)this.styles.get(i)).getName().equals(name)) continue;
            return (Style)this.styles.get(i);
        }
        throw new StyleException("MissingReferenceException", "The style with the name '" + name + "' was not found");
    }

    public Style getStyleByHash(int hash) {
        AbstractStyle component = this.getComponentByHash(this.styles, hash);
        if (component == null) {
            throw new StyleException("MissingReferenceException", "The style with the hash '" + hash + "' was not found");
        }
        return (Style)component;
    }

    public Style[] getStyles() {
        return this.styles.toArray(new Style[this.styles.size()]);
    }

    public int getStyleNumber() {
        return this.styles.size();
    }

    public Style addStyle(Style style) {
        int hash = this.addStyleComponent(style);
        return (Style)this.getComponentByHash(this.styles, hash);
    }

    private int addStyleComponent(AbstractStyle style, Integer id) {
        style.setInternalID(id);
        return this.addStyleComponent(style);
    }

    private int addStyleComponent(AbstractStyle style) {
        int hash = style.hashCode();
        if (style instanceof Border) {
            if (this.getComponentByHash(this.borders, hash) == null) {
                this.borders.add(style);
            }
            this.reorganize(this.borders);
        } else if (style instanceof CellXf) {
            if (this.getComponentByHash(this.cellXfs, hash) == null) {
                this.cellXfs.add(style);
            }
            this.reorganize(this.cellXfs);
        } else if (style instanceof Fill) {
            if (this.getComponentByHash(this.fills, hash) == null) {
                this.fills.add(style);
            }
            this.reorganize(this.fills);
        } else if (style instanceof Font) {
            if (this.getComponentByHash(this.fonts, hash) == null) {
                this.fonts.add(style);
            }
            this.reorganize(this.fonts);
        } else if (style instanceof NumberFormat) {
            if (this.getComponentByHash(this.numberFormats, hash) == null) {
                this.numberFormats.add(style);
            }
            this.reorganize(this.numberFormats);
        } else if (style instanceof Style) {
            Style s = (Style)style;
            if (this.styleNames.contains(s.getName())) {
                throw new StyleException("StyleAlreadyExistsException", "The style with the name '" + s.getName() + "' already exists");
            }
            if (this.getComponentByHash(this.styles, hash) == null) {
                Integer id;
                if (s.getInternalID() == null) {
                    id = Integer.MAX_VALUE;
                    s.setInternalID(id);
                } else {
                    id = s.getInternalID();
                }
                int temp = this.addStyleComponent(s.getBorder(), id);
                s.setBorder((Border)this.getComponentByHash(this.borders, temp));
                temp = this.addStyleComponent(s.getCellXf(), id);
                s.setCellXf((CellXf)this.getComponentByHash(this.cellXfs, temp));
                temp = this.addStyleComponent(s.getFill(), id);
                s.setFill((Fill)this.getComponentByHash(this.fills, temp));
                temp = this.addStyleComponent(s.getFont(), id);
                s.setFont((Font)this.getComponentByHash(this.fonts, temp));
                temp = this.addStyleComponent(s.getNumberFormat(), id);
                s.setNumberFormat((NumberFormat)this.getComponentByHash(this.numberFormats, temp));
                this.styles.add(s);
            }
            this.reorganize(this.styles);
            hash = s.hashCode();
        }
        return hash;
    }

    public void removeStyle(String styleName) {
        boolean match = false;
        int len = this.styles.size();
        int index = -1;
        for (int i = 0; i < len; ++i) {
            if (!((Style)this.styles.get(i)).getName().equals(styleName)) continue;
            match = true;
            index = i;
            break;
        }
        if (!match) {
            throw new StyleException("MissingReferenceException", "The style with the name '" + styleName + "' was not found in the style manager");
        }
        this.styles.remove(index);
        this.cleanupStyleComponents();
    }

    private void reorganize(ArrayList<AbstractStyle> list) {
        int len = list.size();
        Collections.sort(list);
        int id = 0;
        for (int i = 0; i < len; ++i) {
            list.get(i).setInternalID(id);
            ++id;
        }
    }

    private void cleanupStyleComponents() {
        int len;
        int i;
        for (i = len = this.borders.size(); i >= 0; --i) {
            Border border = (Border)this.borders.get(i);
            if (this.isUsedByStyle(border)) continue;
            this.borders.remove(i);
        }
        for (i = len = this.cellXfs.size(); i >= 0; --i) {
            CellXf cellXf = (CellXf)this.cellXfs.get(i);
            if (this.isUsedByStyle(cellXf)) continue;
            this.cellXfs.remove(i);
        }
        for (i = len = this.fills.size(); i >= 0; --i) {
            Fill fill = (Fill)this.fills.get(i);
            if (this.isUsedByStyle(fill)) continue;
            this.fills.remove(i);
        }
        for (i = len = this.fonts.size(); i >= 0; --i) {
            Font font = (Font)this.fonts.get(i);
            if (this.isUsedByStyle(font)) continue;
            this.fonts.remove(i);
        }
        for (i = len = this.numberFormats.size(); i >= 0; --i) {
            NumberFormat numberFormat = (NumberFormat)this.numberFormats.get(i);
            if (this.isUsedByStyle(numberFormat)) continue;
            this.numberFormats.remove(i);
        }
    }

    private boolean isUsedByStyle(AbstractStyle component) {
        boolean match = false;
        int hash = component.hashCode();
        int len = this.styles.size();
        for (int i = 0; i < len; ++i) {
            Style s = (Style)this.styles.get(i);
            if (component instanceof Border) {
                if (s.getBorder().hashCode() == hash) {
                    match = true;
                    break;
                }
            } else if (component instanceof CellXf && s.getCellXf().hashCode() == hash) {
                match = true;
                break;
            }
            if (component instanceof Fill && s.getFill().hashCode() == hash) {
                match = true;
                break;
            }
            if (component instanceof Font && s.getFont().hashCode() == hash) {
                match = true;
                break;
            }
            if (!(component instanceof NumberFormat) || s.getNumberFormat().hashCode() != hash) continue;
            match = true;
            break;
        }
        return match;
    }
}

