/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.styles;

import ch.rabanti.nanoxlsx4j.exceptions.StyleException;
import ch.rabanti.nanoxlsx4j.styles.AbstractStyle;
import ch.rabanti.nanoxlsx4j.styles.AppendAnnotation;
import ch.rabanti.nanoxlsx4j.styles.Border;
import ch.rabanti.nanoxlsx4j.styles.CellXf;
import ch.rabanti.nanoxlsx4j.styles.Fill;
import ch.rabanti.nanoxlsx4j.styles.Font;
import ch.rabanti.nanoxlsx4j.styles.NumberFormat;
import ch.rabanti.nanoxlsx4j.styles.StyleManager;

public class Style
extends AbstractStyle {
    @AppendAnnotation(nestedProperty=true)
    private Border borderRef = new Border();
    @AppendAnnotation(nestedProperty=true)
    private CellXf cellXfRef = new CellXf();
    @AppendAnnotation(nestedProperty=true)
    private Fill fillRef = new Fill();
    @AppendAnnotation(nestedProperty=true)
    private Font fontRef = new Font();
    @AppendAnnotation(nestedProperty=true)
    private NumberFormat numberFormatRef = new NumberFormat();
    @AppendAnnotation(ignore=true)
    private StyleManager styleManagerReference = null;
    @AppendAnnotation(ignore=true)
    private String name;
    @AppendAnnotation(ignore=true)
    private boolean internalStyle;
    @AppendAnnotation(ignore=true)
    private boolean styleNameDefined;

    public Border getBorder() {
        return this.borderRef;
    }

    public CellXf getCellXf() {
        return this.cellXfRef;
    }

    public Fill getFill() {
        return this.fillRef;
    }

    public Font getFont() {
        return this.fontRef;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormatRef;
    }

    public void setBorder(Border borderRef) {
        this.borderRef = borderRef;
        this.reorganizeStyle();
    }

    public void setCellXf(CellXf cellXfRef) {
        this.cellXfRef = cellXfRef;
        this.reorganizeStyle();
    }

    public void setFill(Fill fillRef) {
        this.fillRef = fillRef;
        this.reorganizeStyle();
    }

    public void setFont(Font fontRef) {
        this.fontRef = fontRef;
        this.reorganizeStyle();
    }

    public void setNumberFormat(NumberFormat numberFormatRef) {
        this.numberFormatRef = numberFormatRef;
        this.reorganizeStyle();
    }

    public void setStyleManagerReference(StyleManager styleManagerReference) {
        this.styleManagerReference = styleManagerReference;
        this.reorganizeStyle();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.styleNameDefined = true;
    }

    public boolean isInternalStyle() {
        return this.internalStyle;
    }

    public Style() {
        this.styleNameDefined = false;
        this.name = Integer.toString(this.hashCode());
    }

    public Style(String name) {
        this.styleNameDefined = false;
        this.name = name;
    }

    public Style(String name, int forcedOrder, boolean internal) {
        this.name = name;
        this.setInternalID(forcedOrder);
        this.internalStyle = internal;
        this.styleNameDefined = true;
    }

    public Style append(AbstractStyle styleToAppend) {
        if (styleToAppend instanceof Border) {
            this.getBorder().copyFields(styleToAppend, new Border());
        } else if (styleToAppend instanceof CellXf) {
            this.getCellXf().copyFields(styleToAppend, new CellXf());
        } else if (styleToAppend instanceof Fill) {
            this.getFill().copyFields(styleToAppend, new Fill());
        } else if (styleToAppend instanceof Font) {
            this.getFont().copyFields(styleToAppend, new Font());
        } else if (styleToAppend instanceof NumberFormat) {
            this.getNumberFormat().copyFields(styleToAppend, new NumberFormat());
        } else if (styleToAppend instanceof Style) {
            this.getBorder().copyFields(((Style)styleToAppend).getBorder(), new Border());
            this.getCellXf().copyFields(((Style)styleToAppend).getCellXf(), new CellXf());
            this.getFill().copyFields(((Style)styleToAppend).getFill(), new Fill());
            this.getFont().copyFields(((Style)styleToAppend).getFont(), new Font());
            this.getNumberFormat().copyFields(((Style)styleToAppend).getNumberFormat(), new NumberFormat());
        }
        return this;
    }

    private void reorganizeStyle() {
        if (this.styleManagerReference == null) {
            return;
        }
        Style newStyle = this.styleManagerReference.addStyle(this);
        this.borderRef = newStyle.getBorder();
        this.cellXfRef = newStyle.getCellXf();
        this.fillRef = newStyle.getFill();
        this.fontRef = newStyle.getFont();
        this.numberFormatRef = newStyle.getNumberFormat();
        if (!this.styleNameDefined) {
            this.name = Integer.toString(this.hashCode());
        }
    }

    public String toString() {
        return this.getInternalID() + "->" + this.hashCode();
    }

    public int hashCode() {
        if (this.borderRef == null || this.cellXfRef == null || this.fillRef == null || this.fontRef == null || this.numberFormatRef == null) {
            throw new StyleException("MissingReferenceException", "The hash of the style could not be created because one or more components are missing as references");
        }
        int p = 241;
        int r = 1;
        r *= p + this.borderRef.hashCode();
        r *= p + this.cellXfRef.hashCode();
        r *= p + this.fillRef.hashCode();
        r *= p + this.fontRef.hashCode();
        return r *= p + this.numberFormatRef.hashCode();
    }

    @Override
    public AbstractStyle copy() {
        if (this.borderRef == null || this.cellXfRef == null || this.fillRef == null || this.fontRef == null || this.numberFormatRef == null) {
            throw new StyleException("MissingReferenceException", "The style could not be copied because one or more components are missing as references");
        }
        Style copy = new Style();
        copy.setBorder(this.borderRef.copy());
        copy.setCellXf(this.cellXfRef.copy());
        copy.setFill(this.fillRef.copy());
        copy.setFont(this.fontRef.copy());
        copy.setNumberFormat(this.numberFormatRef.copy());
        return copy;
    }

    public Style copyStyle() {
        return (Style)this.copy();
    }
}

