/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.styles;

import ch.rabanti.nanoxlsx4j.styles.AbstractStyle;

public class Fill
extends AbstractStyle {
    public static final String DEFAULTCOLOR = "FF000000";
    public int indexedColor;
    public PatternValue patternFill;
    public String foregroundColor;
    public String backgroundColor;

    public static String getPatternName(PatternValue pattern) {
        String output;
        switch (pattern) {
            case none: {
                output = "none";
                break;
            }
            case solid: {
                output = "solid";
                break;
            }
            case darkGray: {
                output = "darkGray";
                break;
            }
            case mediumGray: {
                output = "mediumGray";
                break;
            }
            case lightGray: {
                output = "lightGray";
                break;
            }
            case gray0625: {
                output = "gray0625";
                break;
            }
            case gray125: {
                output = "gray125";
                break;
            }
            default: {
                output = "none";
            }
        }
        return output;
    }

    public int getIndexedColor() {
        return this.indexedColor;
    }

    public void setIndexedColor(int indexedColor) {
        this.indexedColor = indexedColor;
    }

    public PatternValue getPatternFill() {
        return this.patternFill;
    }

    public void setPatternFill(PatternValue patternFill) {
        this.patternFill = patternFill;
    }

    public String getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(String foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Fill() {
        this.indexedColor = 64;
        this.patternFill = PatternValue.none;
        this.foregroundColor = DEFAULTCOLOR;
        this.backgroundColor = DEFAULTCOLOR;
    }

    public Fill(String foreground, String background) {
        this.backgroundColor = background;
        this.foregroundColor = foreground;
        this.indexedColor = 64;
        this.patternFill = PatternValue.solid;
    }

    public Fill(String value, FillType fillType) {
        if (fillType == FillType.fillColor) {
            this.backgroundColor = value;
            this.foregroundColor = DEFAULTCOLOR;
        } else {
            this.backgroundColor = DEFAULTCOLOR;
            this.foregroundColor = value;
        }
        this.indexedColor = 64;
        this.patternFill = PatternValue.solid;
    }

    public void setColor(String value, FillType fillType) {
        if (fillType == FillType.fillColor) {
            this.foregroundColor = value;
            this.backgroundColor = DEFAULTCOLOR;
        } else {
            this.foregroundColor = DEFAULTCOLOR;
            this.backgroundColor = value;
        }
        this.patternFill = PatternValue.solid;
    }

    public String toString() {
        return "Fill:" + this.hashCode();
    }

    @Override
    public Fill copy() {
        Fill copy = new Fill();
        copy.setBackgroundColor(this.backgroundColor);
        copy.setForegroundColor(this.foregroundColor);
        copy.setIndexedColor(this.indexedColor);
        copy.setPatternFill(this.patternFill);
        return copy;
    }

    public int hashCode() {
        int p = 263;
        int r = 1;
        r *= p + this.indexedColor;
        r *= p + this.patternFill.value;
        r *= p + this.foregroundColor.hashCode();
        return r *= p + this.backgroundColor.hashCode();
    }

    public static enum FillType {
        patternColor(0),
        fillColor(1);

        private final int value;

        private FillType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum PatternValue {
        none(0),
        solid(1),
        darkGray(2),
        mediumGray(3),
        lightGray(4),
        gray0625(5),
        gray125(6);

        private final int value;

        private PatternValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

