/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.styles;

import ch.rabanti.nanoxlsx4j.exceptions.RangeException;
import ch.rabanti.nanoxlsx4j.styles.AbstractStyle;

public class CellXf
extends AbstractStyle {
    private int textRotation = 0;
    private TextDirectionValue textDirection;
    private HorizontalAlignValue horizontalAlign = HorizontalAlignValue.none;
    private VerticalAlignValue verticalAlign;
    private TextBreakValue alignment = TextBreakValue.none;
    private boolean locked;
    private boolean hidden;
    private boolean forceApplyAlignment;

    public int getTextRotation() {
        return this.textRotation;
    }

    public void setTextRotation(int textRotation) {
        this.textRotation = textRotation;
        this.textDirection = TextDirectionValue.horizontal;
        this.calculateInternalRotation();
    }

    public TextDirectionValue getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(TextDirectionValue textDirection) {
        this.textDirection = textDirection;
        this.calculateInternalRotation();
    }

    public HorizontalAlignValue getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(HorizontalAlignValue horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public VerticalAlignValue getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(VerticalAlignValue verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public TextBreakValue getAlignment() {
        return this.alignment;
    }

    public void setAlignment(TextBreakValue alignment) {
        this.alignment = alignment;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isForceApplyAlignment() {
        return this.forceApplyAlignment;
    }

    public void setForceApplyAlignment(boolean forceApplyAlignment) {
        this.forceApplyAlignment = forceApplyAlignment;
    }

    public CellXf() {
        this.textDirection = TextDirectionValue.horizontal;
        this.verticalAlign = VerticalAlignValue.none;
    }

    public int calculateInternalRotation() {
        if (this.textRotation < -90 || this.textRotation > 90) {
            throw new RangeException("RotationRangeException", "The rotation value (" + this.textRotation + "\u00b0) is out of range. Range is form -90\u00b0 to +90\u00b0");
        }
        if (this.textDirection == TextDirectionValue.vertical) {
            return 255;
        }
        if (this.textRotation >= 0) {
            return this.textRotation;
        }
        return 90 - this.textRotation;
    }

    public String toString() {
        return "StyleXF:" + this.hashCode();
    }

    @Override
    public CellXf copy() {
        CellXf copy = new CellXf();
        copy.setHorizontalAlign(this.horizontalAlign);
        copy.setAlignment(this.alignment);
        copy.setForceApplyAlignment(this.forceApplyAlignment);
        copy.setLocked(this.locked);
        copy.setHidden(this.hidden);
        try {
            copy.setTextDirection(this.textDirection);
            copy.setTextRotation(this.textRotation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        copy.setVerticalAlign(this.verticalAlign);
        return copy;
    }

    public int hashCode() {
        int p = 269;
        int r = 1;
        r *= p + this.horizontalAlign.value;
        r *= p + this.verticalAlign.value;
        r *= p + this.alignment.value;
        r *= p + this.textDirection.value;
        r *= p + this.textRotation;
        r *= p + (this.forceApplyAlignment ? 0 : 1);
        r *= p + (this.locked ? 0 : 1);
        return r *= p + (this.hidden ? 0 : 1);
    }

    public static enum TextDirectionValue {
        horizontal(0),
        vertical(1);

        private final int value;

        private TextDirectionValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TextBreakValue {
        wrapText(1),
        shrinkToFit(2),
        none(0);

        private final int value;

        private TextBreakValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum VerticalAlignValue {
        bottom(1),
        top(2),
        center(3),
        justify(4),
        distributed(5),
        none(0);

        private final int value;

        private VerticalAlignValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum HorizontalAlignValue {
        left(1),
        center(2),
        right(3),
        fill(4),
        justify(5),
        general(6),
        centerContinuous(7),
        distributed(8),
        none(0);

        private final int value;

        private HorizontalAlignValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

