/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.styles;

import ch.rabanti.nanoxlsx4j.styles.Border;
import ch.rabanti.nanoxlsx4j.styles.Fill;
import ch.rabanti.nanoxlsx4j.styles.NumberFormat;
import ch.rabanti.nanoxlsx4j.styles.Style;

public final class BasicStyles {
    private static Style bold;
    private static Style italic;
    private static Style boldItalic;
    private static Style underline;
    private static Style doubleUnderline;
    private static Style strike;
    private static Style dateFormat;
    private static Style roundFormat;
    private static Style borderFrame;
    private static Style borderFrameHeader;
    private static Style dottedFill_0_125;
    private static Style mergeCellStyle;

    public static Style Bold() {
        return BasicStyles.getStyle(StyleEnum.bold);
    }

    public static Style Italic() {
        return BasicStyles.getStyle(StyleEnum.italic);
    }

    public static Style BoldItalic() {
        return BasicStyles.getStyle(StyleEnum.boldItalic);
    }

    public static Style Underline() {
        return BasicStyles.getStyle(StyleEnum.underline);
    }

    public static Style DoubleUnderline() {
        return BasicStyles.getStyle(StyleEnum.doubleUnderline);
    }

    public static Style Strike() {
        return BasicStyles.getStyle(StyleEnum.strike);
    }

    public static Style DateFormat() {
        return BasicStyles.getStyle(StyleEnum.dateFormat);
    }

    public static Style RoundFormat() {
        return BasicStyles.getStyle(StyleEnum.roundFormat);
    }

    public static Style BorderFrame() {
        return BasicStyles.getStyle(StyleEnum.borderFrame);
    }

    public static Style BorderFrameHeader() {
        return BasicStyles.getStyle(StyleEnum.borderFrameHeader);
    }

    public static Style DottedFill_0_125() {
        return BasicStyles.getStyle(StyleEnum.dottedFill_0_125);
    }

    public static Style MergeCellStyle() {
        return BasicStyles.getStyle(StyleEnum.mergeCellStyle);
    }

    private static Style getStyle(StyleEnum value) {
        Style s = null;
        switch (value) {
            case bold: {
                if (bold == null) {
                    bold = new Style();
                    bold.getFont().setBold(true);
                }
                s = bold;
                break;
            }
            case italic: {
                if (italic == null) {
                    italic = new Style();
                    italic.getFont().setItalic(true);
                }
                s = italic;
                break;
            }
            case boldItalic: {
                if (boldItalic == null) {
                    boldItalic = new Style();
                    boldItalic.getFont().setItalic(true);
                    boldItalic.getFont().setBold(true);
                }
                s = boldItalic;
                break;
            }
            case underline: {
                if (underline == null) {
                    underline = new Style();
                    underline.getFont().setUnderline(true);
                }
                s = underline;
                break;
            }
            case doubleUnderline: {
                if (doubleUnderline == null) {
                    doubleUnderline = new Style();
                    doubleUnderline.getFont().setDoubleUnderline(true);
                }
                s = doubleUnderline;
                break;
            }
            case strike: {
                if (strike == null) {
                    strike = new Style();
                    strike.getFont().setStrike(true);
                }
                s = strike;
                break;
            }
            case dateFormat: {
                if (dateFormat == null) {
                    dateFormat = new Style();
                    dateFormat.getNumberFormat().setNumber(NumberFormat.FormatNumber.format_14);
                }
                s = dateFormat;
                break;
            }
            case roundFormat: {
                if (roundFormat == null) {
                    roundFormat = new Style();
                    roundFormat.getNumberFormat().setNumber(NumberFormat.FormatNumber.format_1);
                }
                s = roundFormat;
                break;
            }
            case borderFrame: {
                if (borderFrame == null) {
                    borderFrame = new Style();
                    borderFrame.getBorder().setTopStyle(Border.StyleValue.thin);
                    borderFrame.getBorder().setBottomStyle(Border.StyleValue.thin);
                    borderFrame.getBorder().setLeftStyle(Border.StyleValue.thin);
                    borderFrame.getBorder().setRightStyle(Border.StyleValue.thin);
                }
                s = borderFrame;
                break;
            }
            case borderFrameHeader: {
                if (borderFrameHeader == null) {
                    borderFrameHeader = new Style();
                    borderFrameHeader.getBorder().setTopStyle(Border.StyleValue.thin);
                    borderFrameHeader.getBorder().setBottomStyle(Border.StyleValue.medium);
                    borderFrameHeader.getBorder().setLeftStyle(Border.StyleValue.thin);
                    borderFrameHeader.getBorder().setRightStyle(Border.StyleValue.thin);
                    borderFrameHeader.getFont().setBold(true);
                }
                s = borderFrameHeader;
                break;
            }
            case dottedFill_0_125: {
                if (dottedFill_0_125 == null) {
                    dottedFill_0_125 = new Style();
                    dottedFill_0_125.getFill().setPatternFill(Fill.PatternValue.gray125);
                }
                s = dottedFill_0_125;
                break;
            }
            case mergeCellStyle: {
                if (mergeCellStyle == null) {
                    mergeCellStyle = new Style();
                    mergeCellStyle.getCellXf().setForceApplyAlignment(true);
                }
                s = mergeCellStyle;
                break;
            }
        }
        return s.copyStyle();
    }

    public static Style colorizedText(String rgb) {
        Style s = new Style();
        s.getFont().setColorValue("FF" + rgb.toUpperCase());
        return s;
    }

    public static Style colorizedBackground(String rgb) {
        Style s = new Style();
        s.getFill().setColor("FF" + rgb.toUpperCase(), Fill.FillType.fillColor);
        return s;
    }

    public static Style font(String fontName) {
        return BasicStyles.font(fontName, 11, false, false);
    }

    public static Style font(String fontName, int fontSize) {
        return BasicStyles.font(fontName, fontSize, false, false);
    }

    public static Style font(String fontName, int fontSize, boolean isBold) {
        return BasicStyles.font(fontName, fontSize, isBold, false);
    }

    public static Style font(String fontName, int fontSize, boolean isBold, boolean isItalic) {
        Style s = new Style();
        s.getFont().setName(fontName);
        s.getFont().setSize(fontSize);
        s.getFont().setBold(isBold);
        s.getFont().setItalic(isItalic);
        return s;
    }

    private static enum StyleEnum {
        bold,
        italic,
        boldItalic,
        underline,
        doubleUnderline,
        strike,
        dateFormat,
        roundFormat,
        borderFrame,
        borderFrameHeader,
        dottedFill_0_125,
        mergeCellStyle;

    }
}

