/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.styles;

import ch.rabanti.nanoxlsx4j.exceptions.StyleException;
import ch.rabanti.nanoxlsx4j.styles.AppendAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public abstract class AbstractStyle
implements Comparable<AbstractStyle> {
    @AppendAnnotation(ignore=true)
    private Integer internalID = null;

    public Integer getInternalID() {
        return this.internalID;
    }

    public void setInternalID(Integer internalID) {
        this.internalID = internalID;
    }

    public abstract AbstractStyle copy();

    public boolean equals(AbstractStyle other) {
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int compareTo(AbstractStyle o) {
        if (this.internalID == null) {
            return -1;
        }
        if (o.getInternalID() == null) {
            return 1;
        }
        return this.internalID.compareTo(o.getInternalID());
    }

    static void castValue(Object o, StringBuilder sb, Character delimiter) {
        if (o == null) {
            sb.append('#');
        } else if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                sb.append(1);
            } else {
                sb.append(0);
            }
        } else if (o instanceof Integer) {
            sb.append((Integer)o);
        } else if (o instanceof Double) {
            sb.append((Double)o);
        } else if (o instanceof Float) {
            sb.append(((Float)o).floatValue());
        } else if (o instanceof String) {
            if (o.toString().equals("#")) {
                sb.append("_#_");
            } else {
                sb.append((String)o);
            }
        } else if (o instanceof Long) {
            sb.append((Long)o);
        } else if (o instanceof Character) {
            sb.append(((Character)o).charValue());
        } else {
            sb.append(o);
        }
        if (delimiter != null) {
            sb.append(delimiter);
        }
    }

    <T extends AbstractStyle> void copyFields(T source, T reference) {
        if (!this.getClass().equals(source.getClass()) && !this.getClass().equals(reference.getClass())) {
            throw new StyleException("CopyFieldException", "The objects of the source, target and reference for style appending are not of the same type");
        }
        Field[] infos = this.getClass().getDeclaredFields();
        try {
            for (Field info : infos) {
                Annotation[] annotations = info.getDeclaredAnnotationsByType(AppendAnnotation.class);
                if (annotations.length > 0) {
                    boolean ignore = false;
                    for (Annotation annotation : annotations) {
                        if (!((AppendAnnotation)annotation).ignore() && !((AppendAnnotation)annotation).nestedProperty()) continue;
                        ignore = true;
                        break;
                    }
                    if (ignore) continue;
                }
                Field sourceInfo = source.getClass().getDeclaredField(info.getName());
                sourceInfo.setAccessible(true);
                Field referenceInfo = reference.getClass().getDeclaredField(info.getName());
                referenceInfo.setAccessible(true);
                if (sourceInfo.get(source).equals(referenceInfo.get(reference))) continue;
                info.setAccessible(true);
                info.set(this, sourceInfo.get(source));
            }
        }
        catch (Exception ex) {
            throw new StyleException("CopyFieldException", "The field of the source object could not be copied to the target object: " + ex.getMessage());
        }
    }
}

