/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.lowLevel;

import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.Helper;
import ch.rabanti.nanoxlsx4j.Workbook;
import ch.rabanti.nanoxlsx4j.Worksheet;
import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import ch.rabanti.nanoxlsx4j.lowLevel.SharedStringsReader;
import ch.rabanti.nanoxlsx4j.lowLevel.WorkbookReader;
import ch.rabanti.nanoxlsx4j.lowLevel.WorksheetReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class XlsxReader {
    private String filePath;
    private InputStream inputStream;
    private ByteArrayInputStream memoryStream;
    private final Map<Integer, WorksheetReader> worksheets;
    private WorkbookReader workbook;

    public XlsxReader(String path) {
        this.filePath = path;
        this.worksheets = new HashMap<Integer, WorksheetReader>();
    }

    public XlsxReader(InputStream stream) {
        this.worksheets = new HashMap<Integer, WorksheetReader>();
        this.inputStream = stream;
    }

    private InputStream getEntryStream(String name, ZipFile file) throws IOException {
        InputStream is = null;
        try {
            if (file != null) {
                ZipEntry comparison = file.getEntry(name);
                is = file.getInputStream(comparison);
            } else {
                ZipEntry comparison;
                this.memoryStream.reset();
                ZipInputStream zs = new ZipInputStream(this.memoryStream);
                while ((comparison = zs.getNextEntry()) != null) {
                    if (!comparison.getName().equals(name)) continue;
                    is = zs;
                    break;
                }
            }
            return is;
        }
        catch (Exception ex) {
            throw new IOException("LoadException", "There was an error while extracting a stream from a XLSX file. Please see the inner exception:", ex);
        }
    }

    public void read() throws IOException {
        ZipFile zf = null;
        try {
            if (this.inputStream == null || !Helper.isNullOrEmpty(this.filePath)) {
                zf = new ZipFile(this.filePath);
            } else if (this.inputStream != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int i = this.inputStream.read(buffer);
                while (i != -1) {
                    os.write(buffer, 0, i);
                    i = this.inputStream.read(buffer);
                }
                this.inputStream.close();
                this.memoryStream = new ByteArrayInputStream(os.toByteArray());
            } else {
                throw new IOException("LoadException", "No valid stream or file path was provided to open");
            }
            SharedStringsReader sharedStrings = new SharedStringsReader();
            InputStream stream = this.getEntryStream("xl/sharedStrings.xml", zf);
            sharedStrings.read(stream);
            this.workbook = new WorkbookReader();
            stream = this.getEntryStream("xl/workbook.xml", zf);
            this.workbook.read(stream);
            int worksheetIndex = 1;
            String nameTemplate = "sheet" + worksheetIndex + ".xml";
            String name = "xl/worksheets/" + nameTemplate;
            Set<Integer> keys = this.workbook.getWorksheetDefinitions().keySet();
            for (int definitionKey : keys) {
                stream = this.getEntryStream(name, zf);
                WorksheetReader wr = new WorksheetReader(sharedStrings, nameTemplate, worksheetIndex);
                wr.read(stream);
                this.worksheets.put(definitionKey, wr);
                nameTemplate = "sheet" + ++worksheetIndex + ".xml";
                name = "xl/worksheets/" + nameTemplate;
            }
        }
        catch (Exception ex) {
            throw new IOException("LoadException", "There was an error while reading an XLSX file. Please see the inner exception:", ex);
        }
        finally {
            if (this.memoryStream != null) {
                try {
                    this.memoryStream.close();
                }
                catch (java.io.IOException ex) {
                    throw new IOException("XMLStreamException", "The XML memory stream could not be closed. Please see the inner exception:", ex);
                }
            }
        }
    }

    public Workbook getWorkbook() {
        Workbook wb = new Workbook(false);
        int index = 1;
        for (Map.Entry<Integer, WorksheetReader> reader : this.worksheets.entrySet()) {
            Worksheet ws = new Worksheet(this.workbook.getWorksheetDefinitions().get(reader.getKey()), index, wb);
            for (Map.Entry<String, Cell> cell : reader.getValue().getData().entrySet()) {
                ws.addCell(cell.getValue(), cell.getKey());
            }
            wb.addWorksheet(ws);
            ++index;
        }
        return wb;
    }
}

