/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.lowLevel;

import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.Column;
import ch.rabanti.nanoxlsx4j.Helper;
import ch.rabanti.nanoxlsx4j.Metadata;
import ch.rabanti.nanoxlsx4j.Range;
import ch.rabanti.nanoxlsx4j.Workbook;
import ch.rabanti.nanoxlsx4j.Worksheet;
import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import ch.rabanti.nanoxlsx4j.exceptions.RangeException;
import ch.rabanti.nanoxlsx4j.lowLevel.Packer;
import ch.rabanti.nanoxlsx4j.lowLevel.SortedMap;
import ch.rabanti.nanoxlsx4j.styles.AbstractStyle;
import ch.rabanti.nanoxlsx4j.styles.Border;
import ch.rabanti.nanoxlsx4j.styles.CellXf;
import ch.rabanti.nanoxlsx4j.styles.Fill;
import ch.rabanti.nanoxlsx4j.styles.Font;
import ch.rabanti.nanoxlsx4j.styles.NumberFormat;
import ch.rabanti.nanoxlsx4j.styles.Style;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XlsXWriter {
    private final SortedMap sharedStrings;
    private int sharedStringsTotalCount;
    private final Workbook workbook;
    private boolean interceptDocuments;
    private HashMap<String, Document> interceptedDocuments;

    public boolean getDocumentInterception() {
        return this.interceptDocuments;
    }

    public void setDocumentInterception(boolean interceptDocuments) {
        this.interceptDocuments = interceptDocuments;
        if (interceptDocuments && this.interceptedDocuments == null) {
            this.interceptedDocuments = new HashMap();
        } else if (!interceptDocuments) {
            this.interceptedDocuments = null;
        }
    }

    public HashMap<String, Document> getInterceptedDocuments() {
        return this.interceptedDocuments;
    }

    public XlsXWriter(Workbook workbook) {
        this.workbook = workbook;
        this.sharedStrings = new SortedMap();
        this.sharedStringsTotalCount = 0;
    }

    private void appendXMLtag(StringBuilder sb, String value, String tagName, String nameSpace) {
        if (Helper.isNullOrEmpty(value)) {
            return;
        }
        if (sb == null || Helper.isNullOrEmpty(tagName)) {
            return;
        }
        boolean hasNoNs = Helper.isNullOrEmpty(nameSpace);
        sb.append('<');
        if (!hasNoNs) {
            sb.append(nameSpace);
            sb.append(':');
        }
        sb.append(tagName).append(">");
        sb.append(XlsXWriter.escapeXMLChars(value));
        sb.append("</");
        if (!hasNoNs) {
            sb.append(nameSpace);
            sb.append(':');
        }
        sb.append(tagName);
        sb.append(">");
    }

    private Document createAppPropertiesDocument() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\" xmlns:vt=\"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes\">");
        sb.append(this.createAppString());
        sb.append("</Properties>");
        return this.createXMLDocument(sb.toString(), "APPPROPERTIES");
    }

    private String createAppString() {
        if (this.workbook.getWorkbookMetadata() == null) {
            return "";
        }
        Metadata md = this.workbook.getWorkbookMetadata();
        StringBuilder sb = new StringBuilder();
        this.appendXMLtag(sb, "0", "TotalTime", null);
        this.appendXMLtag(sb, md.getApplication(), "Application", null);
        this.appendXMLtag(sb, "0", "DocSecurity", null);
        this.appendXMLtag(sb, "false", "ScaleCrop", null);
        this.appendXMLtag(sb, md.getManager(), "Manager", null);
        this.appendXMLtag(sb, md.getCompany(), "Company", null);
        this.appendXMLtag(sb, "false", "LinksUpToDate", null);
        this.appendXMLtag(sb, "false", "SharedDoc", null);
        this.appendXMLtag(sb, md.getHyperlinkBase(), "HyperlinkBase", null);
        this.appendXMLtag(sb, "false", "HyperlinksChanged", null);
        this.appendXMLtag(sb, md.getApplicationVersion(), "AppVersion", null);
        return sb.toString();
    }

    private String createColsString(Worksheet worksheet) {
        if (worksheet.getColumns().size() > 0) {
            String hidden = "";
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Integer, Column> column : worksheet.getColumns().entrySet()) {
                if (column.getValue().getWidth() == worksheet.getDefaultColumnWidth() && !column.getValue().isHidden()) continue;
                if (worksheet.getColumns().containsKey(column.getKey()) && worksheet.getColumns().get(column.getKey()).isHidden()) {
                    hidden = " hidden=\"1\"";
                }
                String col = Integer.toString(column.getKey() + 1);
                sb.append("<col customWidth=\"1\" width=\"").append(column.getValue().getWidth()).append("\" max=\"").append(col).append("\" min=\"").append(col).append("\"").append(hidden).append("/>");
            }
            String value = sb.toString();
            if (value.length() > 0) {
                return value;
            }
            return "";
        }
        return "";
    }

    private Document createCorePropertiesDocument() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<cp:coreProperties xmlns:cp=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:dcmitype=\"http://purl.org/dc/dcmitype/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        sb.append(this.createCorePropertiesString());
        sb.append("</cp:coreProperties>");
        return this.createXMLDocument(sb.toString(), "COREPROPERTIES");
    }

    private String createCorePropertiesString() {
        if (this.workbook.getWorkbookMetadata() == null) {
            return "";
        }
        Metadata md = this.workbook.getWorkbookMetadata();
        StringBuilder sb = new StringBuilder();
        this.appendXMLtag(sb, md.getTitle(), "title", "dc");
        this.appendXMLtag(sb, md.getSubject(), "subject", "dc");
        this.appendXMLtag(sb, md.getCreator(), "creator", "dc");
        this.appendXMLtag(sb, md.getCreator(), "lastModifiedBy", "cp");
        this.appendXMLtag(sb, md.getKeywords(), "keywords", "cp");
        this.appendXMLtag(sb, md.getDescription(), "description", "dc");
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
        df.setCalendar(cal);
        Date now = cal.getTime();
        String time = df.format(now);
        sb.append("<dcterms:created xsi:type=\"dcterms:W3CDTF\">").append(time).append("</dcterms:created>");
        sb.append("<dcterms:modified xsi:type=\"dcterms:W3CDTF\">").append(time).append("</dcterms:modified>");
        this.appendXMLtag(sb, md.getCategory(), "category", "cp");
        this.appendXMLtag(sb, md.getContentStatus(), "contentStatus", "cp");
        return sb.toString();
    }

    private String createMergedCellsString(Worksheet sheet) {
        if (sheet.getMergedCells().size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<mergeCells count=\"").append(sheet.getMergedCells().size()).append("\">");
        for (Map.Entry<String, Range> range : sheet.getMergedCells().entrySet()) {
            sb.append("<mergeCell ref=\"").append(range.getValue().toString()).append("\"/>");
        }
        sb.append("</mergeCells>");
        return sb.toString();
    }

    private String createMruColorsString() {
        Font[] fonts = this.workbook.getStyleManager().getFonts();
        Fill[] fills = this.workbook.getStyleManager().getFills();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tempColors = new ArrayList<String>();
        for (Font font : fonts) {
            if (Helper.isNullOrEmpty(font.getColorValue()) || font.getColorValue().equals("FF000000") || tempColors.contains(font.getColorValue())) continue;
            tempColors.add(font.getColorValue());
        }
        for (AbstractStyle abstractStyle : fills) {
            if (!(Helper.isNullOrEmpty(((Fill)abstractStyle).getBackgroundColor()) || ((Fill)abstractStyle).getBackgroundColor().equals("FF000000") || tempColors.contains(((Fill)abstractStyle).getBackgroundColor()))) {
                tempColors.add(((Fill)abstractStyle).getBackgroundColor());
            }
            if (Helper.isNullOrEmpty(((Fill)abstractStyle).getForegroundColor()) || ((Fill)abstractStyle).getForegroundColor().equals("FF000000") || tempColors.contains(((Fill)abstractStyle).getForegroundColor())) continue;
            tempColors.add(((Fill)abstractStyle).getForegroundColor());
        }
        if (tempColors.size() > 0) {
            sb.append("<mruColors>");
            for (int i = 0; i < tempColors.size(); ++i) {
                sb.append("<color rgb=\"").append((String)tempColors.get(i)).append("\"/>");
            }
            sb.append("</mruColors>");
            return sb.toString();
        }
        return "";
    }

    private String createRowString(List<Cell> columnFields, Worksheet worksheet) {
        int rowNumber = columnFields.get(0).getRowNumber();
        String height = "";
        String hidden = "";
        if (worksheet.getRowHeights().containsKey(rowNumber) && worksheet.getRowHeights().get(rowNumber).floatValue() != worksheet.getDefaultRowHeight()) {
            height = " x14ac:dyDescent=\"0.25\" customHeight=\"1\" ht=\"" + worksheet.getRowHeights().get(rowNumber) + "\"";
        }
        if (worksheet.getHiddenRows().containsKey(rowNumber) && worksheet.getHiddenRows().get(rowNumber).booleanValue()) {
            hidden = " hidden=\"1\"";
        }
        int colNum = columnFields.size();
        StringBuilder sb = new StringBuilder(43 * colNum);
        if (colNum > 0) {
            sb.append("<row r=\"");
            sb.append(rowNumber + 1);
            sb.append("\"").append(height).append(hidden).append(">");
        } else {
            sb.append("<row").append(height).append(">");
        }
        String value = "";
        int col = 0;
        for (int i = 0; i < colNum; ++i) {
            String typeAttribute;
            Cell item = columnFields.get(i);
            String tValue = " ";
            String sValue = item.getCellStyle() != null ? " s=\"" + item.getCellStyle().getInternalID() + "\" " : "";
            item.resolveCellType();
            if (item.getDataType() == Cell.CellType.BOOL) {
                typeAttribute = "b";
                tValue = " t=\"" + typeAttribute + "\" ";
                boolean bVal = (Boolean)item.getValue();
                value = bVal ? "1" : "0";
            } else if (item.getDataType() == Cell.CellType.NUMBER) {
                typeAttribute = "n";
                tValue = " t=\"" + typeAttribute + "\" ";
                Object o = item.getValue();
                if (o instanceof Byte) {
                    value = Byte.toString((Byte)item.getValue());
                } else if (o instanceof BigDecimal) {
                    value = item.getValue().toString();
                } else if (o instanceof Double) {
                    value = Double.toString((Double)item.getValue());
                } else if (o instanceof Float) {
                    value = Float.toString(((Float)item.getValue()).floatValue());
                } else if (o instanceof Integer) {
                    value = Integer.toString((Integer)item.getValue());
                } else if (o instanceof Long) {
                    value = Long.toString((Long)item.getValue());
                } else if (o instanceof Short) {
                    value = Short.toString((Short)item.getValue());
                }
            } else if (item.getDataType() == Cell.CellType.DATE) {
                typeAttribute = "d";
                Date dVal = (Date)item.getValue();
                value = Double.toString(Helper.getOADate(dVal));
            } else {
                if (item.getValue() == null) {
                    typeAttribute = "str";
                    value = "";
                } else if (item.getDataType() == Cell.CellType.FORMULA) {
                    typeAttribute = "str";
                    value = item.getValue().toString();
                } else {
                    typeAttribute = "s";
                    value = item.getValue().toString();
                    if (!this.sharedStrings.containsKey(value)) {
                        this.sharedStrings.add(value, Integer.toString(this.sharedStrings.size()));
                    }
                    value = this.sharedStrings.get(value);
                    ++this.sharedStringsTotalCount;
                }
                tValue = " t=\"" + typeAttribute + "\" ";
            }
            if (item.getDataType() != Cell.CellType.EMPTY) {
                sb.append("<c").append(tValue).append("r=\"").append(item.getCellAddress()).append("\"").append(sValue).append(">");
                if (item.getDataType() == Cell.CellType.FORMULA) {
                    sb.append("<f>").append(XlsXWriter.escapeXMLChars(item.getValue().toString())).append("</f>");
                } else {
                    sb.append("<v>").append(XlsXWriter.escapeXMLChars(value)).append("</v>");
                }
                sb.append("</c>");
            } else {
                sb.append("<c").append(tValue).append("r=\"").append(item.getCellAddress()).append("\"").append(sValue).append("/>");
            }
            ++col;
        }
        sb.append("</row>");
        return sb.toString();
    }

    private Document createSharedStringsDocument() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" count=\"");
        sb.append(this.sharedStringsTotalCount);
        sb.append("\" uniqueCount=\"");
        sb.append(this.sharedStrings.size());
        sb.append("\">");
        ArrayList<String> keys = this.sharedStrings.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            sb.append("<si><t>");
            sb.append(XlsXWriter.escapeXMLChars(keys.get(i)));
            sb.append("</t></si>");
        }
        sb.append("</sst>");
        return this.createXMLDocument(sb.toString(), "SHAREDSTRINGS");
    }

    private String createSheetProtectionString(Worksheet sheet) {
        if (!sheet.isUseSheetProtection()) {
            return "";
        }
        HashMap<Worksheet.SheetProtectionValue, Integer> actualLockingValues = new HashMap<Worksheet.SheetProtectionValue, Integer>();
        if (sheet.getSheetProtectionValues().isEmpty()) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.selectLockedCells, 1);
            actualLockingValues.put(Worksheet.SheetProtectionValue.selectUnlockedCells, 1);
        }
        if (!sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.objects)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.objects, 1);
        }
        if (!sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.scenarios)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.scenarios, 1);
        }
        if (!sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.selectLockedCells) && !actualLockingValues.containsKey((Object)Worksheet.SheetProtectionValue.selectLockedCells)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.selectLockedCells, 1);
        }
        if (!(sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.selectUnlockedCells) && sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.selectLockedCells) || actualLockingValues.containsKey((Object)Worksheet.SheetProtectionValue.selectUnlockedCells))) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.selectUnlockedCells, 1);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.formatCells)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.formatCells, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.formatColumns)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.formatColumns, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.formatRows)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.formatRows, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.insertColumns)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.insertColumns, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.insertRows)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.insertRows, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.insertHyperlinks)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.insertHyperlinks, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.deleteColumns)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.deleteColumns, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.deleteRows)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.deleteRows, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.sort)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.sort, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.autoFilter)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.autoFilter, 0);
        }
        if (sheet.getSheetProtectionValues().contains((Object)Worksheet.SheetProtectionValue.pivotTables)) {
            actualLockingValues.put(Worksheet.SheetProtectionValue.pivotTables, 0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<sheetProtection");
        for (Map.Entry item : actualLockingValues.entrySet()) {
            String temp = ((Worksheet.SheetProtectionValue)((Object)item.getKey())).name();
            sb.append(" ").append(temp).append("=\"").append(item.getValue()).append("\"");
        }
        if (!Helper.isNullOrEmpty(sheet.getSheetProtectionPassword())) {
            String hash = XlsXWriter.generatePasswordHash(sheet.getSheetProtectionPassword());
            sb.append(" password=\"").append(hash).append("\"");
        }
        sb.append(" sheet=\"1\"/>");
        return sb.toString();
    }

    private String createStyleBorderString() {
        Border[] borderStyles = this.workbook.getStyleManager().getBorders();
        StringBuilder sb = new StringBuilder();
        for (Border borderStyle : borderStyles) {
            if (borderStyle.isDiagonalDown() && !borderStyle.isDiagonalUp()) {
                sb.append("<border diagonalDown=\"1\">");
            } else if (!borderStyle.isDiagonalDown() && borderStyle.isDiagonalUp()) {
                sb.append("<border diagonalUp=\"1\">");
            } else if (borderStyle.isDiagonalDown() && borderStyle.isDiagonalUp()) {
                sb.append("<border diagonalDown=\"1\" diagonalUp=\"1\">");
            } else {
                sb.append("<border>");
            }
            if (borderStyle.getLeftStyle() != Border.StyleValue.none) {
                sb.append("<left style=\"").append(Border.getStyleName(borderStyle.getLeftStyle())).append("\">");
                if (Helper.isNullOrEmpty(borderStyle.getLeftColor())) {
                    sb.append("<color rgb=\"").append(borderStyle.getLeftColor()).append("\"/>");
                } else {
                    sb.append("<color auto=\"1\"/>");
                }
                sb.append("</left>");
            } else {
                sb.append("<left/>");
            }
            if (borderStyle.getRightStyle() != Border.StyleValue.none) {
                sb.append("<right style=\"").append(Border.getStyleName(borderStyle.getRightStyle())).append("\">");
                if (Helper.isNullOrEmpty(borderStyle.getRightColor())) {
                    sb.append("<color rgb=\"").append(borderStyle.getRightColor()).append("\"/>");
                } else {
                    sb.append("<color auto=\"1\"/>");
                }
                sb.append("</right>");
            } else {
                sb.append("<right/>");
            }
            if (borderStyle.getTopStyle() != Border.StyleValue.none) {
                sb.append("<top style=\"").append(Border.getStyleName(borderStyle.getTopStyle())).append("\">");
                if (Helper.isNullOrEmpty(borderStyle.getTopColor())) {
                    sb.append("<color rgb=\"").append(borderStyle.getTopColor()).append("\"/>");
                } else {
                    sb.append("<color auto=\"1\"/>");
                }
                sb.append("</top>");
            } else {
                sb.append("<top/>");
            }
            if (borderStyle.getBottomStyle() != Border.StyleValue.none) {
                sb.append("<bottom style=\"").append(Border.getStyleName(borderStyle.getBottomStyle())).append("\">");
                if (Helper.isNullOrEmpty(borderStyle.getBottomColor())) {
                    sb.append("<color rgb=\"").append(borderStyle.getBottomColor()).append("\"/>");
                } else {
                    sb.append("<color auto=\"1\"/>");
                }
                sb.append("</bottom>");
            } else {
                sb.append("<bottom/>");
            }
            if (borderStyle.getDiagonalStyle() != Border.StyleValue.none) {
                sb.append("<diagonal style=\"").append(Border.getStyleName(borderStyle.getDiagonalStyle())).append("\">");
                if (Helper.isNullOrEmpty(borderStyle.getDiagonalColor())) {
                    sb.append("<color rgb=\"").append(borderStyle.getDiagonalColor()).append("\"/>");
                } else {
                    sb.append("<color auto=\"1\"/>");
                }
                sb.append("</diagonal>");
            } else {
                sb.append("<diagonal/>");
            }
            sb.append("</border>");
        }
        return sb.toString();
    }

    private String createStyleFillString() {
        Fill[] fillStyles = this.workbook.getStyleManager().getFills();
        StringBuilder sb = new StringBuilder();
        for (Fill fillStyle : fillStyles) {
            sb.append("<fill>");
            sb.append("<patternFill patternType=\"").append(Fill.getPatternName(fillStyle.getPatternFill())).append("\"");
            if (fillStyle.getPatternFill() == Fill.PatternValue.solid) {
                sb.append(">");
                sb.append("<fgColor rgb=\"").append(fillStyle.getForegroundColor()).append("\"/>");
                sb.append("<bgColor indexed=\"");
                sb.append(fillStyle.getIndexedColor());
                sb.append("\"/>");
                sb.append("</patternFill>");
            } else if (fillStyle.getPatternFill() == Fill.PatternValue.mediumGray || fillStyle.getPatternFill() == Fill.PatternValue.lightGray || fillStyle.getPatternFill() == Fill.PatternValue.gray0625 || fillStyle.getPatternFill() == Fill.PatternValue.darkGray) {
                sb.append(">");
                sb.append("<fgColor rgb=\"").append(fillStyle.getForegroundColor()).append("\"/>");
                if (!Helper.isNullOrEmpty(fillStyle.getBackgroundColor())) {
                    sb.append("<bgColor rgb=\"").append(fillStyle.getBackgroundColor()).append("\"/>");
                }
                sb.append("</patternFill>");
            } else {
                sb.append("/>");
            }
            sb.append("</fill>");
        }
        return sb.toString();
    }

    private String createStyleFontString() {
        Font[] fontStyles = this.workbook.getStyleManager().getFonts();
        StringBuilder sb = new StringBuilder();
        for (Font fontStyle : fontStyles) {
            sb.append("<font>");
            if (fontStyle.isBold()) {
                sb.append("<b/>");
            }
            if (fontStyle.isItalic()) {
                sb.append("<i/>");
            }
            if (fontStyle.isUnderline()) {
                sb.append("<u/>");
            }
            if (fontStyle.isDoubleUnderline()) {
                sb.append("<u val=\"double\"/>");
            }
            if (fontStyle.isStrike()) {
                sb.append("<strike/>");
            }
            if (fontStyle.getVerticalAlign() == Font.VerticalAlignValue.subscript) {
                sb.append("<vertAlign val=\"subscript\"/>");
            } else if (fontStyle.getVerticalAlign() == Font.VerticalAlignValue.superscript) {
                sb.append("<vertAlign val=\"superscript\"/>");
            }
            sb.append("<sz val=\"");
            sb.append(fontStyle.getSize());
            sb.append("\"/>");
            if (Helper.isNullOrEmpty(fontStyle.getColorValue())) {
                sb.append("<color theme=\"");
                sb.append(fontStyle.getColorTheme());
                sb.append("\"/>");
            } else {
                sb.append("<color rgb=\"").append(fontStyle.getColorValue()).append("\"/>");
            }
            sb.append("<name val=\"").append(fontStyle.getName()).append("\"/>");
            sb.append("<family val=\"").append(fontStyle.getFamily()).append("\"/>");
            if (fontStyle.getScheme() != Font.SchemeValue.none) {
                if (fontStyle.getScheme() == Font.SchemeValue.major) {
                    sb.append("<scheme val=\"major\"/>");
                } else if (fontStyle.getScheme() == Font.SchemeValue.minor) {
                    sb.append("<scheme val=\"minor\"/>");
                }
            }
            if (!Helper.isNullOrEmpty(fontStyle.getCharset())) {
                sb.append("<charset val=\"").append(fontStyle.getCharset()).append("\"/>");
            }
            sb.append("</font>");
        }
        return sb.toString();
    }

    private String createStyleNumberFormatString() {
        NumberFormat[] numberFormatStyles = this.workbook.getStyleManager().getNumberFormats();
        StringBuilder sb = new StringBuilder();
        for (NumberFormat numberFormatStyle : numberFormatStyles) {
            if (!numberFormatStyle.isCustomFormat()) continue;
            sb.append("<numFmt formatCode=\"").append(numberFormatStyle.getCustomFormatCode()).append("\" numFmtId=\"");
            sb.append(numberFormatStyle.getCustomFormatID());
            sb.append("\"/>");
        }
        return sb.toString();
    }

    private Document createStyleSheetDocument() throws IOException {
        String bordersString = this.createStyleBorderString();
        String fillsString = this.createStyleFillString();
        String fontsString = this.createStyleFontString();
        String numberFormatsString = this.createStyleNumberFormatString();
        int numFormatCount = this.getNumberFormatStringCounter();
        String xfsStings = this.createStyleXfsString();
        String mruColorString = this.createMruColorsString();
        StringBuilder sb = new StringBuilder();
        sb.append("<styleSheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" mc:Ignorable=\"x14ac\" xmlns:x14ac=\"http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac\">");
        if (numFormatCount > 0) {
            sb.append("<numFmts count=\"");
            sb.append(numFormatCount);
            sb.append("\">");
            sb.append(numberFormatsString).append("</numFmts>");
        }
        sb.append("<fonts x14ac:knownFonts=\"1\" count=\"");
        sb.append(this.workbook.getStyleManager().getFontStyleNumber());
        sb.append("\">");
        sb.append(fontsString).append("</fonts>");
        sb.append("<fills count=\"");
        sb.append(this.workbook.getStyleManager().getFillStyleNumber());
        sb.append("\">");
        sb.append(fillsString).append("</fills>");
        sb.append("<borders count=\"");
        sb.append(this.workbook.getStyleManager().getBorderStyleNumber());
        sb.append("\">");
        sb.append(bordersString).append("</borders>");
        sb.append("<cellXfs count=\"");
        sb.append(this.workbook.getStyleManager().getStyleNumber());
        sb.append("\">");
        sb.append(xfsStings).append("</cellXfs>");
        if (this.workbook.getWorkbookMetadata() != null && !Helper.isNullOrEmpty(mruColorString) && this.workbook.getWorkbookMetadata().isUseColorMRU()) {
            sb.append("<colors>");
            sb.append(mruColorString);
            sb.append("</colors>");
        }
        sb.append("</styleSheet>");
        return this.createXMLDocument(sb.toString(), "STYLESHEET");
    }

    private String createStyleXfsString() {
        Style[] styles = this.workbook.getStyleManager().getStyles();
        StringBuilder sb = new StringBuilder();
        for (Style style : styles) {
            int textRotation = style.getCellXf().calculateInternalRotation();
            String alignmentString = "";
            String protectionString = "";
            if (style.getCellXf().getHorizontalAlign() != CellXf.HorizontalAlignValue.none || style.getCellXf().getVerticalAlign() != CellXf.VerticalAlignValue.none || style.getCellXf().getAlignment() != CellXf.TextBreakValue.none || textRotation != 0) {
                StringBuilder sb2 = new StringBuilder();
                sb2.append("<alignment");
                if (style.getCellXf().getHorizontalAlign() != CellXf.HorizontalAlignValue.none) {
                    sb2.append(" horizontal=\"");
                    if (style.getCellXf().getHorizontalAlign() == CellXf.HorizontalAlignValue.center) {
                        sb2.append("center");
                    } else if (style.getCellXf().getHorizontalAlign() == CellXf.HorizontalAlignValue.right) {
                        sb2.append("right");
                    } else if (style.getCellXf().getHorizontalAlign() == CellXf.HorizontalAlignValue.centerContinuous) {
                        sb2.append("centerContinuous");
                    } else if (style.getCellXf().getHorizontalAlign() == CellXf.HorizontalAlignValue.distributed) {
                        sb2.append("distributed");
                    } else if (style.getCellXf().getHorizontalAlign() == CellXf.HorizontalAlignValue.fill) {
                        sb2.append("fill");
                    } else if (style.getCellXf().getHorizontalAlign() == CellXf.HorizontalAlignValue.general) {
                        sb2.append("general");
                    } else if (style.getCellXf().getHorizontalAlign() == CellXf.HorizontalAlignValue.justify) {
                        sb2.append("justify");
                    } else {
                        sb2.append("left");
                    }
                    sb2.append("\"");
                }
                if (style.getCellXf().getVerticalAlign() != CellXf.VerticalAlignValue.none) {
                    sb2.append(" vertical=\"");
                    if (style.getCellXf().getVerticalAlign() == CellXf.VerticalAlignValue.center) {
                        sb2.append("center");
                    } else if (style.getCellXf().getVerticalAlign() == CellXf.VerticalAlignValue.distributed) {
                        sb2.append("distributed");
                    } else if (style.getCellXf().getVerticalAlign() == CellXf.VerticalAlignValue.justify) {
                        sb2.append("justify");
                    } else if (style.getCellXf().getVerticalAlign() == CellXf.VerticalAlignValue.top) {
                        sb2.append("top");
                    } else {
                        sb2.append("bottom");
                    }
                    sb2.append("\"");
                }
                if (style.getCellXf().getAlignment() != CellXf.TextBreakValue.none) {
                    if (style.getCellXf().getAlignment() == CellXf.TextBreakValue.shrinkToFit) {
                        sb2.append(" shrinkToFit=\"1");
                    } else {
                        sb2.append(" wrapText=\"1");
                    }
                    sb2.append("\"");
                }
                if (textRotation != 0) {
                    sb2.append(" textRotation=\"");
                    sb2.append(textRotation);
                    sb2.append("\"");
                }
                sb2.append("/>");
                alignmentString = sb2.toString();
            }
            if (style.getCellXf().isHidden() || style.getCellXf().isLocked()) {
                protectionString = style.getCellXf().isHidden() && style.getCellXf().isLocked() ? "<protection locked=\"1\" hidden=\"1\"/>" : (style.getCellXf().isHidden() && !style.getCellXf().isLocked() ? "<protection hidden=\"1\" locked=\"0\"/>" : "<protection hidden=\"0\" locked=\"1\"/>");
            }
            sb.append("<xf numFmtId=\"");
            if (style.getNumberFormat().isCustomFormat()) {
                sb.append(style.getNumberFormat().getCustomFormatID());
            } else {
                int formatNumber = style.getNumberFormat().getNumber().getValue();
                sb.append(formatNumber);
            }
            sb.append("\" borderId=\"");
            sb.append(style.getBorder().getInternalID());
            sb.append("\" fillId=\"");
            sb.append(style.getFill().getInternalID());
            sb.append("\" fontId=\"");
            sb.append(style.getFont().getInternalID());
            if (!style.getFont().isDefaultFont()) {
                sb.append("\" applyFont=\"1");
            }
            if (style.getFill().getPatternFill() != Fill.PatternValue.none) {
                sb.append("\" applyFill=\"1");
            }
            if (!style.getBorder().isEmpty()) {
                sb.append("\" applyBorder=\"1");
            }
            if (!alignmentString.isEmpty() || style.getCellXf().isForceApplyAlignment()) {
                sb.append("\" applyAlignment=\"1");
            }
            if (!protectionString.isEmpty()) {
                sb.append("\" applyProtection=\"1");
            }
            if (style.getNumberFormat().getNumber() != NumberFormat.FormatNumber.none) {
                sb.append("\" applyNumberFormat=\"1\"");
            } else {
                sb.append("\"");
            }
            if (!alignmentString.isEmpty() || !protectionString.isEmpty()) {
                sb.append(">");
                sb.append(alignmentString);
                sb.append(protectionString);
                sb.append("</xf>");
                continue;
            }
            sb.append("/>");
        }
        return sb.toString();
    }

    private Document createWorkbookDocument() throws IOException {
        if (this.workbook.getWorksheets().isEmpty()) {
            throw new RangeException("UnknownRangeException", "The workbook can not be created because no worksheet was defined.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
        if (this.workbook.getSelectedWorksheet() > 0) {
            sb.append("<bookViews><workbookView activeTab=\"");
            sb.append(this.workbook.getSelectedWorksheet());
            sb.append("\"/></bookViews>");
        }
        if (this.workbook.isWorkbookProtectionUsed()) {
            sb.append("<workbookProtection");
            if (this.workbook.isWindowsLockedIfProtected()) {
                sb.append(" lockWindows=\"1\"");
            }
            if (this.workbook.isStructureLockedIfProtected()) {
                sb.append(" lockStructure=\"1\"");
            }
            if (!Helper.isNullOrEmpty(this.workbook.getWorkbookProtectionPassword())) {
                sb.append("workbookPassword=\"");
                sb.append(XlsXWriter.generatePasswordHash(this.workbook.getWorkbookProtectionPassword()));
                sb.append("\"");
            }
            sb.append("/>");
        }
        sb.append("<sheets>");
        for (int i = 0; i < this.workbook.getWorksheets().size(); ++i) {
            int id = this.workbook.getWorksheets().get(i).getSheetID();
            sb.append("<sheet r:id=\"rId");
            sb.append(id);
            sb.append("\" sheetId=\"");
            sb.append(id);
            sb.append("\" name=\"").append(XlsXWriter.escapeXMLAttributeChars(this.workbook.getWorksheets().get(i).getSheetName())).append("\"/>");
        }
        sb.append("</sheets>");
        sb.append("</workbook>");
        return this.createXMLDocument(sb.toString(), "WORKBOOK");
    }

    private Document createWorksheetPart(Worksheet worksheet) throws IOException {
        worksheet.recalculateAutoFilter();
        worksheet.recalculateColumns();
        List<List<Cell>> celldata = this.getSortedSheetData(worksheet);
        StringBuilder sb = new StringBuilder();
        sb.append("<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" mc:Ignorable=\"x14ac\" xmlns:x14ac=\"http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac\">");
        if (worksheet.getSelectedCells() != null) {
            sb.append("<sheetViews><sheetView workbookViewId=\"0\"");
            if (this.workbook.getSelectedWorksheet() == worksheet.getSheetID() - 1) {
                sb.append(" tabSelected=\"1\"");
            }
            sb.append("><selection sqref=\"");
            sb.append(worksheet.getSelectedCells().toString());
            sb.append("\" activeCell=\"");
            sb.append(worksheet.getSelectedCells().StartAddress.toString());
            sb.append("\"/></sheetView></sheetViews>");
        }
        sb.append("<sheetFormatPr x14ac:dyDescent=\"0.25\" defaultRowHeight=\"");
        sb.append(worksheet.getDefaultRowHeight());
        sb.append("\" baseColWidth=\"");
        sb.append(worksheet.getDefaultColumnWidth());
        sb.append("\"/>");
        String colWidths = this.createColsString(worksheet);
        if (!Helper.isNullOrEmpty(colWidths)) {
            sb.append("<cols>");
            sb.append(colWidths);
            sb.append("</cols>");
        }
        sb.append("<sheetData>");
        for (int i = 0; i < celldata.size(); ++i) {
            String line = this.createRowString(celldata.get(i), worksheet);
            sb.append(line);
        }
        sb.append("</sheetData>");
        sb.append(this.createMergedCellsString(worksheet));
        sb.append(this.createSheetProtectionString(worksheet));
        if (worksheet.getAutoFilterRange() != null) {
            sb.append("<autoFilter ref=\"").append(worksheet.getAutoFilterRange().toString()).append("\"/>");
        }
        sb.append("</worksheet>");
        return this.createXMLDocument(sb.toString(), "WORKSHEET: " + worksheet.getSheetName());
    }

    public Document createXMLDocument(String rawInput, String title) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            InputSource input = new InputSource(new StringReader(rawInput));
            input.setEncoding("UTF-8");
            Document doc = docBuilder.parse(input);
            doc.setXmlVersion("1.0");
            doc.setXmlStandalone(true);
            if (this.interceptDocuments) {
                this.interceptedDocuments.put(title, doc);
                System.out.println("DEBUG: Document '" + title + "' was intercepted");
            }
            return doc;
        }
        catch (Exception e) {
            throw new IOException("XmlDocumentException", "There was an error while creating the XML document. Please see the inner exception.", e);
        }
    }

    private int getNumberFormatStringCounter() {
        NumberFormat[] numberFormatStyles = this.workbook.getStyleManager().getNumberFormats();
        int counter = 0;
        for (NumberFormat numberFormatStyle : numberFormatStyles) {
            if (!numberFormatStyle.isCustomFormat()) continue;
            ++counter;
        }
        return counter;
    }

    private List<List<Cell>> getSortedSheetData(Worksheet sheet) {
        ArrayList<Cell> temp = new ArrayList<Cell>();
        for (Map.Entry<String, Cell> entry : sheet.getCells().entrySet()) {
            temp.add(entry.getValue());
        }
        Collections.sort(temp);
        ArrayList line = new ArrayList();
        ArrayList<List<Cell>> output = new ArrayList<List<Cell>>();
        if (temp.size() > 0) {
            int rowNumber = ((Cell)temp.get(0)).getRowNumber();
            for (int i = 0; i < temp.size(); ++i) {
                if (((Cell)temp.get(i)).getRowNumber() != rowNumber) {
                    output.add(line);
                    line = new ArrayList();
                    rowNumber = ((Cell)temp.get(i)).getRowNumber();
                }
                line.add(temp.get(i));
            }
            if (line.size() > 0) {
                output.add(line);
            }
        }
        return output;
    }

    public void save() throws IOException {
        try {
            FileOutputStream dest = new FileOutputStream(this.workbook.getFilename());
            this.saveAsStream(dest);
        }
        catch (Exception e) {
            throw new IOException("SaveException", "There was an error while creating the workbook document during saving to a file. Please see the inner exception:" + e.getMessage(), e);
        }
    }

    public void saveAsStream(OutputStream stream) throws IOException {
        try {
            this.workbook.resolveMergedCells();
            Document app = this.createAppPropertiesDocument();
            Document core = this.createCorePropertiesDocument();
            Document styles = this.createStyleSheetDocument();
            Document book = this.createWorkbookDocument();
            Packer p = new Packer(this);
            Packer.Relationship rel = p.createRelationship("_rels/.rels");
            rel.addRelationshipEntry("/xl/workbook.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            rel.addRelationshipEntry("/docProps/core.xml", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
            rel.addRelationshipEntry("/docProps/app.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
            rel = p.createRelationship("xl/_rels/workbook.xml.rels");
            for (int i = 0; i < this.workbook.getWorksheets().size(); ++i) {
                Worksheet sheet = this.workbook.getWorksheets().get(i);
                Document doc = this.createWorksheetPart(sheet);
                String file = "sheet" + sheet.getSheetID() + ".xml";
                rel.addRelationshipEntry("/xl/worksheets/" + file, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet");
                p.addPart("xl/worksheets/" + file, "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", doc);
            }
            rel.addRelationshipEntry("/xl/styles.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles");
            rel.addRelationshipEntry("/xl/sharedStrings.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings");
            p.addPart("docProps/core.xml", "application/vnd.openxmlformats-package.core-properties+xml", core);
            p.addPart("docProps/app.xml", "application/vnd.openxmlformats-officedocument.extended-properties+xml", app);
            p.addPart("xl/sharedStrings.xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", this.createSharedStringsDocument());
            p.addPart("xl/workbook.xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", book, false);
            p.addPart("xl/styles.xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", styles);
            p.pack(stream);
        }
        catch (Exception e) {
            throw new IOException("SaveException", "There was an error while creating the workbook document during writing to a stream. Please see the inner exception:" + e.getMessage(), e);
        }
    }

    public static byte[] createBytesFromDocument(Document document) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            StreamResult output = new StreamResult(bs);
            DOMSource input = new DOMSource(document);
            transformer.transform(input, output);
            bs.flush();
            byte[] bytes = bs.toByteArray();
            bs.close();
            return bytes;
        }
        catch (Exception e) {
            throw new IOException("ByteSteamException", "There was an error while creating the byte array. Please see the inner exception.", e);
        }
    }

    private static String escapeXMLAttributeChars(String input) {
        input = XlsXWriter.escapeXMLChars(input);
        input = input.replace("\"", "&quot;");
        return input;
    }

    private static String escapeXMLChars(String input) {
        int i;
        int len = input.length();
        ArrayList<Integer> illegalCharacters = new ArrayList<Integer>(len);
        ArrayList<Integer> characterTypes = new ArrayList<Integer>(len);
        for (i = 0; i < len; ++i) {
            char c2 = input.charAt(i);
            if (c2 < '\t' || c2 > '\n' && c2 < '\r' || c2 > '\r' && c2 < ' ' || c2 > '\ud7ff' && c2 < '\ue000' || c2 > '\ufffd') {
                illegalCharacters.add(i);
                characterTypes.add(0);
                continue;
            }
            if (c2 == '<') {
                illegalCharacters.add(i);
                characterTypes.add(1);
                continue;
            }
            if (c2 == '>') {
                illegalCharacters.add(i);
                characterTypes.add(2);
                continue;
            }
            if (c2 != '&') continue;
            illegalCharacters.add(i);
            characterTypes.add(3);
        }
        if (illegalCharacters.isEmpty()) {
            return input;
        }
        StringBuilder sb = new StringBuilder(len);
        int lastIndex = 0;
        len = illegalCharacters.size();
        for (i = 0; i < len; ++i) {
            int j = (Integer)illegalCharacters.get(i);
            int type = (Integer)characterTypes.get(i);
            sb.append(input, lastIndex, j);
            if (type == 0) {
                sb.append(' ');
            } else if (type == 1) {
                sb.append("&lt;");
            } else if (type == 2) {
                sb.append("&gt;");
            } else if (type == 3) {
                sb.append("&amp;");
            }
            lastIndex = j + 1;
        }
        sb.append(input.substring(lastIndex));
        return sb.toString();
    }

    private static String generatePasswordHash(String password) {
        if (Helper.isNullOrEmpty(password)) {
            return "";
        }
        int passwordLength = password.length();
        int passwordHash = 0;
        for (int i = passwordLength; i > 0; --i) {
            char character = password.charAt(i - 1);
            passwordHash = passwordHash >> 14 & 1 | passwordHash << 1 & Short.MAX_VALUE;
            passwordHash ^= character;
        }
        passwordHash = passwordHash >> 14 & 1 | passwordHash << 1 & Short.MAX_VALUE;
        passwordHash ^= 0xCE4B;
        return Integer.toHexString(passwordHash ^= passwordLength).toUpperCase();
    }
}

