/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.lowLevel;

import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.Helper;
import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import ch.rabanti.nanoxlsx4j.lowLevel.SharedStringsReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class WorksheetReader {
    private int worksheetNumber;
    private final String name;
    private final Map<String, Cell> data = new HashMap<String, Cell>();
    private final SharedStringsReader sharedStrings;

    public String getName() {
        return this.name;
    }

    public int getWorksheetNumber() {
        return this.worksheetNumber;
    }

    public void setWorksheetNumber(int worksheetNumber) {
        this.worksheetNumber = worksheetNumber;
    }

    public Map<String, Cell> getData() {
        return this.data;
    }

    public WorksheetReader(SharedStringsReader sharedStrings, String name, int number) {
        this.name = name;
        this.worksheetNumber = number;
        this.sharedStrings = sharedStrings;
    }

    public boolean hasColumn(String columnAddress) {
        if (Helper.isNullOrEmpty(columnAddress)) {
            return false;
        }
        int columnNumber = Cell.resolveColumn(columnAddress);
        for (Map.Entry<String, Cell> cell : this.data.entrySet()) {
            if (cell.getValue().getColumnNumber() != columnNumber) continue;
            return true;
        }
        return false;
    }

    public boolean rowHasColumns(List<Cell> cells, int[] columnNumbers) {
        if (columnNumbers == null || cells == null) {
            return false;
        }
        int len = columnNumbers.length;
        int len2 = cells.size();
        if (len < 1 || len2 < 1) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            boolean match = false;
            for (int j = 0; j < len2; ++j) {
                if (cells.get(j).getColumnNumber() != columnNumbers[i]) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public int getRowCount() {
        int count = -1;
        for (Map.Entry<String, Cell> cell : this.data.entrySet()) {
            if (cell.getValue().getRowNumber() <= count) continue;
            count = cell.getValue().getRowNumber();
        }
        return count + 1;
    }

    public List<Cell> getRow(int rowNumber) {
        ArrayList<Cell> list = new ArrayList<Cell>();
        for (Map.Entry<String, Cell> cell : this.data.entrySet()) {
            if (cell.getValue().getRowNumber() != rowNumber) continue;
            list.add(cell.getValue());
        }
        list.sort((c1, c2) -> Integer.compare(c1.getColumnNumber(), c2.getColumnNumber()));
        return list;
    }

    public void read(InputStream stream) throws IOException {
        this.data.clear();
        boolean isSheetData = false;
        boolean isCell = false;
        boolean isCellValue = false;
        boolean isFormula = false;
        String value = "";
        String formula = null;
        String type = "s";
        String style = "";
        String address = "A1";
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try {
            XMLStreamReader xr = factory.createXMLStreamReader(stream);
            while (xr.hasNext()) {
                String name;
                int nodeType = xr.next();
                if (nodeType == 1) {
                    name = xr.getName().getLocalPart().toLowerCase();
                    if (name.equals("sheetdata")) {
                        isSheetData = true;
                        continue;
                    }
                    if (name.equals("c") && isSheetData) {
                        address = xr.getAttributeValue(null, "r");
                        type = xr.getAttributeValue(null, "t");
                        style = xr.getAttributeValue(null, "s");
                        isCell = true;
                        continue;
                    }
                    if (name.equals("f") && isCell) {
                        isFormula = true;
                        continue;
                    }
                    if (!name.equals("v") || !isCell) continue;
                    isCellValue = true;
                    continue;
                }
                if (nodeType == 4) {
                    if (isFormula) {
                        formula = xr.getText();
                        isFormula = false;
                        continue;
                    }
                    if (!isCellValue) continue;
                    value = xr.getText();
                    isCellValue = false;
                    continue;
                }
                if (nodeType != 2) continue;
                name = xr.getName().getLocalPart().toLowerCase();
                if (name.equals("c") && isCell) {
                    isCell = false;
                    isCellValue = false;
                    isFormula = false;
                    this.resolveCellData(address, type, value, style, formula);
                    formula = null;
                    value = "";
                    continue;
                }
                if (!name.equals("sheetdata") || !isSheetData) continue;
                isSheetData = false;
            }
        }
        catch (Exception ex) {
            throw new IOException("XMLStreamException", "The XML entry could not be read from the input stream. Please see the inner exception:", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (java.io.IOException ex) {
                    throw new IOException("XMLStreamException", "The XML entry stream could not be closed. Please see the inner exception:", ex);
                }
            }
        }
    }

    private void resolveCellData(String address, String type, String value, String style, String formula) {
        String s;
        CellResolverTuple tuple;
        address = address.toUpperCase();
        Cell cell = style != null && style.equals("1") ? ((tuple = WorksheetReader.getDateValue(value)).isValid() ? new Cell(tuple.getData(), Cell.CellType.DATE, address) : new Cell(value, Cell.CellType.STRING, address)) : (type == null ? ((tuple = WorksheetReader.getNumericValue(value)).isValid() ? new Cell(tuple.getData(), Cell.CellType.NUMBER, address) : new Cell(value, Cell.CellType.STRING, address)) : (type.equals("b") ? ((tuple = WorksheetReader.getBooleanValue(value)).isValid() ? new Cell(tuple.getData(), Cell.CellType.BOOL, address) : new Cell(value, Cell.CellType.STRING, address)) : (formula != null ? new Cell(formula, Cell.CellType.FORMULA, address) : (type.equals("s") ? (!(tuple = WorksheetReader.getIntValue(value)).isValid() ? new Cell(value, Cell.CellType.STRING, address) : ((s = this.sharedStrings.getString((Integer)tuple.getData())) != null ? new Cell(s, Cell.CellType.STRING, address) : new Cell(value, Cell.CellType.STRING, address))) : new Cell(value, Cell.CellType.STRING, address)))));
        this.data.put(address, cell);
    }

    private static CellResolverTuple getNumericValue(String raw) {
        CellResolverTuple t;
        try {
            double d = Double.parseDouble(raw);
            t = new CellResolverTuple(true, d, Double.class);
        }
        catch (Exception e) {
            t = new CellResolverTuple(false, 0, Double.class);
        }
        return t;
    }

    private static CellResolverTuple getIntValue(String raw) {
        CellResolverTuple t;
        try {
            int i = Integer.parseInt(raw);
            t = new CellResolverTuple(true, i, Integer.class);
        }
        catch (Exception e) {
            t = new CellResolverTuple(false, 0, Integer.class);
        }
        return t;
    }

    private static CellResolverTuple getBooleanValue(String raw) {
        boolean state;
        boolean value;
        if (raw.equals("0")) {
            value = false;
            state = true;
        } else if (raw.equals("1")) {
            value = true;
            state = true;
        } else {
            try {
                value = Boolean.parseBoolean(raw);
                state = true;
            }
            catch (Exception e) {
                value = false;
                state = false;
            }
        }
        return new CellResolverTuple(state, value, Boolean.class);
    }

    private static CellResolverTuple getDateValue(String raw) {
        CellResolverTuple t;
        try {
            double d = Double.parseDouble(raw);
            Date d2 = Helper.getDateFromOA(d);
            t = new CellResolverTuple(true, d2, Date.class);
        }
        catch (Exception e) {
            t = new CellResolverTuple(false, 0, Date.class);
        }
        return t;
    }

    static final class CellResolverTuple {
        private final boolean isValid;
        private final Object data;
        private final Class<?> type;

        public boolean isValid() {
            return this.isValid;
        }

        public Object getData() {
            return this.data;
        }

        public Class<?> getType() {
            return this.type;
        }

        public CellResolverTuple(boolean isValid, Object data, Class<?> type) {
            this.data = data;
            this.isValid = isValid;
            this.type = type;
        }
    }
}

