/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.lowLevel;

import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class WorkbookReader {
    private final Map<Integer, String> worksheetDefinitions = new HashMap<Integer, String>();

    public Map<Integer, String> getWorksheetDefinitions() {
        return this.worksheetDefinitions;
    }

    public void read(InputStream stream) throws IOException {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try {
            XMLStreamReader xr = factory.createXMLStreamReader(stream);
            while (xr.hasNext()) {
                String name;
                int nodeType = xr.next();
                if (nodeType != 1 || !(name = xr.getName().getLocalPart().toLowerCase()).equals("sheet")) continue;
                String sheetName = xr.getAttributeValue(null, "name");
                String sheetId = xr.getAttributeValue(null, "sheetId");
                int id = Integer.parseInt(sheetId);
                this.worksheetDefinitions.put(id, sheetName);
            }
        }
        catch (Exception ex) {
            throw new IOException("XMLStreamException", "The XML entry could not be read from the input stream. Please see the inner exception:", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (java.io.IOException ex) {
                    throw new IOException("XMLStreamException", "The XML entry stream could not be closed. Please see the inner exception:", ex);
                }
            }
        }
    }
}

