/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.lowLevel;

import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class SharedStringsReader {
    private final List<String> sharedStrings = new ArrayList<String>();

    public List<String> getSharedStrings() {
        return this.sharedStrings;
    }

    public boolean hasElements() {
        return this.sharedStrings.size() > 0;
    }

    public String getString(int index) {
        if (!this.hasElements() || index > this.sharedStrings.size() - 1) {
            return null;
        }
        return this.sharedStrings.get(index);
    }

    public void read(InputStream stream) throws IOException {
        this.sharedStrings.clear();
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try {
            XMLStreamReader xr = factory.createXMLStreamReader(stream);
            boolean isStringItem = false;
            boolean isText = false;
            StringBuilder sb = new StringBuilder();
            while (xr.hasNext()) {
                String name;
                int type = xr.next();
                if (type == 1) {
                    name = xr.getName().getLocalPart().toLowerCase();
                    if (name.equals("si") && xr.isStartElement()) {
                        isStringItem = true;
                        continue;
                    }
                    if (!name.equals("t") || !isStringItem) continue;
                    isText = true;
                    continue;
                }
                if (type == 2) {
                    name = xr.getName().getLocalPart().toLowerCase();
                    if (!name.equals("si") || !isStringItem || !isText) continue;
                    this.sharedStrings.add(sb.toString());
                    sb.setLength(0);
                    isText = false;
                    isStringItem = false;
                    continue;
                }
                if (type != 4 || !isText) continue;
                sb.append(xr.getText());
            }
        }
        catch (Exception ex) {
            throw new IOException("XMLStreamException", "The XML entry could not be read from the input stream. Please see the inner exception:", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (java.io.IOException ex) {
                    throw new IOException("XMLStreamException", "The XML entry stream could not be closed. Please see the inner exception:", ex);
                }
            }
        }
    }
}

