/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.lowLevel;

import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import ch.rabanti.nanoxlsx4j.lowLevel.XlsXWriter;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;

public class Packer {
    private static final String CONTENT_TYPE_DOCUMENT = "[Content_Types].xml";
    private final List<String> contentTypeList;
    private final List<byte[]> dataList = new ArrayList<byte[]>();
    private final List<Boolean> includeContentType;
    private final List<String> pathList = new ArrayList<String>();
    private final List<Relationship> relationships;
    private final XlsXWriter xlsXWriterReference;

    public Packer(XlsXWriter reference) {
        this.contentTypeList = new ArrayList<String>();
        this.relationships = new ArrayList<Relationship>();
        this.includeContentType = new ArrayList<Boolean>();
        this.xlsXWriterReference = reference;
    }

    public void addPart(String name, String contentType, Document document) throws IOException {
        this.dataList.add(XlsXWriter.createBytesFromDocument(document));
        this.pathList.add(name);
        this.contentTypeList.add(contentType);
        this.includeContentType.add(true);
    }

    public void addPart(String name, String contentType, Document document, boolean includeInContentType) throws IOException {
        this.dataList.add(XlsXWriter.createBytesFromDocument(document));
        this.pathList.add(name);
        this.contentTypeList.add(contentType);
        this.includeContentType.add(includeInContentType);
    }

    private byte[] createContentTypeDocument() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\r\n");
        sb.append("<Default Extension=\"xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\" />\r\n");
        sb.append("<Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" />\r\n");
        for (int i = 0; i < this.contentTypeList.size(); ++i) {
            if (!this.includeContentType.get(i).booleanValue()) continue;
            sb.append("<Override PartName=\"/");
            sb.append(this.pathList.get(i));
            sb.append("\" ContentType=\"");
            sb.append(this.contentTypeList.get(i));
            sb.append("\" />\r\n");
        }
        sb.append("</Types>");
        Document d = this.xlsXWriterReference.createXMLDocument(sb.toString(), "CONTENTTYPE");
        return XlsXWriter.createBytesFromDocument(d);
    }

    public Relationship createRelationship(String path) {
        Relationship r = new Relationship(path);
        this.relationships.add(r);
        return r;
    }

    private byte[] createRelationshipDocument(Relationship rel) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\r\n");
        for (int i = 0; i < rel.getIdList().size(); ++i) {
            sb.append("<Relationship Target=\"");
            sb.append(rel.getTargetList().get(i));
            sb.append("\" Type=\"");
            sb.append(rel.getTypeList().get(i));
            sb.append("\" Id=\"");
            sb.append(rel.getIdList().get(i));
            sb.append("\"/>\r\n");
        }
        sb.append("</Relationships>");
        Document d = this.xlsXWriterReference.createXMLDocument(sb.toString(), "REL: " + rel.currentId);
        return XlsXWriter.createBytesFromDocument(d);
    }

    public void pack(OutputStream stream) throws IOException {
        try {
            byte[] data;
            int i;
            byte[] contentTypes = this.createContentTypeDocument();
            ZipOutputStream out = new ZipOutputStream((OutputStream)new BufferedOutputStream(stream), Charset.forName("UTF-8"));
            out.setMethod(8);
            ZipEntry entry = new ZipEntry(CONTENT_TYPE_DOCUMENT);
            out.putNextEntry(entry);
            out.write(contentTypes, 0, contentTypes.length);
            for (i = 0; i < this.relationships.size(); ++i) {
                data = this.createRelationshipDocument(this.relationships.get(i));
                entry = new ZipEntry(this.relationships.get(i).getRootFolder());
                out.putNextEntry(entry);
                out.write(data, 0, data.length);
            }
            for (i = 0; i < this.dataList.size(); ++i) {
                data = this.dataList.get(i);
                entry = new ZipEntry(this.pathList.get(i));
                out.putNextEntry(entry);
                out.write(data, 0, data.length);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new IOException("PackingException", "There was an error while packing the file. Please see the inner exception.", e);
        }
    }

    public class Relationship {
        private final String rootFolder;
        private final List<String> targetList;
        private final List<String> typeList;
        private final List<String> idList = new ArrayList<String>();
        private int currentId;

        String getRootFolder() {
            return this.rootFolder;
        }

        List<String> getTargetList() {
            return this.targetList;
        }

        List<String> getTypeList() {
            return this.typeList;
        }

        List<String> getIdList() {
            return this.idList;
        }

        Relationship(String path) {
            this.targetList = new ArrayList<String>();
            this.typeList = new ArrayList<String>();
            this.rootFolder = path;
            this.currentId = 1;
        }

        public void addRelationshipEntry(String target, String type) {
            this.targetList.add(target);
            this.typeList.add(type);
            String id = "rId" + this.currentId;
            this.idList.add(id);
            ++this.currentId;
        }
    }
}

