/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j.demo;

import ch.rabanti.nanoxlsx4j.Address;
import ch.rabanti.nanoxlsx4j.BasicFormulas;
import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.Range;
import ch.rabanti.nanoxlsx4j.Workbook;
import ch.rabanti.nanoxlsx4j.Worksheet;
import ch.rabanti.nanoxlsx4j.styles.BasicStyles;
import ch.rabanti.nanoxlsx4j.styles.CellXf;
import ch.rabanti.nanoxlsx4j.styles.Fill;
import ch.rabanti.nanoxlsx4j.styles.Style;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class NanoXLSX4j {
    private static String outputFolder = "./demoFiles/";

    public static void main(String[] args) {
        if (!Files.exists(Paths.get(outputFolder, new String[0]), new LinkOption[0])) {
            File dir = new File(outputFolder);
            dir.mkdirs();
        }
        NanoXLSX4j.basicDemo();
        NanoXLSX4j.read();
        NanoXLSX4j.shortenerDemo();
        NanoXLSX4j.streamDemo();
        NanoXLSX4j.demo1();
        NanoXLSX4j.demo2();
        NanoXLSX4j.demo3();
        NanoXLSX4j.demo4();
        NanoXLSX4j.demo5();
        NanoXLSX4j.demo6();
        NanoXLSX4j.demo7();
        NanoXLSX4j.demo8();
        NanoXLSX4j.demo9();
        NanoXLSX4j.demo10();
    }

    private static void basicDemo() {
        Workbook workbook = new Workbook(outputFolder + "basic.xlsx", "Sheet1");
        workbook.getCurrentWorksheet().addNextCell("Test");
        workbook.getCurrentWorksheet().addNextCell("Test2");
        workbook.getCurrentWorksheet().addNextCell("Test3");
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void read() {
        try {
            Workbook wb = Workbook.load(outputFolder + "basic.xlsx");
            System.out.println("contains worksheet name: " + wb.getCurrentWorksheet().getSheetName());
            wb.getCurrentWorksheet().getCells().forEach((k, v) -> System.out.println("Cell address: " + k + ": content:'" + v.getValue() + "'"));
            FileInputStream fi = new FileInputStream(outputFolder + "basic.xlsx");
            Workbook wb2 = Workbook.load(fi);
            fi.close();
            System.out.println("contains worksheet name: " + wb2.getCurrentWorksheet().getSheetName());
            wb2.getCurrentWorksheet().getCells().forEach((k, v) -> System.out.println("Cell address: " + k + ": content:'" + v.getValue() + "'"));
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex);
        }
    }

    private static void shortenerDemo() {
        Workbook wb = new Workbook(outputFolder + "shortenerDemo.xlsx", "Sheet1");
        wb.WS.value("Some Text");
        wb.WS.value(58.55, BasicStyles.DoubleUnderline());
        wb.WS.right(2);
        wb.WS.value(true);
        wb.addWorksheet("Sheet2");
        wb.getCurrentWorksheet().setCurrentCellDirection(Worksheet.CellDirection.RowToRow);
        wb.WS.value("This is another text");
        wb.WS.formula("=A1");
        wb.WS.down();
        wb.WS.value("Formatted Text", BasicStyles.Bold());
        try {
            wb.save();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private static void streamDemo() {
        Workbook workbook = new Workbook(true);
        workbook.getCurrentWorksheet().addNextCell("This is an example");
        workbook.getCurrentWorksheet().addNextCellFormula("=A1");
        workbook.getCurrentWorksheet().addNextCell(123456789);
        try {
            FileOutputStream fs = new FileOutputStream(outputFolder + "stream.xlsx");
            workbook.saveAsStream(fs);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private static void demo1() {
        Workbook workbook = new Workbook(outputFolder + "test1.xlsx", "Sheet1");
        workbook.getCurrentWorksheet().addNextCell("Test");
        workbook.getCurrentWorksheet().addNextCell(123);
        workbook.getCurrentWorksheet().addNextCell(true);
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCell(123.456);
        workbook.getCurrentWorksheet().addNextCell(Float.valueOf(123.789f));
        workbook.getCurrentWorksheet().addNextCell(new Date());
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCellFormula("B1*22");
        workbook.getCurrentWorksheet().addNextCellFormula("ROUNDDOWN(A2,1)");
        workbook.getCurrentWorksheet().addNextCellFormula("PI()");
        workbook.addWorksheet("Addresses");
        workbook.getCurrentWorksheet().setCurrentCellDirection(Worksheet.CellDirection.Disabled);
        workbook.getCurrentWorksheet().addCell((Object)"Default", 0, 0);
        Address address = new Address(1, 0, Cell.AddressType.Default);
        workbook.getCurrentWorksheet().addCell((Object)address.toString(), 1, 0);
        workbook.getCurrentWorksheet().addCell((Object)"Fixed Column", 0, 1);
        address = new Address(1, 1, Cell.AddressType.FixedColumn);
        workbook.getCurrentWorksheet().addCell((Object)address.toString(), 1, 1);
        workbook.getCurrentWorksheet().addCell((Object)"Fixed Row", 0, 2);
        address = new Address(1, 2, Cell.AddressType.FixedRow);
        workbook.getCurrentWorksheet().addCell((Object)address.toString(), 1, 2);
        workbook.getCurrentWorksheet().addCell((Object)"Fixed Row and Column", 0, 3);
        address = new Address(1, 3, Cell.AddressType.FixedRowAndColumn);
        workbook.getCurrentWorksheet().addCell((Object)address.toString(), 1, 3);
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo2() {
        Workbook workbook = new Workbook(false);
        workbook.addWorksheet("Sheet1");
        workbook.getCurrentWorksheet().addNextCell("\u6708\u66dc\u65e5");
        workbook.getCurrentWorksheet().addNextCell(-987);
        workbook.getCurrentWorksheet().addNextCell(false);
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCell(-123.456);
        workbook.getCurrentWorksheet().addNextCell(Float.valueOf(-123.789f));
        workbook.getCurrentWorksheet().addNextCell(new Date());
        workbook.addWorksheet("Sheet2");
        workbook.getCurrentWorksheet().addCell("ABC", "A1");
        workbook.getCurrentWorksheet().addCell((Object)779, 2, 1);
        workbook.getCurrentWorksheet().addCell((Object)false, 3, 2);
        workbook.getCurrentWorksheet().addNextCell(0);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("V1");
        values.add(true);
        values.add(16.8);
        workbook.getCurrentWorksheet().addCellRange(values, "A4:C4");
        try {
            workbook.saveAs(outputFolder + "test2.xlsx");
            workbook.saveAs(outputFolder + "test2.xlsx");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo3() {
        Workbook workbook = new Workbook(outputFolder + "test3.xlsx", "Sheet1");
        workbook.getCurrentWorksheet().setCurrentCellDirection(Worksheet.CellDirection.RowToRow);
        workbook.getCurrentWorksheet().addNextCell(1);
        workbook.getCurrentWorksheet().addNextCell(2);
        workbook.getCurrentWorksheet().addNextCell(3);
        workbook.getCurrentWorksheet().addNextCell(4);
        int row = workbook.getCurrentWorksheet().getCurrentRowNumber();
        int col = workbook.getCurrentWorksheet().getCurrentColumnNumber();
        workbook.getCurrentWorksheet().addNextCell("This cell has the row number " + (row + 1) + " and column number " + (col + 1));
        workbook.getCurrentWorksheet().goToNextColumn();
        workbook.getCurrentWorksheet().addNextCell("A");
        workbook.getCurrentWorksheet().addNextCell("B");
        workbook.getCurrentWorksheet().addNextCell("C");
        workbook.getCurrentWorksheet().addNextCell("D");
        workbook.getCurrentWorksheet().removeCell("A2");
        workbook.getCurrentWorksheet().removeCell(1, 1);
        workbook.getCurrentWorksheet().goToNextRow(3);
        Object value = workbook.getCurrentWorksheet().getCell(1, 2).getValue();
        workbook.getCurrentWorksheet().addNextCell("Value of B3 is: " + value);
        workbook.getCurrentWorksheet().setCurrentCellDirection(Worksheet.CellDirection.Disabled);
        workbook.getCurrentWorksheet().addCell((Object)"Text A", 3, 0);
        workbook.getCurrentWorksheet().addCell((Object)"Text B", 4, 1);
        workbook.getCurrentWorksheet().addCell((Object)"Text C", 3, 2);
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo4() {
        Workbook workbook = new Workbook(outputFolder + "test4.xlsx", "Sheet1");
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Header1");
        values.add("Header2");
        values.add("Header3");
        workbook.getCurrentWorksheet().addCellRange(values, new Address(0, 0), new Address(2, 0));
        workbook.getCurrentWorksheet().getCells().get("A1").setStyle(BasicStyles.Bold());
        workbook.getCurrentWorksheet().getCells().get("B1").setStyle(BasicStyles.Bold());
        workbook.getCurrentWorksheet().getCells().get("C1").setStyle(BasicStyles.Bold());
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCell(new Date());
        workbook.getCurrentWorksheet().addNextCell(2);
        workbook.getCurrentWorksheet().addNextCell(3);
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCell(new Date());
        workbook.getCurrentWorksheet().addNextCell("B");
        workbook.getCurrentWorksheet().addNextCell("C");
        Style s = new Style();
        s.getFill().setColor("FF22FF11", Fill.FillType.fillColor);
        s.getFont().setDoubleUnderline(true);
        s.getCellXf().setHorizontalAlign(CellXf.HorizontalAlignValue.center);
        Style s2 = s.copyStyle();
        s2.getFont().setItalic(true);
        workbook.getCurrentWorksheet().getCells().get("B2").setStyle(s);
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCell(new Date(115, 9, 3));
        workbook.getCurrentWorksheet().addNextCell(true);
        workbook.getCurrentWorksheet().addNextCell(false, s2);
        workbook.getCurrentWorksheet().getCells().get("C2").setStyle(BasicStyles.BorderFrame());
        Style s3 = BasicStyles.Strike();
        s3.getCellXf().setTextRotation(45);
        s3.getCellXf().setVerticalAlign(CellXf.VerticalAlignValue.center);
        workbook.getCurrentWorksheet().getCells().get("B4").setStyle(s3);
        workbook.getCurrentWorksheet().setColumnWidth(0, 20.0f);
        workbook.getCurrentWorksheet().setColumnWidth(1, 15.0f);
        workbook.getCurrentWorksheet().setColumnWidth(2, 25.0f);
        workbook.getCurrentWorksheet().setRowHeight(0, 20.0f);
        workbook.getCurrentWorksheet().setRowHeight(1, 30.0f);
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo5() {
        Workbook workbook = new Workbook(outputFolder + "test5.xlsx", "Sheet1");
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Header1");
        values.add("Header2");
        values.add("Header3");
        workbook.getCurrentWorksheet().setActiveStyle(BasicStyles.BorderFrameHeader());
        workbook.getCurrentWorksheet().addCellRange(values, "A1:C1");
        values = new ArrayList();
        values.add("Cell A2");
        values.add("Cell B2");
        values.add("Cell C2");
        workbook.getCurrentWorksheet().setActiveStyle(BasicStyles.BorderFrame());
        workbook.getCurrentWorksheet().addCellRange(values, "A2:C2");
        values = new ArrayList();
        values.add("Cell A3");
        values.add("Cell B3");
        values.add("Cell C3");
        workbook.getCurrentWorksheet().addCellRange(values, "A3:C3");
        values = new ArrayList();
        values.add("Cell A4");
        values.add("Cell B4");
        values.add("Cell C4");
        workbook.getCurrentWorksheet().clearActiveStyle();
        workbook.getCurrentWorksheet().addCellRange(values, "A4:C4");
        workbook.getWorkbookMetadata().setTitle("Test 5");
        workbook.getWorkbookMetadata().setSubject("This is the 5th PicoXLSX test");
        workbook.getWorkbookMetadata().setCreator("PicoXLSX");
        workbook.getWorkbookMetadata().setKeywords("Keyword1;Keyword2;Keyword3");
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo6() {
        Workbook workbook = new Workbook(outputFolder + "test6.xlsx", "Sheet1");
        workbook.getCurrentWorksheet().addNextCell("Merged1");
        workbook.getCurrentWorksheet().mergeCells("A1:C1");
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCell(false);
        workbook.getCurrentWorksheet().mergeCells("A2:D2");
        workbook.getCurrentWorksheet().goToNextRow();
        workbook.getCurrentWorksheet().addNextCell("22.2d");
        workbook.getCurrentWorksheet().mergeCells("A3:E4");
        workbook.addWorksheet("Protected");
        workbook.getCurrentWorksheet().addAllowedActionOnSheetProtection(Worksheet.SheetProtectionValue.sort);
        workbook.getCurrentWorksheet().addAllowedActionOnSheetProtection(Worksheet.SheetProtectionValue.insertRows);
        workbook.getCurrentWorksheet().addAllowedActionOnSheetProtection(Worksheet.SheetProtectionValue.selectLockedCells);
        workbook.getCurrentWorksheet().addNextCell("Cell A1");
        workbook.getCurrentWorksheet().addNextCell("Cell B1");
        workbook.getCurrentWorksheet().getCells().get("A1").setCellLockedState(false, true);
        workbook.addWorksheet("PWD-Protected");
        workbook.getCurrentWorksheet().addCell((Object)"This worksheet is password protected. The password is:", 0, 0);
        workbook.getCurrentWorksheet().addCell((Object)"test123", 0, 1);
        workbook.getCurrentWorksheet().setSheetProtectionPassword("test123");
        workbook.setWorkbookProtection(true, true, true, null);
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo7() {
        Workbook workbook = new Workbook(false);
        String invalidSheetName = "Sheet?1";
        String sanitizedSheetName = Worksheet.sanitizeWorksheetName(invalidSheetName, workbook);
        workbook.addWorksheet(sanitizedSheetName);
        Worksheet ws = workbook.getCurrentWorksheet();
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Cell A1");
        values.add("Cell B1");
        values.add("Cell C1");
        values.add("Cell D1");
        ws.addCellRange(values, "A1:D1");
        values = new ArrayList();
        values.add("Cell A2");
        values.add("Cell B2");
        values.add("Cell C2");
        values.add("Cell D2");
        ws.addCellRange(values, "A2:D2");
        values = new ArrayList();
        values.add("Cell A3");
        values.add("Cell B3");
        values.add("Cell C3");
        values.add("Cell D3");
        ws.addCellRange(values, "A3:D3");
        ws.addHiddenColumn("C");
        ws.addHiddenRow(1);
        ws.setAutoFilter(1, 3);
        try {
            workbook.saveAs(outputFolder + "test7.xlsx");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo8() {
        Workbook workbook = new Workbook(outputFolder + "test8.xlsx", "Sheet*1", true);
        workbook.getCurrentWorksheet().addNextCell("Test");
        workbook.getCurrentWorksheet().setSelectedCells("A5:B10");
        workbook.addWorksheet("Sheet2");
        workbook.getCurrentWorksheet().addNextCell("Test2");
        Range range = new Range(new Address(1, 1), new Address(3, 3));
        workbook.getCurrentWorksheet().setSelectedCells(range);
        workbook.addWorksheet("Sheet2", true);
        workbook.getCurrentWorksheet().addNextCell("Test3");
        workbook.getCurrentWorksheet().setSelectedCells(new Address(2, 2), new Address(4, 4));
        workbook.setSelectedWorksheet(1);
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo9() {
        Workbook workbook = new Workbook(outputFolder + "test9.xlsx", "sheet1");
        List<Object> numbers = Arrays.asList(1.15, 2.225, 13.8, 15.0, 15.1, 17.22, 22.0, 107.5, 128.0);
        List<Object> texts = Arrays.asList("value 1", "value 2", "value 3", "value 4", "value 5", "value 6", "value 7", "value 8", "value 9");
        workbook.WS.value("Numbers", BasicStyles.Bold());
        workbook.WS.value("Values", BasicStyles.Bold());
        workbook.WS.value("Formula type", BasicStyles.Bold());
        workbook.WS.value("Formula value", BasicStyles.Bold());
        workbook.WS.value("(See also worksheet2)");
        workbook.getCurrentWorksheet().addCellRange(numbers, "A2:A10");
        workbook.getCurrentWorksheet().addCellRange(texts, "B2:B10");
        workbook.getCurrentWorksheet().setCurrentCellAddress("D2");
        Cell c2 = BasicFormulas.Average(new Range("A2:A10"));
        workbook.getCurrentWorksheet().addCell("Average", "C2");
        workbook.getCurrentWorksheet().addCell(c2, "D2");
        c2 = BasicFormulas.Ceil(new Address("A2"), 0);
        workbook.getCurrentWorksheet().addCell("Ceil", "C3");
        workbook.getCurrentWorksheet().addCell(c2, "D3");
        c2 = BasicFormulas.Floor(new Address("A2"), 0);
        workbook.getCurrentWorksheet().addCell("Floor", "C4");
        workbook.getCurrentWorksheet().addCell(c2, "D4");
        c2 = BasicFormulas.Round(new Address("A3"), 1);
        workbook.getCurrentWorksheet().addCell("Round", "C5");
        workbook.getCurrentWorksheet().addCell(c2, "D5");
        c2 = BasicFormulas.Max(new Range("A2:A10"));
        workbook.getCurrentWorksheet().addCell("Max", "C6");
        workbook.getCurrentWorksheet().addCell(c2, "D6");
        c2 = BasicFormulas.Min(new Range("A2:A10"));
        workbook.getCurrentWorksheet().addCell("Min", "C7");
        workbook.getCurrentWorksheet().addCell(c2, "D7");
        c2 = BasicFormulas.Median(new Range("A2:A10"));
        workbook.getCurrentWorksheet().addCell("Median", "C8");
        workbook.getCurrentWorksheet().addCell(c2, "D8");
        c2 = BasicFormulas.Sum(new Range("A2:A10"));
        workbook.getCurrentWorksheet().addCell("Sum", "C9");
        workbook.getCurrentWorksheet().addCell(c2, "D9");
        c2 = BasicFormulas.VLookup(13.8, new Range("A2:B10"), 2, true);
        workbook.getCurrentWorksheet().addCell("Vlookup", "C10");
        workbook.getCurrentWorksheet().addCell(c2, "D10");
        workbook.addWorksheet("sheet2");
        c2 = BasicFormulas.VLookup(workbook.getWorksheets().get(0), new Address("B4"), workbook.getWorksheets().get(0), new Range("B2:C10"), 2, true);
        workbook.WS.value(c2);
        c2 = BasicFormulas.Median(workbook.getWorksheets().get(0), new Range("A2:A10"));
        workbook.WS.value(c2);
        try {
            workbook.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void demo10() {
        Workbook wb = new Workbook(outputFolder + "demo10.xlsx", "styleAppending");
        Style style = new Style();
        style.append(BasicStyles.Bold());
        style.append(BasicStyles.Underline());
        style.append(BasicStyles.font("Arial Black", 20));
        wb.WS.value("THIS IS A TEST", style);
        wb.WS.down();
        Style chainedStyle = new Style().append(BasicStyles.Underline()).append(BasicStyles.colorizedText("FF00FF")).append(BasicStyles.colorizedBackground("AAFFAA"));
        wb.WS.value("Another test", chainedStyle);
        try {
            wb.save();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

