/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.Address;
import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.Column;
import ch.rabanti.nanoxlsx4j.Helper;
import ch.rabanti.nanoxlsx4j.Range;
import ch.rabanti.nanoxlsx4j.Workbook;
import ch.rabanti.nanoxlsx4j.exceptions.FormatException;
import ch.rabanti.nanoxlsx4j.exceptions.RangeException;
import ch.rabanti.nanoxlsx4j.exceptions.WorksheetException;
import ch.rabanti.nanoxlsx4j.styles.BasicStyles;
import ch.rabanti.nanoxlsx4j.styles.Style;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Worksheet {
    public static final float DEFAULT_COLUMN_WIDTH = 10.0f;
    public static final float DEFAULT_ROW_HEIGHT = 15.0f;
    public static final int MAX_COLUMN_NUMBER = 16383;
    public static final float MAX_COLUMN_WIDTH = 255.0f;
    public static final int MAX_ROW_NUMBER = 1048575;
    public static final float MAX_ROW_HEIGHT = 409.5f;
    public static final int MIN_COLUMN_NUMBER = 0;
    public static final float MIN_COLUMN_WIDTH = 0.0f;
    public static final int MIN_ROW_NUMBER = 0;
    public static final float MIN_ROW_HEIGHT = 0.0f;
    private Style activeStyle;
    private Range autoFilterRange;
    private Map<String, Cell> cells;
    private Map<Integer, Column> columns;
    private CellDirection currentCellDirection;
    private int currentColumnNumber;
    private int currentRowNumber;
    private float defaultColumnWidth;
    private float defaultRowHeight;
    private Map<Integer, Boolean> hiddenRows;
    private Map<String, Range> mergedCells;
    private Map<Integer, Float> rowHeights;
    private Range selectedCells;
    private int sheetID;
    private String sheetName;
    private String sheetProtectionPassword;
    private List<SheetProtectionValue> sheetProtectionValues;
    private boolean useSheetProtection;
    private boolean useActiveStyle;
    private Workbook workbookReference;

    public void setAutoFilterRange(String range) {
        this.autoFilterRange = Cell.resolveCellRange(range);
        this.recalculateAutoFilter();
        this.recalculateColumns();
    }

    public Range getAutoFilterRange() {
        return this.autoFilterRange;
    }

    public Map<String, Cell> getCells() {
        return this.cells;
    }

    public Map<Integer, Column> getColumns() {
        return this.columns;
    }

    public CellDirection getCurrentCellDirection() {
        return this.currentCellDirection;
    }

    public void setCurrentCellDirection(CellDirection currentCellDirection) {
        this.currentCellDirection = currentCellDirection;
    }

    public void setCurrentColumnNumber(int columnNumber) {
        if (columnNumber > 16383 || columnNumber < 0) {
            throw new RangeException("OutOfRangeException", "The column number (" + columnNumber + ") is out of range. Range is from " + 0 + " to " + 16383 + " (" + 16384 + " columns).");
        }
        this.currentColumnNumber = columnNumber;
    }

    public void setCurrentRowNumber(int rowNumber) {
        if (rowNumber > 1048575 || rowNumber < 0) {
            throw new RangeException("OutOfRangeException", "The row number (" + rowNumber + ") is out of range. Range is from " + 0 + " to " + 1048575 + " (" + 0x100000 + " rows).");
        }
        this.currentRowNumber = rowNumber;
    }

    public int getCurrentColumnNumber() {
        return this.currentColumnNumber;
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    public float getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(float defaultColumnWidth) {
        if (this.defaultRowHeight < 0.0f || this.defaultRowHeight > 255.0f) {
            throw new RangeException("OutOfRangeException", "The passed default row height is out of range (0.0 to 255.0)");
        }
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public float getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(float defaultRowHeight) {
        if (defaultRowHeight < 0.0f || defaultRowHeight > 409.5f) {
            throw new RangeException("OutOfRangeException", "The passed default row height is out of range (0.0 to 409.5)");
        }
        this.defaultRowHeight = defaultRowHeight;
    }

    public Map<Integer, Boolean> getHiddenRows() {
        return this.hiddenRows;
    }

    public Map<String, Range> getMergedCells() {
        return this.mergedCells;
    }

    public Map<Integer, Float> getRowHeights() {
        return this.rowHeights;
    }

    public Range getSelectedCells() {
        return this.selectedCells;
    }

    public void setSelectedCells(String range) {
        this.selectedCells = Cell.resolveCellRange(range);
    }

    public void setSelectedCells(Range range) {
        this.selectedCells = range;
    }

    public int getSheetID() {
        return this.sheetID;
    }

    public void setSheetID(int sheetID) {
        this.sheetID = sheetID;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public boolean isUseSheetProtection() {
        return this.useSheetProtection;
    }

    public void setUseSheetProtection(boolean useSheetProtection) {
        this.useSheetProtection = useSheetProtection;
    }

    public String getSheetProtectionPassword() {
        return this.sheetProtectionPassword;
    }

    public void setSheetProtectionPassword(String password) {
        if (Helper.isNullOrEmpty(password)) {
            this.sheetProtectionPassword = null;
        } else {
            this.sheetProtectionPassword = password;
            this.useSheetProtection = true;
        }
    }

    public List<SheetProtectionValue> getSheetProtectionValues() {
        return this.sheetProtectionValues;
    }

    public Workbook getWorkbookReference() {
        return this.workbookReference;
    }

    public void setWorkbookReference(Workbook workbookReference) {
        this.workbookReference = workbookReference;
    }

    public Worksheet() {
        this.init();
    }

    public Worksheet(Workbook reference) {
        this.init();
        this.workbookReference = reference;
    }

    public Worksheet(String name, int id, Workbook reference) {
        this.init();
        this.setSheetName(name);
        this.sheetID = id;
        this.workbookReference = reference;
    }

    public void addNextCell(Object value) {
        this.addNextCell(this.castValue(value, this.currentColumnNumber, this.currentRowNumber), true, null);
    }

    public void addNextCell(Object value, Style style) {
        this.addNextCell(this.castValue(value, this.currentColumnNumber, this.currentRowNumber), true, style);
    }

    private void addNextCell(Cell cell, boolean incremental, Style style) {
        cell.setWorksheetReference(this);
        if (this.activeStyle != null && this.useActiveStyle && style == null) {
            cell.setStyle(this.activeStyle);
        } else if (style != null) {
            cell.setStyle(style);
        } else if (style == null && cell.getDataType() == Cell.CellType.DATE) {
            cell.setStyle(BasicStyles.DateFormat());
        }
        String address = cell.getCellAddress();
        this.cells.put(address, cell);
        if (incremental) {
            if (this.getCurrentCellDirection() == CellDirection.ColumnToColumn) {
                ++this.currentColumnNumber;
            } else if (this.getCurrentCellDirection() == CellDirection.RowToRow) {
                ++this.currentRowNumber;
            }
        } else if (this.getCurrentCellDirection() == CellDirection.ColumnToColumn) {
            this.currentColumnNumber = cell.getColumnNumber() + 1;
            this.currentRowNumber = cell.getRowNumber();
        } else if (this.getCurrentCellDirection() == CellDirection.RowToRow) {
            this.currentColumnNumber = cell.getColumnNumber();
            this.currentRowNumber = cell.getRowNumber() + 1;
        }
    }

    public void addCell(Object value, int columnAddress, int rowAddress) {
        this.addNextCell(this.castValue(value, columnAddress, rowAddress), false, null);
    }

    public void addCell(Object value, int columnAddress, int rowAddress, Style style) {
        this.addNextCell(this.castValue(value, columnAddress, rowAddress), false, style);
    }

    public void addCell(Object value, String address) {
        Address adr = Cell.resolveCellCoordinate(address);
        this.addCell(value, adr.Column, adr.Row);
    }

    public void addCell(Object value, String address, Style style) {
        Address adr = Cell.resolveCellCoordinate(address);
        this.addCell(value, adr.Column, adr.Row, style);
    }

    public void addCellFormula(String formula, String address) {
        Address adr = Cell.resolveCellCoordinate(address);
        Cell c2 = new Cell(formula, Cell.CellType.FORMULA, adr.Column, adr.Row, this);
        this.addNextCell(c2, false, null);
    }

    public void addCellFormula(String formula, String address, Style style) {
        Address adr = Cell.resolveCellCoordinate(address);
        Cell c2 = new Cell(formula, Cell.CellType.FORMULA, adr.Column, adr.Row, this);
        this.addNextCell(c2, false, style);
    }

    public void addCellFormula(String formula, int columnAddress, int rowAddress) {
        Cell c2 = new Cell(formula, Cell.CellType.FORMULA, columnAddress, rowAddress, this);
        this.addNextCell(c2, false, null);
    }

    public void addCellFormula(String formula, int columnAddress, int rowAddress, Style style) {
        Cell c2 = new Cell(formula, Cell.CellType.FORMULA, columnAddress, rowAddress, this);
        this.addNextCell(c2, false, style);
    }

    public void addNextCellFormula(String formula) {
        Cell c2 = new Cell(formula, Cell.CellType.FORMULA, this.currentColumnNumber, this.currentRowNumber, this);
        this.addNextCell(c2, true, null);
    }

    public void addNextCellFormula(String formula, Style style) {
        Cell c2 = new Cell(formula, Cell.CellType.FORMULA, this.currentColumnNumber, this.currentRowNumber, this);
        this.addNextCell(c2, true, style);
    }

    public void addCellRange(List<Object> values, Address startAddress, Address endAddress) {
        this.addCellRangeInternal(values, startAddress, endAddress, null);
    }

    public void addCellRange(List<Object> values, Address startAddress, Address endAddress, Style style) {
        this.addCellRangeInternal(values, startAddress, endAddress, style);
    }

    public void addCellRange(List<Object> values, String cellRange) {
        Range rng = Cell.resolveCellRange(cellRange);
        this.addCellRangeInternal(values, rng.StartAddress, rng.EndAddress, null);
    }

    public void addCellRange(List<Object> values, String cellRange, Style style) {
        Range rng = Cell.resolveCellRange(cellRange);
        this.addCellRangeInternal(values, rng.StartAddress, rng.EndAddress, style);
    }

    private <T> void addCellRangeInternal(List<T> values, Address startAddress, Address endAddress, Style style) {
        List<Address> addresses = Cell.getCellRange(startAddress, endAddress);
        if (values.size() != addresses.size()) {
            throw new RangeException("MalformedRangeException", "The number of passed values (" + values.size() + ") differs from the number of cells within the range (" + addresses.size() + ")");
        }
        List<Cell> list = Cell.convertArray(values);
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            list.get(i).setRowNumber(addresses.get((int)i).Row);
            list.get(i).setColumnNumber(addresses.get((int)i).Column);
            list.get(i).setWorksheetReference(this);
            this.addNextCell(list.get(i), false, style);
        }
    }

    public boolean removeCell(int columnAddress, int rowAddress) {
        String address = Cell.resolveCellAddress(columnAddress, rowAddress);
        if (this.cells.containsKey(address)) {
            this.cells.remove(address);
            return true;
        }
        return false;
    }

    public boolean removeCell(String address) {
        Address adr = Cell.resolveCellCoordinate(address);
        return this.removeCell(adr.Column, adr.Row);
    }

    public void addAllowedActionOnSheetProtection(SheetProtectionValue typeOfProtection) {
        if (!this.sheetProtectionValues.contains((Object)typeOfProtection)) {
            if (typeOfProtection == SheetProtectionValue.selectLockedCells && !this.sheetProtectionValues.contains((Object)SheetProtectionValue.selectUnlockedCells)) {
                this.sheetProtectionValues.add(SheetProtectionValue.selectUnlockedCells);
            }
            this.sheetProtectionValues.add(typeOfProtection);
            this.setUseSheetProtection(true);
        }
    }

    public void addHiddenColumn(int columnNumber) {
        this.setColumnHiddenState(columnNumber, true);
    }

    public void addHiddenColumn(String columnAddress) {
        int columnNumber = Cell.resolveColumn(columnAddress);
        this.setColumnHiddenState(columnNumber, true);
    }

    public void addHiddenRow(int rowNumber) {
        this.setRowHiddenState(rowNumber, true);
    }

    private Cell castValue(Object value, int column, int row) {
        Cell c2;
        if (value instanceof Cell) {
            c2 = (Cell)value;
            c2.setWorksheetReference(this);
            c2.setCellAddress2(new Address(column, row));
        } else {
            c2 = new Cell(value, Cell.CellType.DEFAULT, column, row, this);
        }
        return c2;
    }

    public void clearActiveStyle() {
        this.useActiveStyle = false;
    }

    public Cell getCell(Address address) {
        if (!this.cells.containsKey(address.getAddress())) {
            throw new WorksheetException("CellNotFoundException", "The cell with the address " + address.getAddress() + " does not exist in this worksheet");
        }
        return this.cells.get(address.getAddress());
    }

    public Cell getCell(int columnNumber, int rowNumber) {
        return this.getCell(new Address(columnNumber, rowNumber));
    }

    public boolean hasCell(Address address) {
        return this.cells.containsKey(address.getAddress());
    }

    public boolean hasCell(int columnNumber, int rowNumber) {
        return this.hasCell(new Address(columnNumber, rowNumber));
    }

    public int getLastColumnNumber() {
        return this.getLastAddress(true);
    }

    public int getLastRowNumber() {
        return this.getLastAddress(false);
    }

    private int getLastAddress(boolean column) {
        int max = -1;
        for (Map.Entry<String, Cell> cell : this.cells.entrySet()) {
            int number = column ? cell.getValue().getColumnNumber() : cell.getValue().getRowNumber();
            if (number <= max) continue;
            max = number;
        }
        return max;
    }

    public void setColumnWidth(String columnAddress, float width) {
        int columnNumber = Cell.resolveColumn(columnAddress);
        this.setColumnWidth(columnNumber, width);
    }

    public void setCurrentCellAddress(String address) {
        Address adr = Cell.resolveCellCoordinate(address);
        this.setCurrentCellAddress(adr.Column, adr.Row);
    }

    public void setSheetName(String sheetName) {
        if (Helper.isNullOrEmpty(sheetName)) {
            throw new FormatException("FormatException", "The sheet name must be between 1 and 31 characters");
        }
        if (sheetName.length() > 31) {
            throw new FormatException("FormatException", "The sheet name must be between 1 and 31 characters");
        }
        Pattern pattern = Pattern.compile("[\\[\\]\\*\\?/\\\\]");
        Matcher mx = pattern.matcher(sheetName);
        if (mx.groupCount() > 0) {
            throw new FormatException("FormatException", "The sheet name must must not contain the characters [  ]  * ? / \\ ");
        }
        this.sheetName = sheetName;
    }

    public void setSheetName(String sheetName, boolean sanitize) {
        if (this.workbookReference == null) {
            throw new WorksheetException("MissingReferenceException", "The worksheet name cannot be sanitized because no workbook is referenced");
        }
        this.sheetName = "";
        this.sheetName = Worksheet.sanitizeWorksheetName(sheetName, this.workbookReference);
    }

    public void goToNextColumn() {
        ++this.currentColumnNumber;
        this.currentRowNumber = 0;
    }

    public void goToNextColumn(int numberOfColumns) {
        for (int i = 0; i < numberOfColumns; ++i) {
            this.goToNextColumn();
        }
    }

    public void goToNextRow() {
        ++this.currentRowNumber;
        this.currentColumnNumber = 0;
    }

    public void goToNextRow(int numberOfRows) {
        for (int i = 0; i < numberOfRows; ++i) {
            this.goToNextRow();
        }
    }

    private void init() {
        this.currentCellDirection = CellDirection.ColumnToColumn;
        this.cells = new HashMap<String, Cell>();
        this.currentRowNumber = 0;
        this.currentColumnNumber = 0;
        this.defaultColumnWidth = 10.0f;
        this.defaultRowHeight = 15.0f;
        this.rowHeights = new HashMap<Integer, Float>();
        this.activeStyle = null;
        this.workbookReference = null;
        this.mergedCells = new HashMap<String, Range>();
        this.sheetProtectionValues = new ArrayList<SheetProtectionValue>();
        this.hiddenRows = new HashMap<Integer, Boolean>();
        this.columns = new HashMap<Integer, Column>();
    }

    public String mergeCells(Range cellRange) {
        return this.mergeCells(cellRange.StartAddress, cellRange.EndAddress);
    }

    public String mergeCells(String cellRange) {
        Range range = Cell.resolveCellRange(cellRange);
        return this.mergeCells(range.StartAddress, range.EndAddress);
    }

    public String mergeCells(Address startAddress, Address endAddress) {
        String key = startAddress.toString() + ":" + endAddress.toString();
        Range value = new Range(startAddress, endAddress);
        if (!this.mergedCells.containsKey(key)) {
            this.mergedCells.put(key, value);
        }
        return key;
    }

    public void recalculateAutoFilter() {
        if (this.autoFilterRange == null) {
            return;
        }
        int start = this.autoFilterRange.StartAddress.Column;
        int end = this.autoFilterRange.EndAddress.Column;
        int endRow = 0;
        for (Map.Entry<String, Cell> item : this.getCells().entrySet()) {
            if (item.getValue().getColumnNumber() < start || item.getValue().getColumnNumber() > end || item.getValue().getRowNumber() <= endRow) continue;
            endRow = item.getValue().getRowNumber();
        }
        for (int i = start; i <= end; ++i) {
            if (!this.columns.containsKey(i)) {
                Column c2 = new Column(i);
                c2.setAutoFilter(true);
                this.columns.put(i, c2);
                continue;
            }
            this.getColumns().get(i).setAutoFilter(true);
        }
        this.autoFilterRange = new Range(new Address(start, 0), new Address(end, endRow));
    }

    public void recalculateColumns() {
        ArrayList<Integer> columnsToDelete = new ArrayList<Integer>();
        for (Map.Entry<Integer, Column> col : this.getColumns().entrySet()) {
            if (col.getValue().hasAutoFilter() || col.getValue().isHidden() || col.getValue().getWidth() != 10.0f) continue;
            columnsToDelete.add(col.getKey());
        }
        Iterator index = columnsToDelete.iterator();
        while (index.hasNext()) {
            this.columns.remove(index.next());
        }
    }

    public void removeAutoFilter() {
        this.autoFilterRange = null;
    }

    public void removeHiddenColumn(int columnNumber) {
        this.setColumnHiddenState(columnNumber, false);
    }

    public void removeHiddenColumn(String columnAddress) {
        int columnNumber = Cell.resolveColumn(columnAddress);
        this.setColumnHiddenState(columnNumber, false);
    }

    public void removeHiddenRow(int rowNumber) {
        this.setRowHiddenState(rowNumber, false);
    }

    public void removeMergedCells(String range) {
        if (!this.mergedCells.containsKey(range = range.toUpperCase())) {
            throw new RangeException("MissingReferenceException", "The cell range " + range + " was not found in the list of merged cell ranges");
        }
        List<Address> addresses = Cell.getCellRange(range);
        for (int i = 0; i < addresses.size(); ++i) {
            if (!this.cells.containsKey(addresses.get(i).toString())) continue;
            Cell cell = this.cells.get(addresses.get(i).toString());
            cell.setDataType(Cell.CellType.DEFAULT);
            if (cell.getValue() != null) continue;
            cell.setValue("");
        }
        this.mergedCells.remove(range);
    }

    public void removeSelectedCells() {
        this.selectedCells = null;
    }

    public void setActiveStyle(Style style) {
        this.useActiveStyle = true;
        this.activeStyle = style;
    }

    public void setAutoFilter(int startColumn, int endColumn) {
        String start = Cell.resolveCellAddress(startColumn, 0);
        String end = Cell.resolveCellAddress(endColumn, 0);
        if (endColumn < startColumn) {
            this.setAutoFilterRange(end + ":" + start);
        } else {
            this.setAutoFilterRange(start + ":" + end);
        }
    }

    private void setColumnHiddenState(int columnNumber, boolean state) {
        if (columnNumber > 16383 || columnNumber < 0) {
            throw new RangeException("OutOfRangeException", "The column number (" + columnNumber + ") is out of range. Range is from 0 to " + 16383 + " (" + 16384 + " columns).");
        }
        if (this.columns.containsKey(columnNumber) && state) {
            this.columns.get(columnNumber).setHidden(state);
        } else if (state) {
            Column c2 = new Column(columnNumber);
            c2.setHidden(state);
            this.columns.put(columnNumber, c2);
        }
    }

    public void setColumnWidth(int columnNumber, float width) {
        if (columnNumber > 16383 || columnNumber < 0) {
            throw new RangeException("OutOfRangeException", "The column number (" + columnNumber + ") is out of range. Range is from " + 0 + " to " + 16383 + " (" + 16384 + " columns).");
        }
        if (width < 0.0f || width > 255.0f) {
            throw new RangeException("OutOfRangeException", "The column width (" + width + ") is out of range. Range is from " + 0.0f + " to " + 255.0f + " (chars).");
        }
        if (this.columns.containsKey(columnNumber)) {
            this.columns.get(columnNumber).setWidth(width);
        } else {
            Column c2 = new Column(columnNumber);
            c2.setWidth(width);
            this.columns.put(columnNumber, c2);
        }
    }

    public void setCurrentCellAddress(int columnAddress, int rowAddress) {
        this.setCurrentColumnNumber(columnAddress);
        this.setCurrentRowNumber(rowAddress);
    }

    public void setRowHeight(int rowNumber, float height) {
        if (rowNumber > 1048575 || rowNumber < 0) {
            throw new RangeException("OutOfRangeException", "The row number (" + rowNumber + ") is out of range. Range is from " + 0 + " to " + 1048575 + " (" + 0x100000 + " rows).");
        }
        if (height < 0.0f || (double)height > 409.5) {
            throw new RangeException("OutOfRangeException", "The row height (" + height + ") is out of range. Range is from 0 to 409.5 (equals 546px).");
        }
        this.rowHeights.put(rowNumber, Float.valueOf(height));
    }

    private void setRowHiddenState(int rowNumber, boolean state) {
        if (rowNumber > 1048575 || rowNumber < 0) {
            throw new RangeException("OutOfRangeException", "The row number (" + rowNumber + ") is out of range. Range is from " + 0 + " to " + 1048575 + " (" + 0x100000 + " rows).");
        }
        if (this.hiddenRows.containsKey(rowNumber)) {
            if (state) {
                this.hiddenRows.put(rowNumber, state);
            } else {
                this.hiddenRows.remove(rowNumber);
            }
        } else if (state) {
            this.hiddenRows.put(rowNumber, state);
        }
    }

    public void setSelectedCells(Address startAddress, Address endAddress) {
        this.selectedCells = new Range(startAddress, endAddress);
    }

    public static String sanitizeWorksheetName(String input, Workbook workbook) {
        String name;
        int len;
        if (input == null) {
            input = "Sheet1";
        }
        if ((len = input.length()) > 31) {
            len = 31;
        } else if (len == 0) {
            input = "Sheet1";
        }
        StringBuilder sb = new StringBuilder(31);
        for (int i = 0; i < len; ++i) {
            char c2 = input.charAt(i);
            if (c2 == '[' || c2 == ']' || c2 == '*' || c2 == '?' || c2 == '\\' || c2 == '/') {
                sb.append('_');
                continue;
            }
            sb.append(c2);
        }
        String originalName = name = sb.toString();
        int number = 1;
        while (Worksheet.worksheetExists(name, workbook)) {
            name = originalName.length() + number / 10 >= 31 ? originalName.substring(0, 30 - number / 10) + number : originalName + number;
            ++number;
        }
        return name;
    }

    private static boolean worksheetExists(String name, Workbook workbook) {
        int len = workbook.getWorksheets().size();
        for (int i = 0; i < len; ++i) {
            if (!workbook.getWorksheets().get(i).getSheetName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static enum SheetProtectionValue {
        objects,
        scenarios,
        formatCells,
        formatColumns,
        formatRows,
        insertColumns,
        insertRows,
        insertHyperlinks,
        deleteColumns,
        deleteRows,
        selectLockedCells,
        sort,
        autoFilter,
        pivotTables,
        selectUnlockedCells;

    }

    public static enum CellDirection {
        ColumnToColumn,
        RowToRow,
        Disabled;

    }
}

