/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.Address;
import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.Helper;
import ch.rabanti.nanoxlsx4j.Metadata;
import ch.rabanti.nanoxlsx4j.Range;
import ch.rabanti.nanoxlsx4j.Shortener;
import ch.rabanti.nanoxlsx4j.Worksheet;
import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import ch.rabanti.nanoxlsx4j.exceptions.RangeException;
import ch.rabanti.nanoxlsx4j.exceptions.StyleException;
import ch.rabanti.nanoxlsx4j.exceptions.WorksheetException;
import ch.rabanti.nanoxlsx4j.lowLevel.XlsXWriter;
import ch.rabanti.nanoxlsx4j.lowLevel.XlsxReader;
import ch.rabanti.nanoxlsx4j.styles.AbstractStyle;
import ch.rabanti.nanoxlsx4j.styles.BasicStyles;
import ch.rabanti.nanoxlsx4j.styles.Border;
import ch.rabanti.nanoxlsx4j.styles.CellXf;
import ch.rabanti.nanoxlsx4j.styles.Fill;
import ch.rabanti.nanoxlsx4j.styles.Font;
import ch.rabanti.nanoxlsx4j.styles.NumberFormat;
import ch.rabanti.nanoxlsx4j.styles.Style;
import ch.rabanti.nanoxlsx4j.styles.StyleManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Workbook {
    private Worksheet currentWorksheet;
    private String filename;
    private boolean lockStructureIfProtected;
    private boolean lockWindowsIfProtected;
    private int selectedWorksheet;
    private StyleManager styleManager;
    private boolean useWorkbookProtection;
    private Metadata workbookMetadata;
    private String workbookProtectionPassword;
    private List<Worksheet> worksheets;
    public Shortener WS;

    public Worksheet getCurrentWorksheet() {
        return this.currentWorksheet;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getSelectedWorksheet() {
        return this.selectedWorksheet;
    }

    public void setSelectedWorksheet(Worksheet worksheet) {
        boolean check = false;
        for (int i = 0; i < this.worksheets.size(); ++i) {
            if (!this.worksheets.get(i).equals(worksheet)) continue;
            this.selectedWorksheet = i;
            check = true;
            break;
        }
        if (!check) {
            throw new WorksheetException("MissingReferenceException", "The passed worksheet object is not in the worksheet collection.");
        }
    }

    public void setSelectedWorksheet(int worksheetIndex) {
        if (worksheetIndex < 0 || worksheetIndex > this.worksheets.size() - 1) {
            throw new RangeException("OutOfRangeException", "The worksheet index " + worksheetIndex + " is out of range");
        }
        this.selectedWorksheet = worksheetIndex;
    }

    public Metadata getWorkbookMetadata() {
        return this.workbookMetadata;
    }

    public void setWorkbookMetadata(Metadata workbookMetadata) {
        this.workbookMetadata = workbookMetadata;
    }

    public void setWorkbookProtection(boolean useWorkbookProtection) {
        this.useWorkbookProtection = useWorkbookProtection;
    }

    public String getWorkbookProtectionPassword() {
        return this.workbookProtectionPassword;
    }

    public List<Worksheet> getWorksheets() {
        return this.worksheets;
    }

    public boolean isStructureLockedIfProtected() {
        return this.lockStructureIfProtected;
    }

    public boolean isWindowsLockedIfProtected() {
        return this.lockWindowsIfProtected;
    }

    public boolean isWorkbookProtectionUsed() {
        return this.useWorkbookProtection;
    }

    public StyleManager getStyleManager() {
        return this.styleManager;
    }

    public Workbook(boolean createWorksheet) {
        this.init();
        if (createWorksheet) {
            this.addWorksheet("Sheet1");
        }
    }

    public Workbook(String sheetName) {
        this.init();
        this.addWorksheet(sheetName, true);
    }

    public Workbook(String filename, String sheetName) {
        this.init();
        this.filename = filename;
        this.addWorksheet(sheetName, true);
    }

    public Workbook(String filename, String sheetName, boolean sanitizeSheetName) {
        this.init();
        this.filename = filename;
        this.addWorksheet(Worksheet.sanitizeWorksheetName(sheetName, this));
    }

    public Style addStyle(Style style) {
        return this.styleManager.addStyle(style);
    }

    public Style addStyleComponent(Style baseStyle, AbstractStyle newComponent) {
        if (newComponent instanceof Border) {
            baseStyle.setBorder((Border)newComponent);
        } else if (newComponent instanceof CellXf) {
            baseStyle.setCellXf((CellXf)newComponent);
        } else if (newComponent instanceof Fill) {
            baseStyle.setFill((Fill)newComponent);
        } else if (newComponent instanceof Font) {
            baseStyle.setFont((Font)newComponent);
        } else if (newComponent instanceof NumberFormat) {
            baseStyle.setNumberFormat((NumberFormat)newComponent);
        }
        return this.styleManager.addStyle(baseStyle);
    }

    public void addWorksheet(String name) {
        Worksheet newWs;
        for (int i = 0; i < this.worksheets.size(); ++i) {
            if (!this.worksheets.get(i).getSheetName().equals(name)) continue;
            throw new WorksheetException("WorksheetNameAlreadyExistsException", "The worksheet with the name '" + name + "' already exists.");
        }
        int number = this.worksheets.size() + 1;
        this.currentWorksheet = newWs = new Worksheet(name, number, this);
        this.worksheets.add(newWs);
        this.WS.setCurrentWorksheet(this.currentWorksheet);
    }

    public void addWorksheet(String name, boolean sanitizeSheetName) {
        if (sanitizeSheetName) {
            String sanitized = Worksheet.sanitizeWorksheetName(name, this);
            this.addWorksheet(sanitized);
        } else {
            this.addWorksheet(name);
        }
    }

    public void addWorksheet(Worksheet worksheet) {
        for (int i = 0; i < this.worksheets.size(); ++i) {
            if (!this.worksheets.get(i).getSheetName().equals(worksheet.getSheetName())) continue;
            throw new WorksheetException("WorksheetNameAlreadyExistsException", "The worksheet with the name '" + worksheet.getSheetName() + "' already exists.");
        }
        int number = this.worksheets.size() + 1;
        worksheet.setSheetID(number);
        worksheet.setWorkbookReference(this);
        this.currentWorksheet = worksheet;
        this.worksheets.add(worksheet);
    }

    private void init() {
        this.worksheets = new ArrayList<Worksheet>();
        this.styleManager = new StyleManager();
        this.styleManager.addStyle(new Style("default", 0, true));
        Style borderStyle = new Style("default_border_style", 1, true);
        borderStyle.setBorder(BasicStyles.DottedFill_0_125().getBorder());
        borderStyle.setFill(BasicStyles.DottedFill_0_125().getFill());
        this.styleManager.addStyle(borderStyle);
        this.workbookMetadata = new Metadata();
        this.WS = new Shortener();
    }

    public void removeStyle(Style style) {
        this.removeStyle(style, false);
    }

    public void removeStyle(String styleName) {
        this.removeStyle(styleName, false);
    }

    public void removeStyle(Style style, boolean onlyIfUnused) {
        if (style == null) {
            throw new StyleException("MissingReferenceException", "The style to remove is not defined");
        }
        this.removeStyle(style.getName(), onlyIfUnused);
    }

    public void removeStyle(String styleName, boolean onlyIfUnused) {
        if (Helper.isNullOrEmpty(styleName)) {
            throw new StyleException("MissingReferenceException", "The style to remove is not defined (no name specified)");
        }
        if (onlyIfUnused) {
            boolean styleInUse = false;
            for (int i = 0; i < this.worksheets.size(); ++i) {
                for (Map.Entry<String, Cell> item : this.worksheets.get(i).getCells().entrySet()) {
                    Cell cell = (Cell)((Object)item);
                    if (cell.getCellStyle() == null || !cell.getCellStyle().getName().equals(styleName)) continue;
                    styleInUse = true;
                    break;
                }
                if (styleInUse) break;
            }
            if (!styleInUse) {
                this.styleManager.removeStyle(styleName);
            }
        } else {
            this.styleManager.removeStyle(styleName);
        }
    }

    public void removeWorksheet(String name) {
        int i;
        boolean exists = false;
        boolean resetCurrent = false;
        int index = 0;
        for (i = 0; i < this.worksheets.size(); ++i) {
            if (!this.worksheets.get(index).getSheetName().equals(name)) continue;
            index = i;
            exists = true;
            break;
        }
        if (!exists) {
            throw new WorksheetException("MissingReferenceException", "The worksheet with the name '" + name + "' does not exist.");
        }
        if (this.worksheets.get(index).getSheetName().equals(this.currentWorksheet.getSheetName())) {
            resetCurrent = true;
        }
        this.worksheets.remove(index);
        if (this.worksheets.size() > 0) {
            for (i = 0; i < this.worksheets.size(); ++i) {
                this.worksheets.get(index).setSheetID(i + 1);
                if (!resetCurrent || i != 0) continue;
                this.currentWorksheet = this.worksheets.get(i);
            }
        } else {
            this.currentWorksheet = null;
        }
        if (this.selectedWorksheet > this.worksheets.size() - 1) {
            this.selectedWorksheet = this.worksheets.size() - 1;
        }
    }

    public void resolveMergedCells() {
        Style mergeStyle = BasicStyles.MergeCellStyle();
        for (int i = 0; i < this.worksheets.size(); ++i) {
            Worksheet sheet = this.worksheets.get(i);
            for (Map.Entry<String, Range> range : sheet.getMergedCells().entrySet()) {
                int pos = 0;
                List<Address> addresses = Cell.getCellRange(range.getValue().StartAddress, range.getValue().EndAddress);
                for (int j = 0; j < addresses.size(); ++j) {
                    Cell cell;
                    Address address = addresses.get(j);
                    if (!sheet.getCells().containsKey(address.toString())) {
                        cell = new Cell();
                        cell.setDataType(Cell.CellType.EMPTY);
                        cell.setRowNumber(address.Row);
                        cell.setColumnNumber(address.Column);
                        sheet.addCell((Object)cell, cell.getColumnNumber(), cell.getRowNumber());
                    } else {
                        cell = sheet.getCells().get(address.toString());
                    }
                    if (pos != 0) {
                        cell.setDataType(Cell.CellType.EMPTY);
                        cell.setStyle(mergeStyle);
                    }
                    ++pos;
                }
            }
        }
    }

    public void save() throws IOException {
        XlsXWriter l = new XlsXWriter(this);
        l.save();
    }

    public void saveAs(String filename) throws IOException {
        String backup = this.filename;
        this.filename = filename;
        XlsXWriter l = new XlsXWriter(this);
        l.save();
        this.filename = backup;
    }

    public void saveAsStream(OutputStream stream) throws IOException {
        XlsXWriter l = new XlsXWriter(this);
        l.saveAsStream(stream);
    }

    public Worksheet setCurrentWorksheet(String name) {
        boolean exists = false;
        for (int i = 0; i < this.worksheets.size(); ++i) {
            if (!this.worksheets.get(i).getSheetName().equals(name)) continue;
            this.currentWorksheet = this.worksheets.get(i);
            exists = true;
            break;
        }
        if (!exists) {
            throw new WorksheetException("MissingReferenceException", "The worksheet with the name '" + name + "' does not exist.");
        }
        this.WS.setCurrentWorksheet(this.currentWorksheet);
        return this.currentWorksheet;
    }

    public void setWorkbookProtection(boolean state, boolean protectWindows, boolean protectStructure, String password) {
        this.lockWindowsIfProtected = protectWindows;
        this.lockStructureIfProtected = protectStructure;
        this.workbookProtectionPassword = password;
        this.useWorkbookProtection = !protectWindows && !protectStructure ? false : state;
    }

    public static Workbook load(String filename) throws IOException {
        XlsxReader r = new XlsxReader(filename);
        r.read();
        return r.getWorkbook();
    }

    public static Workbook load(InputStream stream) throws IOException {
        XlsxReader r = new XlsxReader(stream);
        r.read();
        return r.getWorkbook();
    }
}

