/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.Address;
import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.exceptions.RangeException;

public class Range {
    public final Address EndAddress;
    public final Address StartAddress;

    public Range(Address start, Address end) {
        if (end.compareTo(start) < 0) {
            throw new RangeException("RangeFormatException", "The end address of the range cannot be smaller than the start address");
        }
        this.StartAddress = start;
        this.EndAddress = end;
    }

    public Range(String range) {
        Range r = Cell.resolveCellRange(range);
        if (r.StartAddress.compareTo(r.EndAddress) > 1) {
            throw new RangeException("RangeFormatException", "The end address of the range cannot be smaller than the start address");
        }
        this.StartAddress = r.StartAddress;
        this.EndAddress = r.EndAddress;
    }

    public String toString() {
        return this.StartAddress.toString() + ":" + this.EndAddress.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return this.StartAddress.equals(range.StartAddress) && this.EndAddress.equals(range.EndAddress);
    }

    public static Range buildRange(Address startAddress, Address endAddress) {
        return Range.buildRange(startAddress.Column, startAddress.Row, endAddress.Column, endAddress.Row);
    }

    public static Range buildRange(int startColumn, int startRow, int endColumn, int endRow) {
        Address end;
        Address start;
        if (startColumn < endColumn && startRow < endRow) {
            start = new Address(startColumn, startRow);
            end = new Address(endColumn, endRow);
        } else if (startColumn < endColumn && startRow >= endRow) {
            start = new Address(startColumn, endRow);
            end = new Address(endColumn, startRow);
        } else if (startColumn >= endColumn && startRow < endRow) {
            start = new Address(endColumn, startRow);
            end = new Address(startColumn, endRow);
        } else {
            start = new Address(endColumn, endRow);
            end = new Address(startColumn, startRow);
        }
        return new Range(start, end);
    }
}

