/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.Helper;
import ch.rabanti.nanoxlsx4j.exceptions.FormatException;

public class Metadata {
    private String application = "NanoXLSX4j";
    private String applicationVersion = "1.2800";
    private String category;
    private String company;
    private String contentStatus;
    private String creator;
    private String description;
    private String hyperlinkBase;
    private String keywords;
    private String manager;
    private String subject;
    private String title;
    private boolean useColorMRU = false;

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
        this.checkVersion();
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getContentStatus() {
        return this.contentStatus;
    }

    public void setContentStatus(String contentStatus) {
        this.contentStatus = contentStatus;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHyperlinkBase() {
        return this.hyperlinkBase;
    }

    public void setHyperlinkBase(String hyperlinkBase) {
        this.hyperlinkBase = hyperlinkBase;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isUseColorMRU() {
        return this.useColorMRU;
    }

    public void setUseColorMRU(boolean useColorMRU) {
        this.useColorMRU = useColorMRU;
    }

    private void checkVersion() {
        if (Helper.isNullOrEmpty(this.applicationVersion)) {
            return;
        }
        String[] split = this.applicationVersion.split(".");
        boolean state = true;
        if (split.length != 2) {
            state = false;
        } else {
            if (split[1].length() < 1 || split[1].length() > 5) {
                state = false;
            }
            if (split[0].length() < 1 || split[0].length() > 5) {
                state = false;
            }
        }
        if (!state) {
            throw new FormatException("FormatException", "The format of the version in the meta data is wrong (" + this.applicationVersion + "). Should be in the format and a range from '0.0' to '99999.99999'");
        }
    }

    public static String parseVersion(int major, int minor, int build, int revision) {
        if (major < 0 || minor < 0 || build < 0 || revision < 0) {
            throw new FormatException("FormatException", "The format of the passed version is wrong. No negative number allowed.");
        }
        if (major > 99999) {
            throw new FormatException("FormatException", "The major number may not be bigger than 99999. The passed value is " + major);
        }
        String leftPart = Integer.toString(major);
        String rightPart = Integer.toString(minor) + build + revision;
        if ((rightPart = rightPart.replaceAll("0+$", "")).length() == 0) {
            rightPart = "0";
        } else if (rightPart.length() > 5) {
            rightPart = rightPart.substring(0, 5);
        }
        return leftPart + "." + rightPart;
    }
}

