/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.exceptions.FormatException;
import java.util.Calendar;
import java.util.Date;

public class Helper {
    private static final long ROOT_TICKS;

    public static double getOADate(Date date) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        long currentTicks = dateCal.getTimeInMillis();
        double d = (double)(dateCal.get(13) + dateCal.get(12) * 60 + dateCal.get(11) * 3600) / 86400.0 + Math.floor((currentTicks - ROOT_TICKS) / 86400000L);
        if (d < 0.0) {
            throw new FormatException("FormatException", "The date is not in a valid range for Excel. Dates before 1900-01-01 are not allowed.");
        }
        return d;
    }

    public static Date getDateFromOA(double oaDate) {
        double remainder = oaDate - (double)((long)oaDate);
        double hours = remainder * 24.0;
        double minutes = (hours - (double)((long)hours)) * 60.0;
        double seconds = (minutes - (double)((long)minutes)) * 60.0;
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTimeInMillis(ROOT_TICKS);
        dateCal.add(5, (int)oaDate);
        dateCal.add(10, (int)hours);
        dateCal.add(12, (int)minutes);
        dateCal.add(13, (int)seconds + 1);
        return dateCal.getTime();
    }

    public static boolean isNullOrEmpty(String value) {
        if (value == null) {
            return true;
        }
        return value.isEmpty();
    }

    static {
        Calendar rootCalendar = Calendar.getInstance();
        rootCalendar.set(1899, 11, 30, 0, 0, 0);
        ROOT_TICKS = rootCalendar.getTimeInMillis();
    }
}

