/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.Address;
import ch.rabanti.nanoxlsx4j.Helper;
import ch.rabanti.nanoxlsx4j.Range;
import ch.rabanti.nanoxlsx4j.Worksheet;
import ch.rabanti.nanoxlsx4j.exceptions.FormatException;
import ch.rabanti.nanoxlsx4j.exceptions.RangeException;
import ch.rabanti.nanoxlsx4j.exceptions.StyleException;
import ch.rabanti.nanoxlsx4j.styles.Style;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cell
implements Comparable<Cell> {
    private Style cellStyle;
    private int columnNumber;
    private CellType dataType;
    private int rowNumber;
    private Object value;
    private Worksheet worksheetReference;

    public String getCellAddress() {
        return Cell.resolveCellAddress(this.columnNumber, this.rowNumber);
    }

    public void setCellAddress(String address) {
        Address temp = Cell.resolveCellCoordinate(address);
        this.columnNumber = temp.Column;
        this.rowNumber = temp.Row;
    }

    public Address getCellAddress2() {
        return new Address(this.columnNumber, this.rowNumber);
    }

    public void setCellAddress2(Address address) {
        this.setColumnNumber(address.Column);
        this.setRowNumber(address.Row);
    }

    public Style getCellStyle() {
        return this.cellStyle;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        if (columnNumber < 0 || columnNumber > 16383) {
            throw new RangeException("OutOfRangeException", "The passed number (" + columnNumber + ")is out of range. Range is from " + 0 + " to " + 16383 + " (" + 16384 + " rows).");
        }
        this.columnNumber = columnNumber;
    }

    public CellType getDataType() {
        return this.dataType;
    }

    public void setDataType(CellType dataType) {
        this.dataType = dataType;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        if (rowNumber < 0 || rowNumber > 1048575) {
            throw new RangeException("OutOfRangeException", "The passed number (" + rowNumber + ")is out of range. Range is from " + 0 + " to " + 1048575 + " (" + 0x100000 + " rows).");
        }
        this.rowNumber = rowNumber;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Worksheet getWorksheetReference() {
        return this.worksheetReference;
    }

    public void setWorksheetReference(Worksheet reference) {
        this.worksheetReference = reference;
    }

    public Cell() {
        this.worksheetReference = null;
        this.dataType = CellType.DEFAULT;
    }

    public Cell(Object value, CellType type) {
        this.dataType = type;
        this.value = value;
        if (type == CellType.DEFAULT) {
            this.resolveCellType();
        }
    }

    public Cell(Object value, CellType type, String address) {
        this.dataType = type;
        this.value = value;
        this.setCellAddress(address);
        this.worksheetReference = null;
        if (type == CellType.DEFAULT) {
            this.resolveCellType();
        }
    }

    public Cell(Object value, CellType type, int column, int row, Worksheet reference) {
        this.dataType = type;
        this.value = value;
        this.columnNumber = column;
        this.rowNumber = row;
        this.worksheetReference = reference;
        if (type == CellType.DEFAULT) {
            this.resolveCellType();
        }
    }

    @Override
    public int compareTo(Cell o) {
        if (this.rowNumber == o.rowNumber) {
            return Integer.compare(this.columnNumber, o.getColumnNumber());
        }
        return Integer.compare(this.rowNumber, o.getRowNumber());
    }

    public void removeStyle() {
        if (this.worksheetReference == null) {
            throw new StyleException("MissingReferenceException", "No worksheet reference was defined while trying to remove a style from a cell");
        }
        if (this.worksheetReference.getWorkbookReference() == null) {
            throw new StyleException("MissingReferenceException", "No workbook reference was defined on the worksheet while trying to remove a style from a cell");
        }
        if (this.cellStyle != null) {
            String styleName = this.cellStyle.getName();
            this.cellStyle = null;
            this.worksheetReference.getWorkbookReference().removeStyle(styleName, true);
        }
    }

    public void resolveCellType() {
        if (this.value == null) {
            this.setDataType(CellType.EMPTY);
            this.value = "";
            return;
        }
        if (this.dataType == CellType.FORMULA || this.dataType == CellType.EMPTY) {
            return;
        }
        this.dataType = this.value instanceof Boolean ? CellType.BOOL : (this.value instanceof Byte ? CellType.NUMBER : (this.value instanceof BigDecimal ? CellType.NUMBER : (this.value instanceof Double ? CellType.NUMBER : (this.value instanceof Float ? CellType.NUMBER : (this.value instanceof Integer ? CellType.NUMBER : (this.value instanceof Long ? CellType.NUMBER : (this.value instanceof Short ? CellType.NUMBER : (this.value instanceof Date ? CellType.DATE : CellType.STRING))))))));
    }

    public void setCellLockedState(boolean isLocked, boolean isHidden) {
        Style lockStyle = this.cellStyle == null ? new Style() : this.cellStyle.copyStyle();
        lockStyle.getCellXf().setLocked(isLocked);
        lockStyle.getCellXf().setHidden(isHidden);
        try {
            this.setStyle(lockStyle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Style setStyle(Style style) {
        Style s;
        if (this.worksheetReference == null) {
            throw new StyleException("MissingReferenceException", "No worksheet reference was defined while trying to set a style to a cell");
        }
        if (this.worksheetReference.getWorkbookReference() == null) {
            throw new StyleException("MissingReferenceException", "No workbook reference was defined on the worksheet while trying to set a style to a cell");
        }
        if (style == null) {
            throw new StyleException("MissingReferenceException", "No style to assign was defined");
        }
        this.cellStyle = s = this.worksheetReference.getWorkbookReference().addStyle(style);
        return s;
    }

    public static List<Address> getCellRange(int startColumn, int startRow, int endColumn, int endRow) {
        Address start = new Address(startColumn, startRow);
        Address end = new Address(endColumn, endRow);
        return Cell.getCellRange(start, end);
    }

    public static <T> List<Cell> convertArray(List<T> list) {
        ArrayList<Cell> output = new ArrayList<Cell>();
        for (int i = 0; i < list.size(); ++i) {
            T o = list.get(i);
            if (o instanceof Boolean) {
                Cell cell = new Cell(o, CellType.BOOL);
            }
            Cell c2 = o instanceof Byte ? new Cell(o, CellType.NUMBER) : (o instanceof BigDecimal ? new Cell(o, CellType.NUMBER) : (o instanceof Double ? new Cell(o, CellType.NUMBER) : (o instanceof Float ? new Cell(o, CellType.NUMBER) : (o instanceof Integer ? new Cell(o, CellType.NUMBER) : (o instanceof Long ? new Cell(o, CellType.NUMBER) : (o instanceof Short ? new Cell(o, CellType.NUMBER) : (o instanceof Date ? new Cell(o, CellType.DATE) : (o instanceof String ? new Cell(o, CellType.STRING) : new Cell(o, CellType.DEFAULT)))))))));
            output.add(c2);
        }
        return output;
    }

    public static List<Address> getCellRange(String range) {
        Range range2 = Cell.resolveCellRange(range);
        return Cell.getCellRange(range2.StartAddress, range2.EndAddress);
    }

    public static List<Address> getCellRange(String startAddress, String endAddress) {
        Address start = Cell.resolveCellCoordinate(startAddress);
        Address end = Cell.resolveCellCoordinate(endAddress);
        return Cell.getCellRange(start, end);
    }

    public static List<Address> getCellRange(Address startAddress, Address endAddress) {
        int endRow;
        int startRow;
        int endColumn;
        int startColumn;
        if (startAddress.Column < endAddress.Column) {
            startColumn = startAddress.Column;
            endColumn = endAddress.Column;
        } else {
            startColumn = endAddress.Column;
            endColumn = startAddress.Column;
        }
        if (startAddress.Row < endAddress.Row) {
            startRow = startAddress.Row;
            endRow = endAddress.Row;
        } else {
            startRow = endAddress.Row;
            endRow = startAddress.Row;
        }
        ArrayList<Address> output = new ArrayList<Address>();
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startColumn; j <= endColumn; ++j) {
                output.add(new Address(j, i));
            }
        }
        return output;
    }

    public static String resolveCellAddress(int column, int row) {
        return Cell.resolveCellAddress(column, row, AddressType.Default);
    }

    public static String resolveCellAddress(int column, int row, AddressType type) {
        Cell.validateColumnNumber(column);
        Cell.validateRowNumber(row);
        switch (type) {
            case FixedRowAndColumn: {
                return "$" + Cell.resolveColumnAddress(column) + "$" + (row + 1);
            }
            case FixedColumn: {
                return "$" + Cell.resolveColumnAddress(column) + (row + 1);
            }
            case FixedRow: {
                return Cell.resolveColumnAddress(column) + "$" + (row + 1);
            }
        }
        return Cell.resolveColumnAddress(column) + (row + 1);
    }

    public static Address resolveCellCoordinate(String address) {
        if (Helper.isNullOrEmpty(address)) {
            throw new FormatException("FormatException", "The cell address is null or empty and could not be resolved");
        }
        address = address.toUpperCase();
        Pattern pattern = Pattern.compile("(^(\\$?)([A-Z]{1,3})(\\$?)([0-9]{1,7})$)");
        Matcher mx = pattern.matcher(address);
        if (mx.groupCount() != 5) {
            throw new FormatException("FormatException", "The format of the cell address (" + address + ") is malformed");
        }
        mx.find();
        int digits = Integer.parseInt(mx.group(5));
        int column = Cell.resolveColumn(mx.group(3));
        int row = digits - 1;
        if (!mx.group(2).isEmpty() && !mx.group(4).isEmpty()) {
            return new Address(column, row, AddressType.FixedRowAndColumn);
        }
        if (!mx.group(2).isEmpty() && mx.group(4).isEmpty()) {
            return new Address(column, row, AddressType.FixedColumn);
        }
        if (mx.group(2).isEmpty() && !mx.group(4).isEmpty()) {
            return new Address(column, row, AddressType.FixedRow);
        }
        return new Address(column, row, AddressType.Default);
    }

    public static Range resolveCellRange(String range) {
        if (Helper.isNullOrEmpty(range)) {
            throw new FormatException("FormatException", "The cell range is null or empty and could not be resolved");
        }
        String[] split = range.split(":");
        if (split.length != 2) {
            throw new FormatException("FormatException", "The cell range (" + range + ") is malformed and could not be resolved");
        }
        try {
            Address start = Cell.resolveCellCoordinate(split[0]);
            Address end = Cell.resolveCellCoordinate(split[1]);
            return new Range(start, end);
        }
        catch (Exception e) {
            throw new FormatException("FormatException", "The start address or end address could not be resolved. See inner exception", e);
        }
    }

    public static int resolveColumn(String columnAddress) {
        int result = 0;
        int multiplier = 1;
        for (int i = columnAddress.length() - 1; i >= 0; --i) {
            int chr = columnAddress.charAt(i);
            result += (chr -= 64) * multiplier;
            multiplier *= 26;
        }
        Cell.validateColumnNumber(result - 1);
        return result - 1;
    }

    public static String resolveColumnAddress(int columnNumber) {
        Cell.validateColumnNumber(columnNumber);
        int j = 0;
        int k = 0;
        int l = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= columnNumber; ++i) {
            if (j > 25) {
                ++k;
                j = 0;
            }
            if (k > 25) {
                ++l;
                k = 0;
            }
            ++j;
        }
        if (l > 0) {
            sb.append((char)(l + 64));
        }
        if (k > 0) {
            sb.append((char)(k + 64));
        }
        sb.append((char)(j + 64));
        return sb.toString();
    }

    static void validateColumnNumber(int columnNumber) {
        if (columnNumber > 16383 || columnNumber < 0) {
            throw new RangeException("OutOfRangeException", "The column number (" + columnNumber + ") is out of range. Range is from " + 0 + " to " + 16383 + " (" + 16384 + " columns).");
        }
    }

    static void validateRowNumber(int rowNumber) {
        if (rowNumber > 1048575 || rowNumber < 0) {
            throw new RangeException("OutOfRangeException", "The row number (" + rowNumber + ") is out of range. Range is from " + 0 + " to " + 1048575 + " (" + 0x100000 + " rows).");
        }
    }

    public static enum AddressType {
        Default,
        FixedRow,
        FixedColumn,
        FixedRowAndColumn;

    }

    public static enum CellType {
        STRING,
        NUMBER,
        DATE,
        BOOL,
        FORMULA,
        EMPTY,
        DEFAULT;

    }
}

