/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.Address;
import ch.rabanti.nanoxlsx4j.Cell;
import ch.rabanti.nanoxlsx4j.Range;
import ch.rabanti.nanoxlsx4j.Worksheet;
import ch.rabanti.nanoxlsx4j.exceptions.FormatException;
import java.math.BigDecimal;

public final class BasicFormulas {
    public static Cell Average(Range range) {
        return BasicFormulas.Average(null, range);
    }

    public static Cell Average(Worksheet target, Range range) {
        return BasicFormulas.getBasicFormula(target, range, "AVERAGE", null);
    }

    public static Cell Ceil(Address address, int decimals) {
        return BasicFormulas.Ceil(null, address, decimals);
    }

    public static Cell Ceil(Worksheet target, Address address, int decimals) {
        return BasicFormulas.getBasicFormula(target, new Range(address, address), "ROUNDUP", Integer.toString(decimals));
    }

    public static Cell Floor(Address address, int decimals) {
        return BasicFormulas.Floor(null, address, decimals);
    }

    public static Cell Floor(Worksheet target, Address address, int decimals) {
        return BasicFormulas.getBasicFormula(target, new Range(address, address), "ROUNDDOWN", Integer.toString(decimals));
    }

    public static Cell Max(Range range) {
        return BasicFormulas.Max(null, range);
    }

    public static Cell Max(Worksheet target, Range range) {
        return BasicFormulas.getBasicFormula(target, range, "MAX", null);
    }

    public static Cell Median(Range range) {
        return BasicFormulas.Median(null, range);
    }

    public static Cell Median(Worksheet target, Range range) {
        return BasicFormulas.getBasicFormula(target, range, "MEDIAN", null);
    }

    public static Cell Min(Range range) {
        return BasicFormulas.Min(null, range);
    }

    public static Cell Min(Worksheet target, Range range) {
        return BasicFormulas.getBasicFormula(target, range, "MIN", null);
    }

    public static Cell Round(Address address, int decimals) {
        return BasicFormulas.Round(null, address, decimals);
    }

    public static Cell Round(Worksheet target, Address address, int decimals) {
        return BasicFormulas.getBasicFormula(target, new Range(address, address), "ROUND", Integer.toString(decimals));
    }

    public static Cell Sum(Range range) {
        return BasicFormulas.Sum(null, range);
    }

    public static Cell Sum(Worksheet target, Range range) {
        return BasicFormulas.getBasicFormula(target, range, "SUM", null);
    }

    public static Cell VLookup(Object number, Range range, int columnIndex, boolean exactMatch) {
        return BasicFormulas.VLookup(number, null, range, columnIndex, exactMatch);
    }

    public static Cell VLookup(Object number, Worksheet rangeTarget, Range range, int columnIndex, boolean exactMatch) {
        return BasicFormulas.getVLookup(null, null, number, rangeTarget, range, columnIndex, exactMatch, true);
    }

    public static Cell VLookup(Address address, Range range, int columnIndex, boolean exactMatch) {
        return BasicFormulas.VLookup(null, address, null, range, columnIndex, exactMatch);
    }

    public static Cell VLookup(Worksheet queryTarget, Address address, Worksheet rangeTarget, Range range, int columnIndex, boolean exactMatch) {
        return BasicFormulas.getVLookup(queryTarget, address, 0, rangeTarget, range, columnIndex, exactMatch, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Cell getVLookup(Worksheet queryTarget, Address address, Object number, Worksheet rangeTarget, Range range, int columnIndex, boolean exactMatch, boolean numericLookup) {
        String arg1;
        if (numericLookup) {
            if (number instanceof Byte) {
                arg1 = Byte.toString((Byte)number);
            } else if (number instanceof BigDecimal) {
                arg1 = number.toString();
            } else if (number instanceof Double) {
                arg1 = Double.toString((Double)number);
            } else if (number instanceof Float) {
                arg1 = Float.toString(((Float)number).floatValue());
            } else if (number instanceof Integer) {
                arg1 = Integer.toString((Integer)number);
            } else if (number instanceof Long) {
                arg1 = Long.toString((Long)number);
            } else {
                if (!(number instanceof Short)) throw new FormatException("InvalidLookupType", "The lookup variable can only be a cell address or a numeric value. The value '" + number + "' is invalid.");
                arg1 = Short.toString((Short)number);
            }
        } else {
            arg1 = queryTarget != null ? queryTarget.getSheetName() + "!" + address.toString() : address.toString();
        }
        String arg2 = rangeTarget != null ? rangeTarget.getSheetName() + "!" + range.toString() : range.toString();
        String arg3 = Integer.toString(columnIndex);
        String arg4 = exactMatch ? "TRUE" : "FALSE";
        return new Cell("VLOOKUP(" + arg1 + "," + arg2 + "," + arg3 + "," + arg4 + ")", Cell.CellType.FORMULA);
    }

    private static Cell getBasicFormula(Worksheet target, Range range, String functionName, String postArg) {
        String arg2 = postArg == null ? "" : "," + postArg;
        String prefix = target != null ? target.getSheetName() + "!" : "";
        String arg1 = range.StartAddress.equals(range.EndAddress) ? prefix + range.StartAddress.toString() : prefix + range.toString();
        return new Cell(functionName + "(" + arg1 + arg2 + ")", Cell.CellType.FORMULA);
    }
}

