/*
 * Decompiled with CFR 0.152.
 */
package ch.rabanti.nanoxlsx4j;

import ch.rabanti.nanoxlsx4j.Cell;

public class Address
implements Comparable<Address> {
    public final int Column;
    public final int Row;
    public final Cell.AddressType Type;

    public Address(int column, int row) {
        Cell.validateRowNumber(row);
        Cell.validateColumnNumber(column);
        this.Column = column;
        this.Row = row;
        this.Type = Cell.AddressType.Default;
    }

    public Address(String address) {
        Address a = Cell.resolveCellCoordinate(address);
        this.Column = a.Column;
        this.Row = a.Row;
        this.Type = a.Type;
    }

    public Address(int column, int row, Cell.AddressType type) {
        Cell.validateRowNumber(row);
        Cell.validateColumnNumber(column);
        this.Column = column;
        this.Row = row;
        this.Type = type;
    }

    public Address(String address, Cell.AddressType type) {
        this.Type = type;
        Address a = Cell.resolveCellCoordinate(address);
        this.Column = a.Column;
        this.Row = a.Row;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return this.Row == address.Row && this.Column == address.Column;
    }

    @Override
    public int compareTo(Address other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.Column <= other.Column && this.Row <= other.Row) {
            return -1;
        }
        return 1;
    }

    public String getAddress() {
        return Cell.resolveCellAddress(this.Column, this.Row, this.Type);
    }

    public String getColumn() {
        return Cell.resolveColumnAddress(this.Column);
    }

    public String toString() {
        return this.getAddress();
    }
}

